#ifndef OBJ_H
#define OBJ_H

#include <allegro.h>
#include <fblend.h>

#include "iso.h"
#include "vect.h"

///////////
// Powerup ids.

const int ID_STARBALL=1;


//////////////////////////////////////
//// MAP STUFF ///////////////////////
//////////////////////////////////////

const int MAP_MAX_X=50;
const int MAP_MAX_Y=50;
const int MAP_MAX_Z=5;

extern int map_size_x;
extern int map_size_y;
extern int map_size_z;

extern int map_player_x;
extern int map_player_y;

struct MapPoint {
  int tile;

};


extern MapPoint map[MAP_MAX_X][MAP_MAX_Y][MAP_MAX_Z];
extern int map_find_height(int x, int y);
extern bool map_blocked(int x, int y, int z);

extern int map_generate();

//////////////////////////////////////
//// GAME OBJECT /////////////////////
//////////////////////////////////////

class GameObj {
  public:
  GameObj() { 
    x_vel = 0;
    y_vel = 0;
    z_vel = 0;
  }
  virtual ~GameObj() { }
  
  int setx(double nx) { return (int)(x=nx); }
  int sety(double ny) { return (int)(y=ny); }
  int setz(double nz) { return (int)(z=nz); }
  
  int setxd(int nx) { return (x_dim = nx); }
  int setyd(int ny) { return (y_dim = ny); }
  int setzd(int nz) { return (z_dim = nz); }

  int setxv(double nx) { return (int)(x_vel=nx); }
  int setyv(double ny) { return (int)(y_vel=ny); }
  int setzv(double nz) { return (int)(z_vel=nz); }
  
  int getx() const { return (int)x; }
  int gety() const { return (int)y; }
  int getz() const { return (int)z; }

  int getx1() const { return (getx()-x_dim); }
  int getx2() const { return (getx()+x_dim); }    
  int gety1() const { return (gety()-y_dim); }
  int gety2() const { return (gety()+y_dim); }    
  int getz1() const { return (getz()+z_dim); }
  int getz2() const { return getz(); }    
  
  int getxt() const { return (getx() / TILE_XY); }
  int getyt() const { return (gety() / TILE_XY); }
  int getzt() const { return (getz() / TILE_Z); }

  int getx1t() const { return (getx1() / TILE_XY); }
  int gety1t() const { return (gety1() / TILE_XY); }
  int getz1t() const { return (getz1() / TILE_Z); }

  int getx2t() const { return (getx2() / TILE_XY); }
  int gety2t() const { return (gety2() / TILE_XY); }
  int getz2t() const { return (getz2() / TILE_Z); }

  int getxc() const { return (x_draw); }    
  int getyc() const { return (y_draw); }    
  int getx1c() const { return (getx()-x_dim+getxc()); }
  int getx2c() const { return (getx()+x_dim-getxc()); }    
  int gety1c() const { return (gety()-y_dim+getyc()); }
  int gety2c() const { return (gety()+y_dim-getyc()); }    

  bool operator< (GameObj &o) {
    if (gety2t() < o.gety2t())
      return true;
    if (gety2t() > o.gety2t())
      return false;
    if (getx2t() < o.getx2t())
      return true;
    if (getx2t() > o.getx2t())
      return false;
    if (tile2screenY(getx(), gety(), 0) < tile2screenY(o.getx(), o.gety(), 0))
      return true;
    return false;
  }
 
  bool on_screen(BITMAP*buf, int offx, int offy);
  
  virtual void draw(BITMAP *buf, int offx, int offy) { }
  virtual void draw_shadow(BITMAP *buf, int offx, int offy, int shadow) { }
  virtual bool animate() { }
  
  bool hit(GameObj *o);
  
  protected:
 
//  void _draw(BITMAP *buf, BITMAP *sprite, int offx, int offy, bool flip);
  virtual void _draw_shadow(BITMAP *buf, int offx, int offy, int shadow) { }
  
  bool _blocked_x(int n);
  bool _blocked_y(int n);
  bool _blocked_z(int n);
  
  bool _move_x(double xv);
  bool _move_y(double yv);
  bool _move_z(double zv);
  
  void _check_speed(double m);
  void _slow_down(double f);
  
  double x, y, z;
  int x_dim, y_dim, z_dim;
  int x_draw, y_draw;

  double x_vel, y_vel, z_vel;
  
  int anim_time;
  int anim_cycl;


};

//extern bool operator< (const GameObj &s, const GameObj &o);


//////////////////////////////////////
//// PLAYER OBJECT STUFF /////////////
//////////////////////////////////////

class PlayerObj : public GameObj {
  public:
  PlayerObj() : GameObj() {
    setxd(8);
    setyd(8);
    setzd(8);
    x_draw=4;
    y_draw=4;
    cup = false;
    cleft = false;
    cright = false;
    cjump = false;
    anim_time=1;
    anim_cycl=0;
    max_speed=3;
    acc_force=0.05;
    grav_force=-0.25;
    jump_force=5;
    frict_force=0.01;
    bounce_lossXY=0.65;
    bounce_lossZ=0.35;
    bounce_minXY=0.5;
    bounce_minZ=-0.5;
    reset();
    
  }
  virtual ~PlayerObj () { }
  
  void reset() {
    x_vel=0;
    y_vel=0;
    z_vel=0;
    angle=90;
  }
  
  virtual void draw(BITMAP *buf, int offx, int offy);
  virtual void draw_shadow(BITMAP *buf, int offx, int offy, int shadow);
  virtual bool animate();
  
  void set_control(bool up, bool left, bool right, bool jump);
  protected:  

  bool cup, cleft, cright, cjump;
  bool can_jump;

  int angle;
  int max_speed;
  double acc_force, grav_force, jump_force, frict_force;
  double bounce_lossXY, bounce_lossZ, bounce_minZ, bounce_minXY;
  

};

//////////////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////// 

//////////////////////////////////////
//// POWERUP OBJECT STUFF ////////////
//////////////////////////////////////

class PowerupObj : public GameObj {
  public:
  PowerupObj(int nx, int ny, int nz) : GameObj() {
    setx(nx);
    sety(ny);
    setz(nz);
    setxd(8);
    setyd(8);
    setzd(8);
    x_draw=4;
    y_draw=4;
    grav_force=-0.10;
    bounce_lossZ=0.35;
    bounce_minZ=-0.5;
  }
  
  int id() const { return _id; }
  virtual void draw_shadow(BITMAP *buf, int offx, int offy, int shadow);
  
  protected:
  int _anim();
  int _id;  
  double grav_force;
  double bounce_lossZ, bounce_minZ;
};


//////////////////////////////////////
//// BALL OBJECT STUFF ///////////////
//////////////////////////////////////

class BallObj : public PowerupObj {
  public:
  BallObj(int nx, int ny, int nz) : PowerupObj(nx, ny, nz) {
    anim_time = 10;
    anim_cycl = 0;
    bn = rand() % 6;
    _id=ID_STARBALL;
  }

  virtual void draw(BITMAP *buf, int offx, int offy);
  virtual bool animate();

  protected:
  int bn;
};

//////////////////////////////////////////////////////////////////// 
//////////////////////////////////////////////////////////////////// 

//////////////////////////////////////
//// PARTICLE OBJECT STUFF ///////////
//////////////////////////////////////

class ParticleObj : public GameObj {
  public:
  ParticleObj(int nx, int ny, int nz, int a1, int a2, double f,
              double g, double b, int bit, long lifetime);  
  int id() const { return _id; }

  virtual void draw(BITMAP *buf, int offx, int offy);
  virtual void draw_shadow(BITMAP *buf, int offx, int offy, int shadow);
  virtual bool animate();
  
  protected:
  int _id;
  int spr;
  long lifet;
  long lifecounter;
  double bounce;
  double grav;
};

class GrabParticleObj : public ParticleObj {
  public:
  GrabParticleObj(int nx, int ny, int nz, int a1, int a2, double f, int bit=1) :
    ParticleObj(nx, ny, nz, a1, a2, f, 0.1, 0.75, bit, 200) { };
};


#endif

