#include <allegro.h>
#include <fblend.h>
#include "graphic.h"
#include "iso.h"
#include "obj.h"
#include "game.h"
#include "timer.h"
#include "mandelbrot.h"
#include "time.h"
#include "player.h"

/***************************
   
   Instructions on how to view the easter egg...
     1. Get between 150 and 200 points.
     2. Die at leaste once
     3. Get more than 200 points.
     4. Jump into the K next to where you start.

 **************************/

void display_help(BITMAP *buffer, BITMAP*mandel);

int main() {
  srand(time(0));
  BITMAP *buffer, *mandel;
  allegro_init();
  install_keyboard();
  install_timer();
  
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)==0) {
    sound_on=true;
  }
    
  init_game_timer();

  short depths[4] = {16, 24, 32, 15};
  int a;
  for (a=0;a<4;a++) {
    set_color_depth(depths[a]);
    if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0)==0) {
      break;
    }
  }
  if (a==4) {
    for (a=0;a<4;a++) {
      set_color_depth(depths[a]);
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0)==0) {
        break;
      }
    }
    if (a==4)
      return 1;
  }
  set_color_conversion(COLORCONV_TOTAL);
  load_graphic();  
  buffer = create_bitmap(640, 480);
  mandel = create_bitmap(640, 480);
  mandelbrot(mandel);
  text_mode(-1);
  textout_right(mandel, font, "Allegro SpeedHack 2003 Entry Version", 630, 460, makecol(255, 255, 255));
  textout_right(mandel, font, "Copyright (c) 2003 Kristian Hiim", 630, 470, makecol(255, 255, 255));
  load_highscore();
  map_generate();
  int result;
  int is_on=0;
  do {
    do {
      blit(mandel, buffer, 0, 0, 0, 0, 640, 480);
      text_mode(-1);
      
      textout(buffer, gfont, "Super", 5, 5, -1);
      textout(buffer, gfont, "Extreme", 15, 35, -1);
      textout(buffer, gfont, "SpeedHack", 25, 65, -1);
      textout(buffer, gfont, "Hovercraft", 35, 95, -1);
      textout(buffer, gfont, "2003", 45, 125, -1);
      
      if (is_on==0)
        textout(buffer, gfont, "> Start <", 310, 180, -1);
      else
        textout(buffer, gfont, " Start", 310, 180, -1);
      if (is_on==1)
        textout(buffer, gfont, "> Help <", 310, 220, -1);
      else
        textout(buffer, gfont, " Help", 310, 220, -1);
      if (is_on==2)
        textout(buffer, gfont, "> Quit <", 310, 260, -1);
      else
        textout(buffer, gfont, " Quit", 310, 260, -1);
      blit(buffer, screen, 0, 0, 0, 0, 640, 480);
      clear_keybuf();
      result = readkey();
      if ((result >> 8) == KEY_UP)
        if (--is_on < 0)
          is_on=2;
      if ((result >> 8) == KEY_DOWN)
        is_on = (is_on+1) % 3;
    } while ( ((result & 0xff) != ' ') &&
              ((result & 0xff) != 13));
    if (is_on==0)
      play_map();
      
    if (is_on==1) {
      // help - instructions on how to play
      display_help(buffer, mandel);

    }

  } while (is_on!=2);
  
  destroy_bitmap(buffer);
  destroy_bitmap(mandel);
  unload_graphic();
  save_highscore();
  return 0;
}
END_OF_MAIN();

void display_help(BITMAP*buffer, BITMAP*mandel) {
      blit(mandel, buffer, 0, 0, 0, 0, 640, 480);
      text_mode(-1);
      textout(buffer, gfont, "Help", 10, 10, -1);

      draw_sprite(buffer, gfx_help[0], 40, 80);
      
      textout(buffer, font, "In this game, you control a hovercraft.", 140, 80, makecol(255, 255, 255));
      textout(buffer, font, "Use the arrow key up to move forward,", 140, 90, makecol(255, 255, 255));
      textout(buffer, font, "and left and right to turn.", 140, 100, makecol(255, 255, 255));
      textout(buffer, font, "There's no brakes on this thing... :-)", 140, 110, makecol(255, 255, 255));
      textout(buffer, font, "You can jump with space.", 140, 120, makecol(255, 255, 255));

      draw_sprite(buffer, gfx_help[1], 60, 200);

      textout(buffer, font, "You must gather as many points as possible", 160, 200, makecol(255, 255, 255));
      textout(buffer, font, "by picking up starballs, before you run out", 160, 210, makecol(255, 255, 255));
      textout(buffer, font, "of time. You have 3 minutes.", 160, 220, makecol(255, 255, 255));

      draw_sprite(buffer, gfx_help[2], 80, 320);

      textout(buffer, font, "If you fall off the map, you will explode.", 180, 320, makecol(255, 255, 255));
      textout(buffer, font, "After a while, you will return to the starting", 180, 330, makecol(255, 255, 255));
      textout(buffer, font, "position. You only lose time if this happens.", 180, 340, makecol(255, 255, 255));
      blit(buffer, screen, 0, 0, 0, 0, 640, 480);
      readkey();

}

