#include "graphic.h"
#include "gfx.h"

const int MAX_SOUND_SAMPLE=3;

bool sound_on=false;
SAMPLE* sound_sample[MAX_SOUND_SAMPLE];

BITMAP* gfx_tile[MAX_TILE_GFX];
BITMAP* gfx_player[MAX_PLAYER_GFX];
BITMAP* gfx_shadow[MAX_SHADOW_GFX];
BITMAP* gfx_ball[MAX_BALL_GFX];
BITMAP* gfx_part[MAX_PART_GFX];
BITMAP* gfx_help[MAX_HELP_GFX];

BITMAP* gfx_star;
FONT* gfont;

DATAFILE* gfx_data;

int load_graphic() {
  gfx_data = load_datafile("gfx.dat");
  if (gfx_data==NULL)
    return 0;
  for (int a=0; a<MAX_TILE_GFX; a++)
    gfx_tile[a] = (BITMAP *)gfx_data[TILE_001+a].dat;
  for (int a=0; a<MAX_PLAYER_GFX; a++)
    gfx_player[a] = (BITMAP *)gfx_data[PLAYER_0+a].dat;
  for (int a=0; a<MAX_SHADOW_GFX; a++)
    gfx_shadow[a] = (BITMAP *)gfx_data[SHADOW_0+a].dat;
  for (int a=0; a<MAX_BALL_GFX; a++)
    gfx_ball[a] = (BITMAP *)gfx_data[BALL_0+a].dat;
  for (int a=0; a<MAX_PART_GFX; a++)
    gfx_part[a] = (BITMAP *)gfx_data[PART0+a].dat;
  for (int a=0; a<MAX_HELP_GFX; a++)
    gfx_help[a] = (BITMAP *)gfx_data[HELP0+a].dat;
  gfx_star = (BITMAP *)gfx_data[STAR].dat;

  if (sound_on) {
    for (int a=0; a<MAX_SOUND_SAMPLE; a++)
      sound_sample[a] = (SAMPLE *)gfx_data[SOUND_01+a].dat;
  }
  
  gfont = (FONT*)gfx_data[GAME_FONT].dat;
  set_palette(*((PALETTE*)gfx_data[GAME_FONT_PAL].dat));
  return 1;
}

void unload_graphic() {
  unload_datafile(gfx_data);
}

void play_s(int nr) {
  if (sound_on)
    play_sample(sound_sample[nr], 255, 128, 0, 0);
}


