#include "vect.h"

double mkX(double angle, double force) {
  return ((cos(angle*PI/180.0) * force));
}

double mkY(double angle, double force) {
  return ((sin(angle*PI/180.0) * force));
}

double mkZ(double angle, double force) {
  return ((sin(angle*PI/180.0) * force));
}

double getangle(double xv, double yv) {
  double a = ((atan(yv/xv)*180/PI));
  if ((xv>0) && (yv>0))
    return a;
  if ((xv<0) && (yv>0))
    return 180+a;
  if ((xv<0) && (yv<0))
    return 180+a;
  if ((xv>0) && (yv<0))
    return 360+a;
  return 0;
}

