#include "obj.h"

#include "graphic.h"


//////////////////////////////////////
//// MAP STUFF ///////////////////////
//////////////////////////////////////

int map_size_x=MAP_MAX_X;
int map_size_y=MAP_MAX_Y;
int map_size_z=MAP_MAX_Z;

int map_player_x=100;
int map_player_y=100;


MapPoint map[MAP_MAX_X][MAP_MAX_Y][MAP_MAX_Z];

int map_find_height(int x, int y) {
  if (x<0) return -1;
  if (x>=map_size_x) return -1;
  if (y<0) return -1;
  if (y>=map_size_y) return -1;
  int z;
  for (z=0;z<map_size_z;z++) {
    if (map[x][y][z].tile==0)
      break;
  }
  return z;
}

bool map_blocked(int x, int y, int z) {
  int tx = x / TILE_XY;
  int ty = y / TILE_XY;
  int tz = z / TILE_Z;
  if ( (tx < 0) || (tx >= map_size_x) ||
       (ty < 0) || (ty >= map_size_y) ||
       (tz < 0) || (tz >= map_size_z) )
    return false;
  return (map[tx][ty][tz].tile > 0);
}


int map_draw(int x1, int y1, int z1,
                 int x2, int y2, int z2,
                 int tile) {
  for (int x=x1;x<=x2;x++)
    for (int y=y1;y<=y2;y++)
      for (int z=z1;z<=z2;z++)
        map[x][y][z].tile = tile;
}

int map_draw_random(int x1, int y1, int z1,
                    int x2, int y2, int z2,
                    int tile1, int span) {
  for (int x=x1;x<=x2;x++)
    for (int y=y1;y<=y2;y++)
      for (int z=z1;z<=z2;z++)
        map[x][y][z].tile = (rand() % 4)==0 ? (rand() % span + tile1) : 0;
}

int map_draw_two(int x1, int y1, int z1,
                 int x2, int y2, int z2,
                 int tile1, int tile2) {
  for (int x=x1;x<=x2;x++)
    for (int y=y1;y<=y2;y++)
      for (int z=z1;z<=z2;z++)
        map[x][y][z].tile = ( ((x+y+z)%2)>0 ? tile1 : tile2 );
}


// this routine generates the map..
int map_generate() {
  map_player_x=25*TILE_XY + TILE_XY/2;
  map_player_y=27*TILE_XY + TILE_XY/2;
  
  map_size_x=MAP_MAX_X;
  map_size_y=MAP_MAX_Y;
  map_size_z=MAP_MAX_Z;
  
  map_draw(0, 0, 0, 49, 49, 4, 0);
  
  map_draw_two(0, 0, 0, 49, 49, 0, 1, 2);
  map_draw_two(0, 0, 0, 9, 9, 1, 1, 3);
  map_draw_two(0, 40, 0, 9, 49, 1, 1, 3);
  map_draw_two(40, 0, 0, 49, 9, 1, 1, 3);
  map_draw_two(40, 40, 0, 49, 49, 1, 1, 3);
  map_draw(10, 0, 1, 39, 0, 1, 4);
  map_draw(0, 10, 1, 0, 39, 1, 4);
  map_draw(10, 49, 1, 39, 49, 1, 4);
  map_draw(49, 10, 1, 49, 39, 1, 4);

  map_draw(5, 5, 0, 44, 44, 4, 0);
  
  map_draw(7, 7, 0, 42, 42, 0, 6);
  map_draw_random(10, 10, 1, 39, 39, 1, 1, 5);

  map_draw(21, 20, 0, 29, 31, 1, 0);
  map_draw(24, 23, 0, 26, 28, 0, 6);
  map[25][27][0].tile = 9;
  map[25][25][1].tile = 7;
  
  map[25][25][2].tile = 8;
  
  map_draw(25, 29, 0, 25, 31, 0, 6);
}

//////////////////////////////////////
//// GAME OBJECT /////////////////////
//////////////////////////////////////
/*
bool operator< (const GameObj &s, const GameObj &o) {
  if (s.gety2t() < o.gety2t())
    return 1;
  if (s.getx2t() < o.getx2t())
    return 1;
  if (tile2screenY(s.getx(), s.gety(), 0) < tile2screenY(o.getx(), o.gety(), 0))
    return 1;
  return 0;
}*/
/*bool GameObj::operator< (const GameObj &s, const GameObj &o) const {
}*/

bool GameObj::on_screen(BITMAP *buf, int offx, int offy) {
  if ((tile2screenX(getx2(), gety1())-offx) < 0)
    return false;
  if ((tile2screenX(getx1(), gety2())-offx) > buf->w)
    return false;
  if ((tile2screenY(getx2(), gety2(), getz2())-offy) < 0)
    return false;
  if ((tile2screenY(getx1(), gety1(), getz2())-offy) > buf->h)
    return false;
  return true;
}

bool GameObj::hit(GameObj *o) {
  if (getx1c() > o->getx2c())
    return false;
  if (o->getx1c() > getx2c())
    return false;
  if (gety1c() > o->gety2c())
    return false;
  if (o->gety1c() > gety2c())
    return false;
  if (getz1() < o->getz2())
    return false;
  if (o->getz1() < getz2())
    return false;
  return true;
}


/*void GameObj::_draw(BITMAP *buf, BITMAP *sprite, int offx, int offy, bool flip=false) {
  if (!flip)
    draw_sprite(buf, sprite, tile2screenX(getx(), gety()) - sprite->w/2 - offx,
                             tile2screenY(getx(), gety(), getz2()) - sprite->h - offy);
  else
    draw_sprite_h_flip(buf, sprite, tile2screenX(getx(), gety()) - sprite->w/2 - offx,
                             tile2screenY(getx(), gety(), getz2()) - sprite->h - offy);
}*/

bool GameObj::_blocked_x(int n) {
  if (map_blocked(n, gety1(), getz1())) return true;
  if (map_blocked(n, gety2(), getz1())) return true;
  if (map_blocked(n, gety2(), getz2())) return true;
  if (map_blocked(n, gety1(), getz2())) return true;
  return false;
}
bool GameObj::_blocked_y(int n) {
  if (map_blocked(getx1(), n, getz1())) return true;
  if (map_blocked(getx1(), n, getz2())) return true;
  if (map_blocked(getx2(), n, getz2())) return true;
  if (map_blocked(getx2(), n, getz1())) return true;
  return false;
}
bool GameObj::_blocked_z(int n) {
  if (map_find_height(getx1t(), gety1t())*TILE_Z > n) return true;
  if (map_find_height(getx1t(), gety2t())*TILE_Z > n) return true;
  if (map_find_height(getx2t(), gety2t())*TILE_Z > n) return true;
  if (map_find_height(getx2t(), gety1t())*TILE_Z > n) return true;
  return false;
}

bool GameObj::_move_x(double xv) {
  bool hitg=false;
  x += xv;
  if (xv<0) {
    while (_blocked_x(getx1())) {
      x = getx()+1;
      hitg=true;
    }
  } else {
    while (_blocked_x(getx2())) {
      x = getx()-1;
      hitg=true;
    }  
  }
  return hitg;
}
bool GameObj::_move_y(double yv) {
  bool hitg=false;
  y += yv;
  if (yv<0) {
    while (_blocked_y(gety1())) {
      y = gety()+1;
      hitg=true;
    }
  } else {
    while (_blocked_y(gety2())) {
      y = gety()-1;
      hitg=true;
    }  
  }
  return hitg;
}
bool GameObj::_move_z(double zv) {
  bool hitg=false;
  z += zv;
  while (_blocked_z(getz2())) {
    z = getz2()+1;
    hitg=true;
  }
  return hitg;
}

void GameObj::_check_speed(double m) {
  if (hypot(x_vel, y_vel)>m) {
    double a = getangle(x_vel, y_vel);
    x_vel = mkX(a, m);
    y_vel = mkY(a, m);
  }
}

void GameObj::_slow_down(double f) {
  double a = getangle(x_vel, y_vel);
  double new_x;
  double new_y;
  if (hypot(x_vel, y_vel)<f) {
    x_vel=0;
    y_vel=0;
    return;
  }
  
  // strange bug fix---
  if ((a==0) && (x_vel<0)) {
    a=180;
  }
  // end strange bug fix--
  
  a += 180;
  if (a > 360)
    a-=360;
//  if ((x_vel >= f) || (x_vel <= -f))
    new_x = x_vel + mkX(a, f);
//  else
//    new_x = 0;
//  if ((y_vel >= f) || (y_vel <= -f))
    new_y = y_vel + mkY(a, f);
//  else
//    new_y = 0;
  if (((new_x < 0) && (x_vel > 0)) ||
      ((new_x > 0) && (x_vel < 0)) )
    new_x = 0;
  if (((new_y < 0) && (y_vel > 0)) ||
      ((new_y > 0) && (y_vel < 0)) )
    new_y = 0;
  x_vel = new_x;
  y_vel = new_y;
}

//////////////////////////////////////
//// PLAYER OBJECT ///////////////////
//////////////////////////////////////

void PlayerObj::draw_shadow(BITMAP *buf, int offx, int offy, int shadow) {
  if (shadow<0)
    return;
  int s = MAX_SHADOW_GFX - (getz2t()-shadow)-1;
  if (s<0)
    s = 0;
  if (s>=MAX_SHADOW_GFX)
    s=MAX_SHADOW_GFX-1;
  fblend_trans(gfx_shadow[s], buf, tile2screenX(getx(), gety()) - gfx_shadow[s]->w/2 - offx,
                           tile2screenY(getx(), gety(), shadow*TILE_Z) - gfx_shadow[s]->h/2 - offy, 96);
}

void PlayerObj::draw(BITMAP *buf, int offx, int offy) {
  // DON'T LOOK AT THIS CODE:.... IT'S UGLY.... I DIDN'T BOTHER TO CODE NICE HERE..
  // I JUST DIDN'T BOTHER TO DO THE MATH...
  BITMAP *sprite;
  bool flip=false;
  if (angle<23)
    sprite = gfx_player[3];
  else if (angle<67)
    sprite = gfx_player[4];
  else if (angle<113)
    { sprite = gfx_player[3]; flip=true; }
  else if (angle<158)
    { sprite = gfx_player[2]; flip=true; }
  else if (angle<203)
    { sprite = gfx_player[1]; flip=true; }
  else if (angle<248)
    sprite = gfx_player[0];
  else if (angle<293)
    sprite = gfx_player[1];
  else if (angle<337)
    sprite = gfx_player[2];
  else
    sprite = gfx_player[3];
    
  if (!flip)
    draw_sprite(buf, sprite, tile2screenX(getx(), gety()) - sprite->w/2 - offx,
                             tile2screenY(getx(), gety(), getz2()) - sprite->h + 4 - offy);
  else
    draw_sprite_h_flip(buf, sprite, tile2screenX(getx(), gety()) - sprite->w/2 - offx,
                             tile2screenY(getx(), gety(), getz2()) - sprite->h + 4 - offy);
}

bool PlayerObj::animate() {
  if (anim_cycl>0) {
    anim_cycl--;
    return true;
  }

  if (cleft) {
    angle -= 2;
    while(angle<0)
      angle+=360;
  }
  if (cright) {
    angle += 2;
    while(angle>359)
      angle-=360;
  }
  
  // thrusters on?
  if (cup) {
    if (_blocked_z(getz2()-1)) {
      x_vel += mkX(angle, acc_force);
      y_vel += mkY(angle, acc_force);
    } else {
    }
  } else {
    if (_blocked_z(getz2()-1)) {
      _slow_down(frict_force);
    }
  }

  // ensure that we don't cross the speed limit...
  // that could be dangerous..
  _check_speed(max_speed);    
    
  
  if (!cjump)
    can_jump=true;
  
  if (_blocked_z(getz2()-1)) {
    if (cjump && can_jump) {
      z_vel += jump_force;
      can_jump = false;
    }
  } else {
    z_vel += grav_force;
  }
  
  // animate x direction
  if (_move_x(x_vel)) {
    int f=(int)hypot(x_vel, y_vel);
      x_vel *= -bounce_lossXY;
  }
  // animate y direction
  if (_move_y(y_vel)) {
    int f=(int)hypot(x_vel, y_vel);
      y_vel *= -bounce_lossXY;
  }
  // animate z direction
  if (_move_z(z_vel)) {
    if (z_vel < bounce_minZ) {
      z_vel *= -bounce_lossZ;
    } else {
      z_vel = 0;
    }
  }
  anim_cycl=anim_time;
}
  
void PlayerObj::set_control(bool up, bool left, bool right, bool jump) {
  cup = up;
  cleft = left;
  cright = right;
  cjump = jump;
}

void PowerupObj::draw_shadow(BITMAP *buf, int offx, int offy, int shadow) {
  if (shadow<0)
    return;
  int s = MAX_SHADOW_GFX - (getz2t()-shadow)-1;
  if (s<0)
    s = 0;
  if (s>=MAX_SHADOW_GFX)
    s=MAX_SHADOW_GFX-1;
  fblend_trans(gfx_shadow[s], buf, tile2screenX(getx(), gety()) - gfx_shadow[s]->w/2 - offx,
                           tile2screenY(getx(), gety(), shadow*TILE_Z) - gfx_shadow[s]->h/2 - offy, 96);  
}

int PowerupObj::_anim() {
  if (!_blocked_z(getz2()-1)) {
    z_vel += grav_force;
  }
  // animate z direction
  if (_move_z(z_vel)) {
    if (z_vel < bounce_minZ) {
      z_vel *= -bounce_lossZ;
    } else {
      z_vel = 0;
    }
  }
}

//////////////////////////////////////
//// BALL OBJECT /////////////////////
//////////////////////////////////////


void BallObj::draw(BITMAP *buf, int offx, int offy) {
  int t=bn;
  int _x = tile2screenX(getx(), gety()) - offx;
  int _y = tile2screenY(getx(), gety(), getz2()) - 5 - offy;
  BITMAP *sprite;
  if (t > 4)
    t = 4;
  sprite=gfx_ball[t];
  draw_sprite(buf, gfx_star, _x - gfx_star->w/2, _y - gfx_star->h/2);
  fblend_add(sprite, buf, _x - sprite->w/2,
                         _y - sprite->h/2, 255);
}

bool BallObj::animate() {
  if (anim_cycl>0) {
    anim_cycl--;
    return true;
  }
  _anim();
  bn = (bn+1) % 6;
  anim_cycl=anim_time;
}

//////////////////////////////////////
//// PARTICLE OBJECT STUFF ///////////
//////////////////////////////////////

ParticleObj::ParticleObj(int nx, int ny, int nz, int a1, int a2, double f, double g, double b, int bit, long lifetime) : GameObj() {
  setx(nx);
  sety(ny);
  setz(nz);
  setxd(2);
  setyd(2);
  setzd(4);
  spr = bit;
  lifet=lifetime;
  lifecounter=0;
  bounce=b;
  grav=g;
    
  z_vel = mkZ(a2, f);
  double gf = mkX(a2, f);
  x_vel = mkX(a1, gf);
  y_vel = mkY(a1, gf);
  anim_time=3;
  anim_cycl=0;
}

void ParticleObj::draw_shadow(BITMAP *buf, int offx, int offy, int shadow) {
  if (lifecounter>=lifet)
    return;
  if (shadow<0)
    return;
  int s = MAX_SHADOW_GFX - (getz2t()-shadow)-4;
  if (s<0)
    return;
  if (s>=MAX_SHADOW_GFX)
    s=MAX_SHADOW_GFX-1;
  int _x = tile2screenX(getx(), gety()) - offx;
  int _y = tile2screenY(getx(), gety(), shadow*TILE_Z) -2 - offy;
  int tr= 96 - (int)((double)lifecounter / (double)lifet * 96);
  fblend_trans(gfx_shadow[s], buf, _x - gfx_shadow[s]->w/2,
                           _y - gfx_shadow[s]->h/2, tr);  
}

void ParticleObj::draw(BITMAP *buf, int offx, int offy) {
  if (lifecounter>=lifet)
    return;
  int _x = tile2screenX(getx(), gety()) - offx;
  int _y = tile2screenY(getx(), gety(), getz2()) - offy;
  BITMAP *sprite;
  if (spr > MAX_PART_GFX)
    spr = MAX_PART_GFX;
  sprite=gfx_part[spr];
  int tr= 255 - (int)((double)lifecounter / (double)lifet * 255);
  fblend_trans(sprite, buf, _x - sprite->w/2, _y - sprite->h/2, tr);
}

bool ParticleObj::animate() {
  if (lifecounter>=lifet)
    return false;
  if (anim_cycl>0) {
    anim_cycl--;
    return true;
  }

  z_vel -= grav;

  // animate x direction
  if (_move_x(x_vel)) {
    x_vel *= -bounce;
  }
  // animate y direction
  if (_move_y(y_vel)) {
    y_vel *= -bounce;
  }
  // animate z direction
  if (_move_z(z_vel)) {
    z_vel *= -bounce;
  }
  
  
  lifecounter++;
  anim_cycl=anim_time;
  return true;
}

