#include "mandelbrot.h"

/*
  To everyone.. The fractal code is the only code that I have ripped
  off the internet. Everything else in this game is written by me :-)
 */

#define FIXSIZE 25
#define mul(a,b) ((((long long)a)*(b))>>FIXSIZE)
#define fixpt(a) ((long)(((a)*(1<<FIXSIZE))))
#define integer(a) (((a)+(1<<(FIXSIZE-1)))>>FIXSIZE)

void mandelbrot(BITMAP *buf)
{
register long x0,y0,p,q,xn,tot;
double xmin=-2.5,ymin=-1.5,xmax=1.5,ymax=1.5,xs,ys;
register int i,x,y;

xs=(xmax-xmin)/640.0;
ys=(ymax-ymin)/480.0;
for (y=0;y<240;y++) {
   for (x=0;x<640;x++) {                        
      p=fixpt(xmin+x*xs);
      q=fixpt(ymin+y*ys);
         xn=0;
         x0=0;
         y0=0;
         i=0;
         while ((mul(xn,xn)+mul(y0,y0))<fixpt(4) && ++i<150)  {
            xn=mul((x0+y0),(x0-y0)) +p;           
            y0=mul(fixpt(2),mul(x0,y0)) +q;
            x0=xn;
            }
         tot+=i;
         if (i==150) i=1;
         putpixel(buf, x,y,makecol(getr16(i), getg16(i), getb16(i)));
         putpixel(buf, x,479-y,makecol(getr16(i), getg16(i), getb16(i)));  
      }
   }
}
/*
void mandelbrot(BITMAP *buf)
{
register long x0,y0,p,q,xn,tot;
double xmin=-2.5,ymin=-1.5,xmax=1.5,ymax=1.5,xs,ys;
register int i,x,y;

xs=(xmax-xmin)/320.0;
ys=(ymax-ymin)/200.0;
for (y=0;y<100;y++) {
   for (x=0;x<320;x++) {                        
      p=fixpt(xmin+x*xs);
      q=fixpt(ymin+y*ys);
         xn=0;
         x0=0;
         y0=0;
         i=0;
         while ((mul(xn,xn)+mul(y0,y0))<fixpt(4) && ++i<150)  {
            xn=mul((x0+y0),(x0-y0)) +p;           
            y0=mul(fixpt(2),mul(x0,y0)) +q;
            x0=xn;
            }
         tot+=i;
         if (i==150) i=1;
         putpixel(buf, x,y,i);
         putpixel(buf, x,199-y,i);  
      }
   }
}
*/
