#include "iso.h"


int tile2screenX(int tx, int ty) {
  return (tx - ty)-1;
}

int tile2screenY(int tx, int ty, int tz) {
  return ((ty/2) + (tx/2) - tz);
}

int screen2tileX(int x, int y) {
  return (x + y*2)/2+1;
}

int screen2tileY(int x, int y) {
  return (y*2 - x)/2;
}


int tile_atX(int x, int y) {
  return screen2tileX(x, y) / TILE_XY;
}

int tile_atY(int x, int y) {
  return screen2tileY(x, y) / TILE_XY;
}

void _draw_tile(BITMAP *buf, BITMAP *tile, int x, int y) {
  draw_sprite(buf, tile, x - TILE_IMG_WIDTH_HALF, y - (tile->h - TILE_IMG_HEIGHT));
}

void draw_tile(BITMAP *buf, BITMAP *tile, int x, int y, int z, int offx, int offy) {
  _draw_tile(buf, tile, (x * TILE_IMG_WIDTH_HALF) - (y * TILE_IMG_WIDTH_HALF) - offx, (y * TILE_IMG_HEIGHT_HALF) + (x * TILE_IMG_HEIGHT_HALF) - (z * TILE_Z) - offy );
}

