#include "game.h"
#include "iso.h"
#include "graphic.h"
#include "obj.h"
#include "timer.h"
#include "vect.h"
#include "player.h"

#include <vector>

using namespace std;

vector<GameObj*> onscreen_objects;
vector<GameObj*> onscreen_sorted;

void sort_onscreen() {
  vector<GameObj*>::iterator o;
  vector<GameObj*>::iterator n;
  onscreen_sorted.clear();
  while (!onscreen_objects.empty()) {
    o = onscreen_objects.begin();
    n = onscreen_sorted.begin();
    if (!onscreen_sorted.empty())
      while ( n!=onscreen_sorted.end()) {
        if (*(*o) < *(*n))
          break;
        n++;
      }
    onscreen_sorted.insert(n, (*o));
    onscreen_objects.erase(o);
  }
}

// this function draws the map and the objects in onscreen_objects
void draw_map(BITMAP *buf, int offx, int offy) {
  int start_x;
  int start_y;
  int stop_x;
  int stop_y;
  
  start_x = tile_atX(offx, offy);
  stop_x = tile_atX(buf->w+offx, buf->h+offy)+1;
  start_y = tile_atY(buf->w+offx, offy);
  stop_y = tile_atY(offx, buf->h+offy)+1;
  if (start_y < 0)
    start_y = 0;
  if (stop_y >= map_size_y)
    stop_y = map_size_y-1;
  if (start_x < 0)
    start_x = 0;
  if (stop_x >= map_size_x)
    stop_x = map_size_x-1;
    
  sort_onscreen();
  vector<GameObj*>::iterator it = onscreen_sorted.begin();
  vector<GameObj*>::iterator shadit = onscreen_sorted.begin();

  for (int y=start_y; y<=stop_y; y++)
    for (int x=start_x; x<=stop_x; x++) {
      for (int z=0; z<MAP_MAX_Z; z++) {
        if (map[x][y][z].tile>0)
        draw_tile(buf, gfx_tile[map[x][y][z].tile-1], x, y, z, offx, offy);
      }
      while ((shadit < onscreen_sorted.end())) {
        if ((*shadit)->getx2t() > x)
          break;
        if ((*shadit)->gety2t() > y)
          break;
        (*shadit)->draw_shadow(buf, offx, offy, map_find_height(x, y));
        shadit++;
      }
      while ((it < onscreen_sorted.end())) {
        if ((*it)->getx2t() > x)
          break;
        if ((*it)->gety2t() > y)
          break;
        (*it)->draw(buf, offx, offy);
        it++;
      }
    }
    
  while ((it < onscreen_sorted.end())) {
    (*it)->draw(buf, offx, offy);
    it++;
  }
}

vector<ParticleObj*> particles;
vector<PowerupObj*> balls;

int powerup_spawn() {
  int type=rand()%1+1;
  int x;
  int y;
  
  do {
    x = rand()%((map_size_x-3) * TILE_XY)+TILE_XY;
    y = rand()%((map_size_y-3) * TILE_XY)+TILE_XY;
  } while (map_find_height(x/TILE_XY, y/TILE_XY)<1);
  
  switch (type) {
    case ID_STARBALL:
      balls.push_back(new BallObj(x, y, TILE_Z*8));
    break;
  }

}

void part_spawn_grab(int nx, int ny, int nz, int n) {
  for (int t=0; t<n; t++) {
    particles.push_back(new GrabParticleObj(nx, ny, nz, rand()%360, rand()%45+45, rand()%4+2));
  }
}

void part_spawn_expl(int nx, int ny, int nz) {
  int n = 10;
  for (int t=0; t<n; t++) {
    particles.push_back(new GrabParticleObj(nx, ny, nz, rand()%360, rand()%45+45, rand()%4+2, 0));
  }
}

void part_spawn_winner(int nx, int ny, int nz) {
  int n = 10;
  for (int t=0; t<n; t++) {
    particles.push_back(new GrabParticleObj(nx, ny, nz, rand()%360, rand()%75+15, rand()%4+3, rand()%MAX_PART_GFX));
  }
}

void part_spawn_easter() {
  for (int t=0; t<40; t++) {
    int nx=25*TILE_XY + rand()%TILE_XY;
    int ny=25*TILE_XY + rand()%TILE_XY;
    int nz=TILE_Z*4;
    particles.push_back(new GrabParticleObj(nx, ny, nz, rand()%360, rand()%45+45, rand()%4+2, rand() % MAX_PART_GFX));    
  }
}

int play_map() {
  bool EASTER_EGG_POSSIBLE=false;
  bool EASTER_EGG_ACTIVE=false;
  int EASTER_COUNTER=0;
  
  bool has_=false; // screenshot variable
  const int DONE_ESC=1;
  const int DONE_FINISHED=2;
  vector<PowerupObj*>::iterator ballit;
  vector<ParticleObj*>::iterator partit;
  
  BITMAP *buffer=create_bitmap(640, 480);
  BITMAP *background = create_bitmap(640, 480);
  clear(background);
  for (int a=0; a<400; a++) {
    int b=rand()%128+127;
    putpixel(background, rand()%640, rand()%480, makecol(b, b, b));
  }
  
  
  particles.clear();
  balls.clear();
  
  int offset_x, offset_y;
  
  // the player object
  PlayerObj *player = new PlayerObj;
  player->setx(map_player_x);
  player->sety(map_player_y);
  player->setz(map_find_height(player->getxt(), player->getyt())*TILE_Z);
  const int PLAYER_ACTIVE=0;
  const int PLAYER_DEAD=1;
  const int PLAYER_DONE=2;
  
  int done=0;
  int player_status=0;
  int p_counter;
  int p_counter2;
  
  onscreen_objects.clear();
  text_mode(-1);
  
  counter=0;
  counter_limit=180;
  player_score=0;
  start_timer();
  // BEHOLD-- THE MIGHTY GAME LOOP...
  while (!done) {
    // Logic loop
    while (counter>0) {
      if (player_status==PLAYER_ACTIVE) {
        player->set_control(key[KEY_UP], key[KEY_LEFT], key[KEY_RIGHT], key[KEY_SPACE]);
        player->animate();
        if ((player->getx2t() < 0) ||
            (player->gety2t() < 0) ||
            (player->getx1t() >= map_size_x) ||
            (player->gety1t() >= map_size_y) || 
            (player->getz()==0) ) {
          play_s(2);
          player_status=PLAYER_DEAD;
          p_counter=500;
          part_spawn_expl(player->getx(), player->gety(), player->getz());
        } 
      } else if (player_status==PLAYER_DEAD) {
        p_counter--;
        if (p_counter<1) {
          player->setx(map_player_x);
          player->sety(map_player_y);
          player->setz((map_find_height(player->getxt(), player->getyt())+1)*TILE_Z);
          player->reset();
          player_status=PLAYER_ACTIVE;
        }
      } else if (player_status==PLAYER_DONE) {
        player->setxv(0);
        player->setyv(0);
        p_counter++;
        if (p_counter<10)
          player->set_control(false, true, false, true);
        else
          player->set_control(false, true, false, false);
        player->animate();
        if (p_counter>100) {
          p_counter=0;
          if (player_score>high_score) {
            part_spawn_winner(player->getx(), player->gety(), player->getz());
          }
        }
      }
      
      // animate powerups
      ballit = balls.begin();
      while(ballit<balls.end()) {
        (*ballit)->animate();
        if (player_status==PLAYER_ACTIVE) {
          if (player->hit((*ballit))) {
            // Player hits something...
            int id = (*ballit)->id();
            play_s(0);
            switch (id) {
              case ID_STARBALL:
                player_score+=10;
                part_spawn_grab((*ballit)->getx(), (*ballit)->gety(), (*ballit)->getz(), 5);
              break;
            }
            delete (*ballit);
            balls.erase(ballit);
          } else
            ballit++;
        } else
          ballit++;
      }
      
      // animate particles
      partit = particles.begin();
      while(partit<particles.end()) {
        if ((*partit)->animate())
          partit++;
        else {
          delete (*partit);
          particles.erase(partit);
        } 
      }
      
      // spawn powerups
      while (balls.size()<50)
        powerup_spawn();
      counter--;
      
      // check if time is up
      if ((counter_limit==0) && (player_status==PLAYER_ACTIVE)) {
        player_status=PLAYER_DONE;
        p_counter=0;
      }
      
      // Easter egg code...
      if (!EASTER_EGG_POSSIBLE) {
        // check if the player dies when score is [150-200]
        if ((player_score>=150) && (player_score <= 200) && (player_status==PLAYER_DEAD)) {
          EASTER_EGG_POSSIBLE=true;
        }
      } else if (!EASTER_EGG_ACTIVE) {
        // check if player jumps into the K
        if (player_score>200) {
          if ((player->getxt()==25) &&
              (player->getyt()==25) ) {
            EASTER_EGG_ACTIVE=true;
            play_s(1);
            player_status=PLAYER_DEAD;
            p_counter=1000;
            part_spawn_expl(player->getx(), player->gety(), player->getz());
              
          }
        }
      } else if (EASTER_EGG_ACTIVE) {
        if (EASTER_COUNTER==0) {
          EASTER_COUNTER=250;
          // make fireworks
          part_spawn_easter();
          if (player_status!=PLAYER_DONE)
            player_score+=1;
        } else {
          EASTER_COUNTER--;
        }
      }
      // End easter egg code
      
    }
    // End logic loop
    
    
    if (player_status!=PLAYER_DONE) {
      offset_x = tile2screenX(player->getx(), player->gety())- buffer->w / 2;
      offset_y = tile2screenY(player->getx(), player->gety(), player->getz()) - buffer->h / 2;
    }
    
    // draw map & stuff.. :-)
    onscreen_objects.clear();
    if ((player_status==PLAYER_ACTIVE) || (player_status==PLAYER_DONE)) {
      onscreen_objects.push_back(player);
    }
    
    for(vector<PowerupObj*>::iterator it=balls.begin(); it<balls.end(); it++) {
      if ( (*it)->on_screen(buffer, offset_x, offset_y) ) {
        onscreen_objects.push_back((*it));
      }      
    }

    for(vector<ParticleObj*>::iterator it=particles.begin(); it<particles.end(); it++) {
      if ( (*it)->on_screen(buffer, offset_x, offset_y) ) {
        onscreen_objects.push_back((*it));
      }      
    }

    blit(background, buffer, 0, 0, 0, 0, 640, 480);
    draw_map(buffer, offset_x, offset_y);
        
    
    
    if (player_status==PLAYER_DONE) {
      if (player_score>high_score) {
        textprintf(buffer, gfont, 100, 20, -1, "Gongratulations!");
        textprintf(buffer, gfont, 100, 60, -1, "You've beaten the old highscore!");      
        textprintf(buffer, gfont, 100, 100, -1, "Score: %d !", player_score);
      } else {
        textprintf(buffer, gfont, 100, 20, -1, "Time's up!");
        textprintf(buffer, gfont, 100, 60, -1, "You got %d score", player_score);
        textprintf(buffer, gfont, 100, 100, -1, "The highscore is %d", high_score);
      }
    } else {
      // print score and time left
      textprintf(buffer, gfont, 5, 5, -1, "Score: %03d", player_score);
      textprintf_right(buffer, gfont, 634, 5, -1, "%02d:%02d", counter_limit/60, counter_limit%60);
    }
    
    acquire_screen();
    vsync();
    blit(buffer, screen, 0, 0, 0, 0, 640, 480);
    release_screen();

    if (key[KEY_S] && !has_) {
      save_bitmap("screenshot.bmp", buffer, NULL);
    }
  
    if (key[KEY_ESC])
      done = DONE_ESC;
  }
  stop_timer();
  if (player_status==PLAYER_DONE) {
    if (player_score>high_score)
      high_score=player_score;
  }
  // cleanup  
  delete player;
  vector<PowerupObj*>::iterator tmp = balls.begin();
  while (tmp!=balls.end()) {
     delete (*tmp);
     balls.erase(tmp);
  }
  vector<ParticleObj*>::iterator tmp2 = particles.begin();
  while (tmp2!=particles.end()) {
     delete (*tmp2);
     particles.erase(tmp2);
  }
  
  destroy_bitmap(buffer);
  destroy_bitmap(background);
  return done;
}

