#include <allegro.h>
#include <stdlib.h>

BITMAP *chr, *buffer, *ene, *gem;
PALETTE palette;
SAMPLE *hitwall, *hitene, *hitgem;
MIDI *bgmusic;

volatile int go_flg;
void time_it(){go_flg++;}
END_OF_FUNCTION (time_it);

int main(void){
 LOCK_VARIABLE (go_flg);
 LOCK_FUNCTION(time_it);
 allegro_init();
 install_keyboard();
 install_timer();
 install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,"");
 set_color_depth(16);
 set_gfx_mode(GFX_AUTODETECT,320,200, 0, 0);
 install_int_ex(time_it,1000);
 install_mouse();
 set_volume(255,200);

//-----------Load Images and Sounds
 chr=load_bitmap("chr.bmp", palette);
 ene=load_bitmap("ene.bmp", palette);
 gem=load_bitmap("gem.bmp", palette);
 buffer=create_bitmap(320,200);
 hitwall=load_sample("hitw.wav");
 hitene=load_sample("hite.wav");
 hitgem=load_sample("hitg.wav");
 bgmusic=load_midi("bgm.mid");
//-----------------Initialize Intergers
 int cx,cy,cxa,cya;
 int ec,ex[10],ey[10],exa[10],eya[10];
 int gx[4],gy[4],gv[4];
 int i,won,score,round,dlay,lives,dlay2,dlay3,timecnt;
 cx=160;
 cy=100;
 cxa=0;
 cya=0;
 ec=1;
 won=0;
 score=0;
 round=0;
 dlay=0;
 dlay2=0;
 dlay3=0;
 lives=9;
 timecnt=0;
 for (i=0;i<=9;i++){
  ex[i-1]=rand()%300;
  ey[i-1]=0;
  exa[i-1]=1;
  eya[i-1]=1;
 }
 for (i=0;i<=3;i++){
  gx[i-1]=rand()%300;
  gy[i-1]=rand()%180;
  gv[i-1]=0;
 }
//----------------Uhh...
 play_midi(bgmusic, TRUE);
 textout(screen, font, "GUM!", 148, 0, makecol(255,0,0));
 textout(screen, font, "Arrow Keys to move", 0, 50, makecol(95,128,150));
 textout(screen, font, "Escape (ESC) to end abruptly.", 0, 75, makecol(95,128,150));
 textout(screen, font, "Lose all lives to end later.", 0, 100, makecol(95,128,150));
 textout(screen, font, "Survive to level 10 for a bonus!", 0, 125, makecol(95,128,150));
 textout(screen, font, "Press Space to begin!", 55, 180, makecol(128,0,255));
 while (!key[KEY_SPACE]){
  for (i=0;i<=9;i++){
   ex[i-1]=rand()%300;
   ey[i-1]=0;
   exa[i-1]=1;
   eya[i-1]=1;
  }
  for (i=0;i<=3;i++){
   gx[i-1]=rand()%300;
   gy[i-1]=rand()%180;
   gv[i-1]=0;
  }
  if (key[KEY_ESC]){return 0;}
 }
//----------------------------------------------------------*
//              Here we Have the Game (So it Begins!)       |
//----------------------------------------------------------*
 while (won==0){
  if(go_flg>=1){
   if (key[KEY_ESC]){won=3;}
//---------------------Moving
   if (key[KEY_LEFT]&&cx>0){cxa=cxa-1;}
   if (key[KEY_RIGHT]&&cx<299){cxa=cxa+1;}
   if (key[KEY_UP]&&cy>0){cya=cya-1;}
   if (key[KEY_DOWN]&&cy<169){cya=cya+1;}
   if (!key[KEY_LEFT]&&cxa<0){cxa=cxa+1;}
   if (!key[KEY_RIGHT]&&cxa>0){cxa=cxa-1;}
   if (!key[KEY_UP]&&cya<0){cya=cya+1;}
   if (!key[KEY_DOWN]&&cya>0){cya=cya-1;}
   if (cx+cxa/4<0){cx=0;cxa=0;play_sample(hitwall,255,100,1000,0);}
   if (cx+cxa/4>299){cx=299;cxa=0;play_sample(hitwall,255,100,1000,0);}
   if (cy+cya/4<0){cy=0;cya=0;play_sample(hitwall,255,100,1000,0);}
   if (cy+cya/4>169){cy=169;cya=0;play_sample(hitwall,255,100,1000,0);}
   if (cxa>20){cxa=20;}
   if (cxa<-20){cxa=-20;}
   if (cya>20){cya=20;}
   if (cya<-20){cya=-20;}
   dlay++;
   if (dlay>=10){
    for(i=0;i<ec;i++){
     ex[i-1]=ex[i-1]+exa[i-1];
     ey[i-1]=ey[i-1]+eya[i-1];
     if (ex[i-1]<0){ex[i-1]=0;exa[i-1]=2;}
     if (ex[i-1]>299){ex[i-1]=299;exa[i-1]=-2;}
     if (ey[i-1]<0){ey[i-1]=0;eya[i-1]=2;}
     if (ey[i-1]>179){ey[i-1]=179;eya[i-1]=-2;}
    }
    cx=cx+cxa/4;
    cy=cy+cya/4;
    dlay=0;
   }
//-------------------Collision Detection
   for(i=0;i<ec;i++){
    if (ey[i-1]+20>cy&&ey[i-1]<cy+30&&ex[i-1]+20>cx&&ex[i-1]<cx+20){
     lives=lives-1;
     ex[i-1]=rand()%300;
     ey[i-1]=rand()%180;
     play_sample(hitene,255,100,1000,0);
    }
   }
   for(i=0;i<4;i++){
    if (gv[i-1]==1&&gy[i-1]+20>cy&&gy[i-1]<cy+30&&gx[i-1]+20>cx&&gx[i-1]<cx+20){
     gv[i-1]=0;
     score=score+10;
     gx[i-1]=rand()%300;
     gy[i-1]=rand()%180;
     play_sample(hitgem,255,100,1000,0);
    }
   }
//-----------------Time, Score, Round, and Life Handling
   dlay2++;
   dlay3++;
   if (dlay2>=500){timecnt++;score++;dlay2=0;}
   if (dlay3>=4000){
    round++;
    ec=round;
    i=0;
    while(i<4){
     if (gv[i]==0){gv[i]=1;i=4;}
     i++;
    }
    dlay3=0;
    timecnt=0;
   }
   if (round>9){round=9;ec=9;won=2;}
   if (lives<=0){lives=0;won=1;}
   //----------------Draw Stuff
   if (won==0){
    blit(chr,buffer,0,0,cx,cy,20,30);
    for(i=0;i<ec;i++){
     masked_blit(ene,buffer,0,0,ex[i-1],ey[i-1],20,20);
    }
    for(i=0;i<4;i++){
     if(gv[i-1]==1){
      masked_blit(gem,buffer,0,0,gx[i-1],gy[i-1],20,20);
     }
    }
    textprintf(buffer,font,0,0,makecol(200,0,0),"score:%d level:%d lives:%d", score, round, lives);
    if(key[KEY_F12]){save_bitmap("ss.bmp",buffer,palette);}
    blit(buffer,screen,0,0,0,0,320,200);
    clear(buffer);
   }
   if (won==1){
    while(!key[KEY_Q]&&!key[KEY_SPACE]){
     textprintf(buffer,font,148,0,makecol(255,0,0),"GUM!");
     textprintf(buffer,font,0,50,makecol(255,255,0),"You scored:");
     textprintf(buffer,font,120,50,makecol(0,255,0),"%d",score);
     textprintf(buffer,font,0,75,makecol(255,255,0),"With lives:");
     textprintf(buffer,font,120,75,makecol(255,0,0),"%d",lives);
     textprintf(buffer,font,0,100,makecol(255,255,0),"On Level:");
     textprintf(buffer,font,100,100,makecol(0,0,255),"%d",round);
     textprintf(buffer,font,125,150,makecol(97,158,255),"THE END");
     textprintf(buffer,font,70,170,makecol(97,158,255),"(Press Q or Space)");
     if (key[KEY_F12]){save_bitmap("ss.bmp",buffer,palette);}
     blit(buffer,screen,0,0,0,0,320,200);
     clear(buffer);
     if (key[KEY_SPACE]){
      cx=160;
      cy=100;
      cxa=0;
      cya=0;
      ec=1;
      won=0;
      score=0;
      round=0;
      dlay=0;
      dlay2=0;
      dlay3=0;
      lives=9;
      timecnt=0;
      for (i=0; i<=9; i++){
       ex[i-1]=rand()%300;
       ey[i-1]=0;
       exa[i-1]=1;
       eya[i-1]=1;
      }
      for (i=0; i<=3; i++){
       gx[i-1]=rand()%300;
       gy[i-1]=rand()%180;
       gv[i-1]=0;
      }
     }
    }
   }
   if (won==2){
    while(!key[KEY_Q]&&!key[KEY_SPACE]){
     textprintf(buffer,font,148,0,makecol(255,0,0),"GUM!");
     textprintf(buffer,font,105,0,makecol(128,0,255),"ACE WINNER!");
     textprintf(buffer,font,0,50,makecol(255,255,0),"You scored:");
     textprintf(buffer,font,120,50,makecol(0,255,0),"%d",score+(lives*100));
     textprintf(buffer,font,0,75,makecol(255,255,0),"With lives:");
     textprintf(buffer,font,120,75,makecol(255,0,0),"%d",lives);
     textprintf(buffer,font,0,100,makecol(255,255,0),"On Level:");
     textprintf(buffer,font,100,100,makecol(0,0,255),"%d",round);
     textprintf(buffer,font,125,150,makecol(97,158,255),"THE END");
     textprintf(buffer,font,70,170,makecol(97,158,255),"(Press Q or Space)");
     if (key[KEY_F12]){save_bitmap("ss.bmp",buffer,palette);}
     blit(buffer,screen,0,0,0,0,320,200);
     clear(buffer);
     if (key[KEY_SPACE]){
      cx=160;
      cy=100;
      cxa=0;
      cya=0;
      ec=1;
      won=0;
      score=0;
      round=0;
      dlay=0;
      dlay2=0;
      dlay3=0;
      lives=9;
      timecnt=0;
      for (i=0; i<=9; i++){
       ex[i-1]=rand()%300;
       ey[i-1]=0;
       exa[i-1]=1;
       eya[i-1]=1;
      }
      for (i=0; i<=3; i++){
       gx[i-1]=rand()%300;
       gy[i-1]=rand()%180;
       gv[i-1]=0;
      }
     }
    }
   }
   if (won==3){
    while(!key[KEY_Q]&&!key[KEY_SPACE]){
     textprintf(buffer,font,148,0,makecol(255,0,0),"GUM!");
     textprintf(buffer,font,95,0,makecol(128,100,84),"Done Already?");
     textprintf(buffer,font,0,50,makecol(255,255,0),"You scored:");
     textprintf(buffer,font,120,50,makecol(0,255,0),"%d",score);
     textprintf(buffer,font,0,75,makecol(255,255,0),"With lives:");
     textprintf(buffer,font,120,75,makecol(255,0,0),"%d",lives);
     textprintf(buffer,font,0,100,makecol(255,255,0),"On Level:");
     textprintf(buffer,font,100,100,makecol(0,0,255),"%d",round);
     textprintf(buffer,font,125,150,makecol(97,158,255),"THE END");
     textprintf(buffer,font,70,170,makecol(97,158,255),"(Press Q or Space)");
     if (key[KEY_F12]){save_bitmap("ss.bmp",buffer,palette);}
     blit(buffer,screen,0,0,0,0,320,200);
     clear(buffer);
     if (key[KEY_SPACE]){
      cx=160;
      cy=100;
      cxa=0;
      cya=0;
      ec=1;
      won=0;
      score=0;
      round=0;
      dlay=0;
      dlay2=0;
      dlay3=0;
      lives=9;
      timecnt=0;
      for (i=0; i<=9; i++){
       ex[i-1]=rand()%300;
       ey[i-1]=0;
       exa[i-1]=1;
       eya[i-1]=1;
      }
      for (i=0; i<=3; i++){
       gx[i-1]=rand()%300;
       gy[i-1]=rand()%180;
       gv[i-1]=0;
      }
     }
    }
   }
   go_flg=0;
  }
 }
 return 0;
}

END_OF_MAIN();
