/*

  Dah Ants level editor.

  Released for linux compilation, and your own tweaking.

  Please send me any tweaks you make, and inform me what you did. If its cool, I would like to incorporate
  it into my main release.


http://phr00t.two.am/
jvight@student.umass.edu

  
*/

#include "allegro.h"
//#include "winalleg.h"
//#include <math.h>
//#include <stdlib.h>
//#include <stdio.h>
#include <fstream>
//#include <iostream>
//#include <time.h>
#include <ants.h>
#include <string>
using namespace std; // So we can use strings correctly.

BITMAP *level, *pretty_level, *buffer;

PALETTE pal;

DATAFILE *data;

BITMAP *block[20];
int Amt[20], old_mw=0, GB=-1, RB=-1, BB=-1, level_selected=1, dir_selected=1;

int Drop_Rate = 70, Max_Ants = 40, Save_Ants = 20, Color = 0;

string level_name = "Level", check = "";

bool Saving = false, Started = true, Loading = false;

string TheNumber;
char ch_buf[20];
string inf_file,pretty_file,level_file;
string dir_file;

void main()
{
	ofstream df;

	df.open("debug_le.log");

	df << "Allegro init..." << endl;
	allegro_init();
	install_keyboard();
	install_timer();
	install_mouse();
	df << "Setting graphics mode..." << endl;
	set_color_depth(16);
	set_gfx_mode(GFX_AUTODETECT,320,240,0,0);
	text_mode(-1);

	df << "Loading packfile..." << endl;
	packfile_password("AntsData");
	data = load_datafile("ants.dat");
	packfile_password(NULL);

	df << "Creating colors..." << endl;
	int C_Red = makecol16(255, 0, 0);
	int C_Blue = makecol16(0, 0, 255);
	int C_Green = makecol16(0, 255, 0);
	int C_Yellow = makecol16(255, 255, 0);
	int C_Grey = makecol16(160,160,160);
	int C_Cyan = makecol16(0,255,255);
	int C_Ground = makecol16(100,160,20);
	int C_BBlue = makecol16(80,80,255);

	int C_Blue_Coin = makecol16(0,0,128);
	int C_Red_Coin = makecol16(128,0,0);
	int C_Green_Coin = makecol16(0,128,0);
	int C_Dark_Blue = makecol16(0,0,128);
	
	df << "Creating default bitmaps..." << endl;
	level = create_bitmap(320,205);
	pretty_level = create_bitmap(320,205);
	clear_to_color(level,0);
	clear_to_color(pretty_level,C_Dark_Blue);

	df << "Creating video buffer..." << endl;
	buffer = create_video_bitmap(640,240);
	if(!buffer) { buffer = create_bitmap(640,240); df << "Could not support video bitmap, using normal bitmap instead." << endl; }
	clear_to_color(buffer,0);

	df << "Resetting amounts..." << endl;
	for(int i=0;i<20;i++)
		Amt[i]=0;

	df << "Loading images from packfile..." << endl;
	block[0] = (BITMAP *)data[ADF_walker].dat;
	block[1] = (BITMAP *)data[ADF_raid].dat;
	block[2] = (BITMAP *)data[ADF_digger].dat;
	block[3] = (BITMAP *)data[ADF_stair].dat;
	block[4] = (BITMAP *)data[ADF_tunnler].dat;
	block[5] = (BITMAP *)data[ADF_blocker].dat;
	block[6] = (BITMAP *)data[ADF_turn].dat;
	block[7] = (BITMAP *)data[ADF_climber].dat;
	block[8] = (BITMAP *)data[ADF_swimmer].dat;
	block[9] = (BITMAP *)data[ADF_umbrella].dat;
	block[10] = (BITMAP *)data[ADF_platformer].dat;
	block[11] = (BITMAP *)data[ADF_bomber].dat;
	block[12] = (BITMAP *)data[ADF_miner].dat;
	block[13] = (BITMAP *)data[ADF_high_miner].dat;
	block[14] = (BITMAP *)data[ADF_bubbler].dat;
	block[15] = (BITMAP *)data[ADF_runner].dat;
	block[16] = (BITMAP *)data[ADF_exploder].dat;
	block[17] = (BITMAP *)data[ADF_stacker].dat;
	block[18] = (BITMAP *)data[ADF_radio].dat;
	block[19] = (BITMAP *)data[ADF_sloth].dat;

	bool Working = true, DownKey = false;

	double c_tick;

	int MouseSize = 3, MouseColor = C_Ground;

	df << "Ready. Starting main screen..." << endl;

	df.close();

	while( Working )
	{
		c_tick = retrace_count;

		if(key[KEY_ESC]) 
		{ 
			if( !DownKey )
			{
				DownKey = true;

				Working = false;
			}
		}
		else if(key[KEY_UP] || mouse_z > old_mw )
		{
			old_mw = mouse_z;

			if( !DownKey )
			{
				DownKey = true;


				if( MouseSize < 15 ) MouseSize++;
			}
		}
		else if(key[KEY_DOWN] || mouse_z < old_mw )
		{
			old_mw = mouse_z;

			if( !DownKey )
			{
				DownKey = true;

				if( MouseSize > 0 ) MouseSize--;
			}
		}
		else if(key[KEY_L])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Ground;
			}
		}
		else if(key[KEY_S])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Grey;
			}
		}
		else if(key[KEY_W])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_BBlue;
			}
		}
		else if(key[KEY_D])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Red;
			}
		}
		else if(key[KEY_A])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Green;
			}
		}
		else if(key[KEY_R])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Red_Coin;
			}
		}
		else if(key[KEY_G])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Green_Coin;
			}
		}
		else if(key[KEY_U])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Blue_Coin;
			}
		}
		else if(key[KEY_B])
		{
			if( !DownKey )
			{
				DownKey = true;

				MouseColor = C_Yellow;
			}
		}
		else if(key[KEY_V])
		{
			if( !DownKey )
			{
				DownKey = true;

				Started = true;
				Saving = true;
			}
		}
		else if(key[KEY_O])
		{
			if( !DownKey )
			{
				DownKey = true;

				Started = true;
				Loading = true;
			}
		}
		else if(key[KEY_E])
		{
			if( !DownKey )
			{
				DownKey = true;

				bool InSkills = true;

				int i = 0, wait=0;

				while( InSkills )
				{
					c_tick = retrace_count;

					clear_to_color(buffer,0);

					if( key[KEY_E] )
					{
						if( !DownKey )
						{
							DownKey = true;

							InSkills = false;
						}
					}
					else if( key[KEY_C] )
					{
						if( !DownKey )
						{
							DownKey = true;

							GB=-1;
							RB=-1;
							BB=-1;
						}
					}
					else { DownKey = false; }

					i=0; wait++;

					for(int y=0;y<2;y++)
					{
						for(int x=0;x<10;x++)
						{
							if(i<20)
							{	
								blit(block[i],buffer,0,0,x*25+360,y*35+20,25,35);
								textprintf_centre(buffer,font,x*25+373,y*35+43,65535,"%i",Amt[i]);
								if(BB == i) rect(buffer,(x)*25+362,y*35+22,x*25+382,y*35+51,C_Blue);
								else if(RB == i) rect(buffer,(x)*25+362,y*35+22,x*25+382,y*35+51,C_Red);
								else if(GB == i) rect(buffer,(x)*25+362,y*35+22,x*25+382,y*35+51,C_Green);
								i++;
							}
						}
					}

					textprintf_centre(buffer,font,480,120,C_Grey,"Ants to Drop: %i",Max_Ants);
					textprintf_centre(buffer,font,480,140,C_Grey,"Ants to Save: %i",Save_Ants);
					textprintf_centre(buffer,font,480,160,C_Grey,"Rate to Drop: %i",Drop_Rate);

					textprintf_centre(buffer,font,370,197,C_Red,"(R)ed_Coin");
					textprintf_centre(buffer,font,480,197,C_Blue,"(B)lue_Coin");
					textprintf_centre(buffer,font,590,197,C_Green,"(G)reen_Coin");
					textprintf_centre(buffer,font,480,205,C_Grey,"(C)lear Coin Settings");
					textprintf_centre(buffer,font,480,213,65535,"Left click to add.");
					textprintf_centre(buffer,font,480,221,65535,"Right click to subtract.");
					textprintf_centre(buffer,font,480,230,C_Grey,"Hit (E) to return.");
					circle(buffer,mouse_x+320,mouse_y,1,65535);

					blit(buffer,screen,320,0,0,0,320,240);

					if( (mouse_b & 1 || mouse_b & 2) && wait > 8 || key[KEY_R] || key[KEY_G] || key[KEY_B] )
					{
						wait = 0;

						if( key[KEY_R] ) { Color = C_Red; }
						else if( key[KEY_B] ) { Color = C_Blue; }
						else if( key[KEY_G] ) { Color = C_Green; }
						else { Color = 0; }

						int math = (mouse_x-40)/25;

						if( mouse_y < 55 )
						{
							if( math > -1 && math < 10 )
							{
								if( Color == 0 )
								{
									if( mouse_b & 1 ) { Amt[math]++; } 
									else { Amt[math]--; }
									if( Amt[math] > 99 ) { Amt[math] = 99; }
									else if( Amt[math] < 0 ) { Amt[math] = 0; }
								}
								else
								{
									if( Color == C_Red )
									{
										if( GB==math ) GB=-1;
										if( BB==math ) BB=-1;
										RB = math;
									}
									else if( Color == C_Blue )
									{
										if( math==GB ) GB=-1;
										if( math==RB ) RB=-1;
										BB = math;
									}
									else if( Color == C_Green )
									{
										if( math==RB ) RB=-1;
										if( math==BB ) BB=-1;
										GB = math;
									}
								}
							}
						}
						else if( mouse_y < 115 )
						{
							if( Color == 0 )
							{
								if( math > -1 && math < 10 )
								{
									if( mouse_b & 1 ) { Amt[math+10]++; }
									else { Amt[math+10]--; }
									if( Amt[math+10] > 99 ) { Amt[math+10] = 99; }
									else if( Amt[math+10] < 0 ) { Amt[math+10] = 0; }
								}
							}
							else
							{
								if( Color == C_Red )
								{
									if( GB==math+10 ) GB=-1;
									if( BB==math+10 ) BB=-1;
									RB = math+10;
								}
								else if( Color == C_Blue )
								{
									if( math+10==GB ) GB=-1;
									if( math+10==RB ) RB=-1;
									BB = math+10;
								}
								else if( Color == C_Green )
								{
									if( math+10==RB ) RB=-1;
									if( math+10==BB ) BB=-1;
									GB = math+10;
								}
							}
						}
						else if( mouse_y < 135 && Color == 0 )
						{
								if( mouse_b & 1 ) { Max_Ants++; } 
								else { Max_Ants--; }
								if( Max_Ants > 150 ) { Max_Ants = 150; }
								else if( Max_Ants < 1 ) { Max_Ants = 1; }
								if( Save_Ants > Max_Ants ) { Save_Ants = Max_Ants; }
						}
						else if( mouse_y < 155 && Color == 0 )
						{
								if( mouse_b & 1 ) { Save_Ants++; } 
								else { Save_Ants--; }
								if( Save_Ants > Max_Ants ) { Save_Ants = Max_Ants; }
								else if( Save_Ants < 0 ) { Save_Ants = 0; }
						}
						else if( Color == 0 )
						{
								if( mouse_b & 1 ) { Drop_Rate++; } 
								else { Drop_Rate--; }
								if( Drop_Rate > 200 ) { Drop_Rate = 200; }
								else if( Drop_Rate < 5 ) { Drop_Rate = 5; }
						}
					}
			
					while( !(retrace_count - c_tick) ) { yield_timeslice(); }
				}
			}
		}
		else if( !Saving && !Loading ) { DownKey = false; }

		blit(pretty_level,buffer,0,0,320,0,320,205);

		rectfill(buffer,320,205,640,240,0);

		if( !Saving && !Loading)
		{
			rectfill(buffer,320,225,340,240,MouseColor);
			if( MouseColor == C_Blue_Coin ) textprintf_centre(buffer,font,330,230,65535,"BC");
			else if( MouseColor == C_Red_Coin ) textprintf_centre(buffer,font,330,230,65535,"RC");
			else if( MouseColor == C_Green_Coin ) textprintf_centre(buffer,font,330,230,65535,"GC");
			else if( MouseColor == C_Yellow ) textprintf_centre(buffer,font,330,230,0,"BE");
//			circle(buffer,320+mouse_x,mouse_y,MouseSize,65535);
			rect(buffer,320+mouse_x-MouseSize,mouse_y-MouseSize,320+mouse_x+MouseSize,mouse_y+MouseSize,65535);
			textprintf(buffer,font,320,206,C_Ground,"(L)and");
			textprintf(buffer,font,376,206,C_Grey,"(S)teel");
			textprintf(buffer,font,440,206,C_BBlue,"(W)ater");
			textprintf(buffer,font,504,206,C_Red,"(D)eath");
			textprintf(buffer,font,568,206,C_Green,"S(A)fety");
			textprintf_centre(buffer,font,480,215,65425,"(R)ed_Coin (G)reen_Coin Bl(U)e_Coin");
			textprintf_centre(buffer,font,480,224,65475,"(B)egin S(E)ttings Sa(V)e L(O)ad");
			textprintf_centre(buffer,font,480,232,C_Grey,"Press [ESC] to Quit - v1.4");
		}
		else if( Saving )
		{
			if( key[KEY_UP] || key[KEY_DOWN] || key[KEY_RIGHT] || key[KEY_LEFT] || Started )
			{
				ifstream test;
	
				Started = false;
	
				if( key[KEY_UP] ) { level_selected++; }
				else if( key[KEY_DOWN] && level_selected > 1 ) { level_selected--; }
				else if( key[KEY_RIGHT] ) { dir_selected++; }
				else if( key[KEY_LEFT] && dir_selected > 1 ) { dir_selected--; }
	
				TheNumber = itoa(dir_selected,ch_buf,10);
				dir_file = "levels" + TheNumber;
				TheNumber = itoa(level_selected,ch_buf,10);
				inf_file = dir_file + "/level" + TheNumber + ".ini";
	
				test.open(inf_file.c_str());
	
				if( !exists(inf_file.c_str()) ) level_name = "----------";
				else
				{
					test >> level_name;
				}

				test.close();
			}
			else if( key[KEY_ESC] ) { Saving = false; DownKey = true; }
			else if( key[KEY_ENTER] )
			{
				int PC;

				for(int x=0;x<320;x++)
				{
					for(int y=0;y<205;y++)
					{
						PC = _getpixel16(pretty_level,x,y);
						if( PC == C_Blue || PC == C_Green_Coin || PC == C_Red_Coin )
							_putpixel16(pretty_level,x,y,C_Dark_Blue);
					}
				}
				_putpixel16(pretty_level,0,0,C_Dark_Blue);

				TheNumber = itoa(dir_selected,ch_buf,10);
				dir_file = "levels" + TheNumber;

				mkdir(dir_file.c_str());

				TheNumber = itoa(level_selected,ch_buf,10);
				level_file = dir_file + "/level" + TheNumber + ".pcx";
				pretty_file = dir_file + "/pretty" + TheNumber + ".pcx";
				inf_file = dir_file + "/level" + TheNumber + ".ini";
				save_pcx(level_file.c_str(),level,pal);
				save_pcx(pretty_file.c_str(),pretty_level,pal);

				for(x=0;x<320;x++)
				{
					for(int y=0;y<205;y++)
					{
						PC = _getpixel16(level,x,y);
						
						if( PC == C_Red_Coin || PC == C_Green_Coin )
							_putpixel16(pretty_level,x,y,PC);
						else if( PC == C_Blue_Coin )
							_putpixel16(pretty_level,x,y,C_Blue);
					}
				}

				ofstream inf;

				inf.open(inf_file.c_str());

				inf << "Level_" << level_selected << "_(LE)" << endl;
				inf << "max_ants" << endl;
				inf << Max_Ants << endl;
				inf << "drop_rate" << endl;
				inf << Drop_Rate << endl;
				inf << "save_ants" << endl;
				inf << Save_Ants << endl;

				PC = 0;
				for(int i=0;i<20;i++)
				{
					if( (Amt[i] > 0 || BB == i || RB == i || GB == i) && PC < 10 )
					{
						PC++;
						switch( i )
						{
						case 0:
							inf << "walker" << endl;
							break;
						case 1:
							inf << "raid" << endl;
							break;
						case 2:
							inf << "digger" << endl;
							break;
						case 3:
							inf << "builder" << endl;
							break;
						case 4:
							inf << "tunneler" << endl;
							break;
						case 5:
							inf << "blocker" << endl;
							break;
						case 6:
							inf << "turner" << endl;
							break;
						case 7:
							inf << "climber" << endl;
							break;
						case 8:
							inf << "swimmer" << endl;
							break;
						case 9:
							inf << "umbrella" << endl;
							break;
						case 10:
							inf << "platformer" << endl;
							break;
						case 11:
							inf << "bomber" << endl;
							break;
						case 12:
							inf << "miner" << endl;
							break;
						case 13:
							inf << "mine_high" << endl;
							break;
						case 14:
							inf << "bubbler" << endl;
							break;
						case 15:
							inf << "runner" << endl;
							break;
						case 16:
							inf << "exploder" << endl;
							break;
						case 17:
							inf << "stacker" << endl;
							break;
						case 18:
							inf << "radio" << endl;
							break;
						case 19:
							inf << "sloth" << endl;
							break;
						}
						if( RB == i ) { inf << Amt[i] << "_red_coin" << endl; }
						else if( BB == i ) { inf << Amt[i] << "_blue_coin" << endl; }
						else if( GB == i ) { inf << Amt[i] << "_green_coin" << endl; }
						else { inf << Amt[i] << endl; }
					}
				}

				inf.close();

				Saving = false;
				DownKey = true;
			}

			textprintf(buffer,font,320,206,65535,"Level File: %s",inf_file.c_str());
			textprintf(buffer,font,320,217,65535,"Level Name: %s",level_name.c_str());
			textprintf(buffer,font,320,228,65535,"Keys: ESC,UP,DOWN,LEFT,RIGHT,ENTER");
		}
		else if( Loading )
		{
			if( key[KEY_UP] || key[KEY_DOWN] || key[KEY_RIGHT] || key[KEY_LEFT] || Started )
			{
				ifstream test;
	
				Started = false;
	
				if( key[KEY_UP] ) { level_selected++; }
				else if( key[KEY_DOWN] && level_selected > 1 ) { level_selected--; }
				else if( key[KEY_RIGHT] ) { dir_selected++; }
				else if( key[KEY_LEFT] && dir_selected > 1 ) { dir_selected--; }
	
				TheNumber = itoa(dir_selected,ch_buf,10);
				dir_file = "levels" + TheNumber;
				TheNumber = itoa(level_selected,ch_buf,10);
				inf_file = dir_file + "/level" + TheNumber + ".ini";
	
				test.open(inf_file.c_str());
	
				if( !exists(inf_file.c_str()) ) level_name = "----------";
				else test >> level_name;

				test.close();
			}
			else if( key[KEY_ESC] ) { Loading = false; DownKey = true; }
			else if( key[KEY_ENTER] && level_name != "----------" )
			{
				ifstream inf;

				TheNumber = itoa(dir_selected,ch_buf,10);
				dir_file = "levels" + TheNumber;
				TheNumber = itoa(level_selected,ch_buf,10);
				inf_file = dir_file + "/level" + TheNumber + ".ini";

				inf.open(inf_file.c_str());

				for(int i=0;i<20;i++)
					Amt[i]=0;

				RB=-1;
				BB=-1;
				GB=-1;

				Max_Ants = 40;
				Save_Ants = 20;
				Drop_Rate = 70;

				inf >> level_name;
				int CurrentSlot=0;
				for(;!inf.eof();)
				{
					yield_timeslice();
					inf >> check;
					if( strstr(check.c_str(),"max_ants") ) { inf >> check; Max_Ants=atoi(check.c_str()); CurrentSlot=-1; }
					else if( strstr(check.c_str(),"drop_rate") ) { inf >> check; Drop_Rate=atoi(check.c_str()); CurrentSlot=-1; }
					else if( strstr(check.c_str(),"save_ants") ) { inf >> check; Save_Ants=atoi(check.c_str()); CurrentSlot=-1; }
					else if( strstr(check.c_str(),"walker") ) { CurrentSlot = 0; }
					else if( strstr(check.c_str(),"raid") ) { CurrentSlot = 1; }
					else if( strstr(check.c_str(),"digger") ) { CurrentSlot = 2; }
					else if( strstr(check.c_str(),"builder") ) { CurrentSlot = 3; }
					else if( strstr(check.c_str(),"tunneler") ) { CurrentSlot = 4; }
					else if( strstr(check.c_str(),"blocker") ) { CurrentSlot = 5; }
					else if( strstr(check.c_str(),"turner") ) { CurrentSlot = 6; }
					else if( strstr(check.c_str(),"climber") ) { CurrentSlot = 7; }
					else if( strstr(check.c_str(),"swimmer") ) { CurrentSlot = 8; }
					else if( strstr(check.c_str(),"umbrella") ) { CurrentSlot = 9; }
					else if( strstr(check.c_str(),"platformer") ) { CurrentSlot = 10; }
					else if( strstr(check.c_str(),"bomber") ) { CurrentSlot = 11; }
					else if( strstr(check.c_str(),"miner") ) { CurrentSlot = 12; }
					else if( strstr(check.c_str(),"mine_high") ) { CurrentSlot = 13; }
					else if( strstr(check.c_str(),"bubbler") ) { CurrentSlot = 14; }
					else if( strstr(check.c_str(),"runner") ) { CurrentSlot = 15; }
					else if( strstr(check.c_str(),"exploder") ) { CurrentSlot = 16; }
					else if( strstr(check.c_str(),"stacker") ) { CurrentSlot = 17; }
					else if( strstr(check.c_str(),"radio") ) { CurrentSlot = 18; }
					else if( strstr(check.c_str(),"sloth") ) { CurrentSlot = 19; }
					else { CurrentSlot = -1; }

					if( CurrentSlot > -1 )
					{
						inf >> check;
						Amt[CurrentSlot]=atoi(check.c_str());
						if( strstr(check.c_str(),"red_coin")) { RB = CurrentSlot; }
						else if( strstr(check.c_str(),"green_coin")) { GB = CurrentSlot; }
						else if( strstr(check.c_str(),"blue_coin")) { BB = CurrentSlot; }
					}
				}

				inf.close();

				level_file = dir_file + "/level" + TheNumber + ".pcx";
				pretty_file = dir_file + "/pretty" + TheNumber + ".pcx";
				
				level = load_pcx(level_file.c_str(),pal);
				pretty_level = load_pcx(pretty_file.c_str(),pal);

				int PC;

				for(int x=0;x<320;x++)
				{
					for(int y=0;y<205;y++)
					{
						PC = _getpixel16(level,x,y);
						
						if( PC == C_Red_Coin || PC == C_Green_Coin )
							_putpixel16(pretty_level,x,y,PC);
						else if( PC == C_Blue_Coin )
							_putpixel16(pretty_level,x,y,C_Blue);
					}
				}	

				Loading = false;
				DownKey = true;
			}

			textprintf(buffer,font,320,206,65535,"Level File: %s",inf_file.c_str());
			textprintf(buffer,font,320,217,65535,"Level Name: %s",level_name.c_str());
			textprintf(buffer,font,320,228,65535,"Keys: ESC,UP,DOWN,LEFT,RIGHT,ENTER");
		}

		if( mouse_y < 206 && !Saving && !Loading )
		{
			if( mouse_b & 1 )
			{
				if( MouseColor == C_Ground )
				{
					rectfill(level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,65535);
					rectfill(pretty_level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,MouseColor);
//					circlefill(level,mouse_x,mouse_y,MouseSize,65535);
//					circlefill(pretty_level,mouse_x,mouse_y,MouseSize,MouseColor);
				}
				else if( MouseColor == C_Red )
				{
					rectfill(level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,C_Red);
					rectfill(pretty_level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,MouseColor);
//					circlefill(level,mouse_x,mouse_y,MouseSize,C_Red);
//					circlefill(pretty_level,mouse_x,mouse_y,MouseSize,MouseColor);
				}
				else if( MouseColor == C_Green )
				{
					rectfill(level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,C_Green);
					rectfill(pretty_level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,MouseColor);
//					circlefill(level,mouse_x,mouse_y,MouseSize,C_Green);
//					circlefill(pretty_level,mouse_x,mouse_y,MouseSize,MouseColor);
				}
				else if( MouseColor == C_Yellow )
				{
					putpixel(level,mouse_x,mouse_y,C_Yellow);
					putpixel(pretty_level,mouse_x,mouse_y,0);
				}
				else if( MouseColor == C_Grey )
				{
					rectfill(level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,C_Cyan);
					rectfill(pretty_level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,MouseColor);
//					circlefill(level,mouse_x,mouse_y,MouseSize,C_Cyan);
//					circlefill(pretty_level,mouse_x,mouse_y,MouseSize,MouseColor);
				}
				else if( MouseColor == C_BBlue )
				{
					rectfill(level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,C_Blue);
					rectfill(pretty_level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,MouseColor);
//					circlefill(level,mouse_x,mouse_y,MouseSize,C_Blue);
//					circlefill(pretty_level,mouse_x,mouse_y,MouseSize,MouseColor);
				}
				else if( MouseColor == C_Red_Coin )
				{
					putpixel(level,mouse_x,mouse_y,C_Red_Coin);
					putpixel(pretty_level,mouse_x,mouse_y,C_Red_Coin);
				}
				else if( MouseColor == C_Blue_Coin )
				{
					putpixel(level,mouse_x,mouse_y,C_Blue_Coin);
					putpixel(pretty_level,mouse_x,mouse_y,C_Blue);
				}
				else if( MouseColor == C_Green_Coin )
				{
					putpixel(level,mouse_x,mouse_y,C_Green_Coin);
					putpixel(pretty_level,mouse_x,mouse_y,C_Green_Coin);
				}
			}
			else if( mouse_b & 2 )
			{
				rectfill(level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,0);
				rectfill(pretty_level,mouse_x-MouseSize,mouse_y-MouseSize,mouse_x+MouseSize,mouse_y+MouseSize,C_Dark_Blue);
//				circlefill(pretty_level,mouse_x,mouse_y,MouseSize,C_Dark_Blue);
//				circlefill(level,mouse_x,mouse_y,MouseSize,0);
			}
		}

		blit(buffer,screen,320,0,0,0,320,240);

		if( Saving || Loading ) readkey();
		
		while( !(retrace_count - c_tick) ) { yield_timeslice(); }
	}
}

END_OF_MAIN();