/*

  Ants! v1.241
  - By Jeremy Vight
  - I don't know what is in here... If I talk about my cat Frisky in here, so be it.
  - The main reason this is being released is so it can be compiled for linux.
  - If you make any changes, please send me the tweaked code and tell me what you did and why. If it is cool,
    I would like to incorporate that into my main release.

  Changes 1.22:
  - Made builders build a little faster.
  - Diggers are now more precise and less buggy.
  - Ant selection is now more accurate.
  Changes 1.23:
  - Makes a debug.log file showing how far it got.
  - If a system bitmap cannot be created, it creates a normal bitmap for use instead.
  Changes 1.24:
  - Umbrella users will not die if falling near a level edge.
  - Bombers and exploders will not scream and die near a level edge.
  Changes 1.241:
  - Removed the MIDI driver, uneeded.
  - Releasing the source code!
  Changes 1.3:
  - Added an arrow to the mouse cursor when using the arrow keys.
  - Fixed many tunnler bugs and made the tunnler easier to use.
  Changes 1.4:
  - Lotsa stuff.

http://phr00t.urgo.org/
jvight@student.umass.edu

*/

#include "allegro.h"
//#include "winalleg.h"
//#include <math.h>
//#include <stdlib.h>
//#include <stdio.h>
#include <fstream>
//#include <iostream>
//#include <time.h>
#include <ants.h>
#include <string>
using namespace std; // So we can use strings correctly.

bool GamePlaying = true;

PALETTE pal;

BITMAP *level, *pretty_level, *buffer, *point, *block[12], *status, *pretty_repair, *level_repair;

DATAFILE *data;

BITMAP *number[5];

int C_BG = 0;

int C_Red, C_Blue, C_Green, C_Yellow, C_Mask, C_Grey, C_LGrey, C_Cyan;

int C_Red_Coin, C_Blue_Coin, C_Green_Coin;

int C_Reg_Ant, C_Job_Ant, C_Ability_Ant, C_Super_Ant;

int Screen_X, Screen_Y;

int SelJob, JobSlot[10], JobSlot_Amt[10];

bool mouse_down = false;

SAMPLE *S_begin, *S_dink, *S_drown, *S_error, *S_lost, *S_select, *S_select2, *S_squish, *S_fail, *S_finalpieces;

SAMPLE *S_safe[4], *S_boom, *S_coin;
int stp=0;

int MAX_ANTS;
int ANTS_DROPPED;
int ANTS_OUT;
int ANTS_SAVED, ANTS_TO_SAVE;
int DROP_RATE, Dropper;
int SX[4], SY[4];

bool Nukem = false;

int Red_Slot=-1, Blue_Slot=-1, Green_Slot=-1;

ofstream df; // debug file

struct COIN
{
	COIN *N_Coin;
	COIN *P_Coin;

	int x, y;

	int ticker;

	bool EFL;

	int Color;

	COIN(bool P_EFL = false);

	void Remove();
};

struct ANT
{
	ANT *N_Ant;
	ANT *P_Ant;

	int FallHeight;

	int X, Y;

	int CurrentJob;

	int Color;

	// Job temporary variables, to be defined in job.
	int i1, i2, i3, i4, i5, i6;
	bool flag;

	bool EFL;

	int Direction;

	// Ability Flags
	bool Ability[20];
	// 0 = Climber
	// 1 = Umbrella
	// 2 = Swimmer
	// 3 = Runner
	// 4 = Exploder

	ANT(bool P_EFL = false);

	int FloorCheck;

	void Remove();

	void DoJob()
	{
		switch( CurrentJob )  // Add Job Point
		{
		case -2: // Saved!!
			Color = C_Green;
			if( i1 != -50 )
			{
				i1 = -50;
				i2 = 0;
				stp=rand()%4;
				play_sample(S_safe[stp],60,128,1000,false);
			}
			if( i2++ > 20 )
			{
				ANTS_SAVED++;
				i2=0;
				Remove();
			}
			break;
		case 0: // Walker
			Color = C_Reg_Ant;
			if( i1++ > (7 - (Ability[3]*5)) || i1 == -19 )
			{
				if( _getpixel16(level, X, Y+1) == 65534 && i1 != -19 ) Direction*=-1;
				for(i2=0;i2<4;i2++)
				{
					FloorCheck = getpixel(level,X+Direction,Y-i2);
					if( FloorCheck == 0 && i1 != -19 )
					{
						Y=Y-i2;
						X+=Direction;
						i1=-(i2*5);
						i2=10;
					}
					else if( FloorCheck == C_Red ) { CurrentJob=-3; play_sample(S_squish,70,128,1000,false); }
					else if( FloorCheck == C_Green ) { CurrentJob=-2; }
				}
				if( i1 == -19 ) { i1 = 0; i2=10; }
				if( CurrentJob > -1 )
				{
					FloorCheck = _getpixel16(level,X,Y+1);
					if( FloorCheck == 0 ) { CurrentJob = 1; i1=0; i2=0; break; }
					else if( FloorCheck == C_Blue )
					{
						if( !Ability[2] ) { CurrentJob = -3; play_sample(S_drown,50,128,1000,false); }
						else { CurrentJob = 9; }
					}
					else if( FloorCheck == C_Red ) { CurrentJob = -3; play_sample(S_squish,90,128,1000,false); }
					else if( FloorCheck == C_Green ) { CurrentJob = -2; }
					if( i2<10 )
					{
						if( Ability[0] ) { CurrentJob = 8; }
						else { Direction*=-1; }
					}
				}
			}
			break;
		case 1: // Faller
			Color = C_Reg_Ant;
			if( i1 != -42 ) { FallHeight = Y; i1 = -42; }
			if( i2++ > 2 )
			{
				i2=0;
				FloorCheck = _getpixel16(level, X, Y+1);
				if( Ability[1] && Y-FallHeight > 35 ) { i1=0; CurrentJob = 10; }
				if( FloorCheck != 0 )
				{
					if( Y-FallHeight > 45 && FloorCheck != C_Blue )
					{
						CurrentJob=-3;
						i1=-20; i2=0;
						play_sample(S_squish,90,128,1000,false);
					}
					else
					{
						CurrentJob = 0;
						i1=-20; i2=0;
					}
					break;
				}
				else { Y++; }
			}
			break;
		case -3: // Dieing!
			Color = C_Red;
			if( i2++ > 20 )
			{
				i2=0;
				Remove();
			}
			break;
		case 3: // Digger
			Color = C_Job_Ant;
			if( i2++ > 25 )
			{
				FloorCheck = _getpixel16(level,X,Y+1);
				if( FloorCheck == C_Cyan ) { CurrentJob = 0; play_sample(S_dink,75,128,1000,false); }
				else if( FloorCheck == C_Green ) { CurrentJob = -2; }
				else if( FloorCheck != 65535 ) { CurrentJob = 0; i1=-20; }
				else
				{
					i2=0;
					rectfill(level, X, Y, X, Y+1, 0);
					rectfill(pretty_level, X, Y, X, Y+1, C_BG);
					Y++;
				}
			}
			break;
		case 4: // Builder
			Color = C_Job_Ant;
			if( i1 != -41 ) { i3 = 0; i1 = -41; }
			if( i2++ > 35 )
			{
				i2=0; i3++;
				if( getpixel(level,X+Direction,Y-1) != 0 || getpixel(level,X,Y-3) != 0 || i3 == 13 )
				{
					CurrentJob = 20;
				}
				else
				{
					hline(level, X, Y, X+(Direction*2), 65535);
					if( i3 < 10 ) { hline(pretty_level, X, Y, X+(Direction*2), C_Grey); }
					else { hline(pretty_level, X, Y, X+(Direction*2), C_LGrey); play_sample(S_finalpieces,40,128,1000,false); }
					Y=Y-1;
					X+=Direction;
				}
			}
			break;
		case 5: // Tunnler
			Color = C_Job_Ant;
			if( i2++ > 25 )
			{
				if( _getpixel16(level,X,Y+1) != 65535 ) { CurrentJob = 0; i1=-20; i6=0; }
				flag = false; i6++;
				for(int i=0;i<3;i++)
				{
					FloorCheck = getpixel(level,X+Direction,Y-i);
					if( FloorCheck == C_Cyan) { flag = false; i=4; play_sample(S_dink,75,128,1000,false); }
					else if( FloorCheck == 65535 )
					{
						if(i==1) i6=3;
						flag = true;
					}
					else if( FloorCheck != 0 ) { CurrentJob = 0; i1=-20; i6=0; }
					else if( i6<3 ) flag = true;
				}
				if(!flag) { CurrentJob = 0; i6=0; i1=-20; }
				i2=0;
				if( CurrentJob == 5 )
				{
					rectfill(level, X, Y, X+Direction, Y-3, 0);
					rectfill(pretty_level, X, Y, X+Direction, Y-3, C_BG);
					X=X+Direction;
				}
			}
			break;
		case 6: // Blocker
			Color = C_Super_Ant;
			if( i1 != -40 ) { _putpixel16(level,X,Y+1,65534); i1 = -40; }
			if( _getpixel16(level,X,Y+1) == 0 ) { i1=0; CurrentJob=0; }
			break;
		case 8: // Climbing!
			Color = C_Job_Ant;
			if( i2++ > 10 )
			{
				i2 = 0;
				FloorCheck = getpixel(level,X,Y-3);
				if( FloorCheck != 0 ) { Direction*=-1; CurrentJob=1; }
				else if( FloorCheck == C_Green ) { CurrentJob=-2; }
				else
				{
					FloorCheck = _getpixel16(level,X+Direction,Y);
					if( FloorCheck == C_Cyan || FloorCheck == 65535 )
					{
						Y--;
					}
					else if( FloorCheck != 0 )
					{
						CurrentJob=1;
						Direction*=-1;
					}
					else { X+=Direction; CurrentJob=0; i1=0; }
				}
			}
			break;
		case 9: // Swimming
			Color = C_Job_Ant;
			if( i2++ > 8 )
			{
				i2 = 0;
				FloorCheck = _getpixel16(level,X,Y+1);
				if( FloorCheck != C_Blue ) { i1=-20; CurrentJob=0; }
				else
				{
					FloorCheck = _getpixel16(level,X+Direction,Y);
					if( FloorCheck != 0 )
					{
						i1=0;
						CurrentJob=0;
					}
					else if( FloorCheck == 0 )
					{
						X+=Direction;
					}
					else { X+=Direction; CurrentJob=0; }
				}
			}
			break;
		case 10: // Umbrella
			Color = C_Job_Ant;
			hline(buffer,X-1+320-Screen_X,Y-2-Screen_Y,X+1+320-Screen_X,C_Yellow);
			if( i2++ > 4 )
			{
				i2=0;
				FloorCheck = _getpixel16(level, X, Y+1);
				if( FloorCheck != 0 )
				{
					CurrentJob = 0;
					i1=-20; i2=0;
					break;
				}
				else { Y++; }
			}
			break;
		case 11: // Platformer
			Color = C_Job_Ant;
			if( i1 != -45 ) { i3 = 0; i1 = -45; }
			if( i2++ > 30 )
			{
				i2=0; i3++;
				if( _getpixel16(level,X+Direction,Y) != 0 || i3 == 18 )
				{
					CurrentJob = 20;
					i3 = 0;
				}
				else
				{
					hline(level, X, Y+1, X+(Direction*2), 65535);
					if( i3 < 15 )
					{
						if( i3%2==0 ) { hline(pretty_level, X, Y+1, X+(Direction*2), C_Grey); }
						else { hline(pretty_level, X, Y+1, X+(Direction*2), C_LGrey); }
					}
					else
					{
						hline(pretty_level, X, Y+1, X+(Direction*2), 65535);
						play_sample(S_finalpieces,40,128,1000,false);
					}
					X+=Direction;
				}
			}
			break;
		case 12: // Bomber
			if( i1 != -46 ) { i1= -46; i2 = 0; }
			circlefill(buffer,X+320-Screen_X,Y-Screen_Y,10-i2,C_Red);
			circlefill(buffer,X+320-Screen_X,Y-Screen_Y,5-(i2/2),C_Yellow);
			if(i2++==0)
			{
				circlefill(level,X,Y,10,0);
				circlefill(pretty_level,X,Y,10,C_BG);
				masked_blit(pretty_repair,pretty_level,X-11,Y-11,X-11,Y-11,22,22);
				masked_blit(level_repair,level,X-11,Y-11,X-11,Y-11,22,22);
				play_sample(S_boom,40,128,1000,false);
			}
			else if( i2==10 )
			{
				CurrentJob=0;
				i2=0;
			}
			break;
		case 13: // Miner
			Color = C_Job_Ant;
			if( i2++ > 25 )
			{
				if( _getpixel16(level,X,Y+1) == 0 ) { CurrentJob = 0; i1=-20; }
				flag = false;
				for(int i=-1;i<3;i++)
				{
					FloorCheck = getpixel(level,X+Direction,Y-i);
					if( FloorCheck == 65535 ) { flag = true; }
					else if( FloorCheck == C_Cyan ) { flag = false; i=4; play_sample(S_dink,75,128,1000,false); }
					else if( FloorCheck == C_Green ) { flag = false; i=4; }
				}
				if(!flag) { i1=-20; CurrentJob = 0; }
				i2=0;
				if( CurrentJob == 13 )
				{
					rectfill(level, X, Y+1, X+Direction, Y-3, 0);
					rectfill(pretty_level, X, Y+1, X+Direction, Y-3, C_BG);
					X=X+Direction;
					Y++;
				}
			}
			break;
		case 14: // High_Miner (Mine_High)
			Color = C_Job_Ant;
			if( i2++ > 25 )
			{
				if( _getpixel16(level,X,Y+1) != 65535 ) { CurrentJob = 0; i1=-20; i6=0; }
				flag = false;
				for(int i=0;i<3;i++)
				{
					FloorCheck = getpixel(level,X+Direction,Y-i);
					if( FloorCheck == 65535 ) { flag = true; i6=3; }
					else if( FloorCheck == C_Cyan ) { flag = false; i=4; play_sample(S_dink,75,128,1000,false); }
					else if( FloorCheck == C_Green ) { flag = false; i=4; }
					else if( FloorCheck == C_Red ) { flag = false; i=4; CurrentJob=-3; }
				}
				if(!flag && ++i6>2 ) { i1=-20; CurrentJob = 0; i6=0; }
				i2=0;
				if( CurrentJob == 14 )
				{
					if( i6>2 )
					{
						rectfill(level, X+Direction, Y-1, X+Direction, Y-4, 0);
						rectfill(pretty_level, X+Direction, Y-1, X+Direction, Y-4, C_BG);
						Y--;
					}
					X=X+Direction;
				}
			}
			break;
		case 15: // Bubble
			Color = C_Job_Ant;
			circle(buffer,X+320-Screen_X,Y-Screen_Y-1,2,C_Yellow);
			if( i2++ > 12 )
			{
				i2=0;
				FloorCheck = getpixel(level,X,Y-3);
				if( FloorCheck == C_Green ) { CurrentJob = -2; }
				else if( FloorCheck != 0 || getpixel(level,X+Direction,Y-1) != 0 )
				{ 
					i1 = -20;
					if( FloorCheck != C_Red ) { CurrentJob = 0; }
					else { CurrentJob = -3; }
				}
				if( CurrentJob == 15 )
				{
					Y--;
					X+=Direction;
				}
			}
			break;
		case 18: // Stacker
			Color = C_Job_Ant;
			if( i1 != -41 ) { i3 = 0; i1 = -41; }
			if( i2++ > 25 )
			{
				i2=0; i3++;
				if( getpixel(level,X,Y-3) != 0 || i3 == 10 )
				{
					CurrentJob = 20;
				}
				else
				{
					_putpixel16(level, X, Y, 65535);
					if( i3 < 7 ) { _putpixel16(pretty_level,X,Y,C_Grey); }
					else { _putpixel16(pretty_level, X, Y, C_LGrey); play_sample(S_finalpieces,40,128,1000,false); }
					Y--;
				}
			}
			break;
		case 19: // Radio Control
			Color = C_Job_Ant;
			rect(buffer,X+318-Screen_X,Y-3-Screen_Y,X+322-Screen_X,Y-Screen_Y,C_Red);
			if( key[KEY_UP] ) { i4=0; i3=-1; }
			else if( key[KEY_DOWN] ) { i4=0; i3=1; }
			else if( key[KEY_LEFT] ) { i4=-1; i3=0; }
			else if( key[KEY_RIGHT] ) { i4=1; i3=0; }
			if( i2++ > 2 )
			{
				i2=0;
				FloorCheck = getpixel(level,X+i4,Y+i3);
				if( FloorCheck == C_Green ) { CurrentJob = -2; }
				else if( FloorCheck != 0 ) { CurrentJob = 0; i1 = -20; }
				else
				{
					X+=i4;
					Y+=i3;
				}
			}
			break;
		case 20: // Waiting for a job.
			Color = C_Job_Ant;
			if( i2++ > 160 || _getpixel16(level,X,Y+1) == 0 ) { CurrentJob = 0; i1 = -20; }
			break;
		case 21: // Slother Jump
			Color = C_Job_Ant;
			if( i1 != -110 ) { i1 = -110; i3 = -13; }
			FloorCheck = getpixel(level,X,Y-1);
			if( FloorCheck == C_Green ) { CurrentJob = -2; }
			else if( FloorCheck == 65535 || FloorCheck == C_Cyan ) { CurrentJob = 22; i2 = 0; }
			else if( i2++ > (13-abs(i3)) )
			{ 
				i2 = 0;
				if( i3++ > -1 ) { Y++; }
				else { Y--; }

				if( i3 == 13 ) { CurrentJob = 0; i1 = -20; }
			}
			break;
		case 22: // Slother
			Color = C_Job_Ant;
			if( i2++ > 15 )
			{
				i2 = 0;
				FloorCheck = getpixel(level,X,Y-1);
				if( ((FloorCheck == 65535)|(FloorCheck == C_Cyan)) )
				{
					FloorCheck = getpixel(level,X+Direction,Y);
					if( FloorCheck == C_Green ) { CurrentJob = -2; }
					else if( FloorCheck == C_Red ) { CurrentJob = -3; }
					else if( FloorCheck != 0 ) { CurrentJob = 0; i1 = -20; }
					else { X+=Direction; }
				}
				else { CurrentJob = 0; i1=-20; }
			}
			break;
		}
	}
};

ANT F_Ant(true);
ANT L_Ant(true);

ANT::ANT(bool P_EFL) : X(0), Y(0), CurrentJob(0), FallHeight(0), Direction(1), EFL(P_EFL), i1(0), i2(0),
	i3(0), i4(0), Color(C_Reg_Ant), i5(0), i6(0)
{
	if( !EFL )
	{
		L_Ant.P_Ant->N_Ant = this;
		P_Ant = L_Ant.P_Ant;
		L_Ant.P_Ant = this;
		N_Ant = &L_Ant;

		for(int i=0;i<20;i++) Ability[i] = false;
	}
}

COIN F_Coin(true);
COIN L_Coin(true);

COIN::COIN(bool P_EFL) : x(0), y(0), EFL(P_EFL), Color(C_Red), ticker(0)
{
	if( !EFL )
	{
		L_Coin.P_Coin->N_Coin = this;
		P_Coin = L_Coin.P_Coin;
		L_Coin.P_Coin = this;
		N_Coin = &L_Coin;
	}
}

void ANT::Remove()
{
	N_Ant->P_Ant = P_Ant;
	P_Ant->N_Ant = N_Ant;

	ANTS_OUT--;
}

void COIN::Remove()
{
	N_Coin->P_Coin = P_Coin;
	P_Coin->N_Coin = N_Coin;
}

int block_selected = -1, old_block = -1, TheJob = -1;

int level_selected = 1, dir_selected = 1;
string level_name = "Unnamed Level";

void Random_Level() // Bang up job of a level generator.
{
	srand( time(NULL) );

	clear_bitmap( screen );
	textprintf(screen,font,160,116,65535,"Generating Level...");

	int z=0, w=0, CX, CY, WaterLevel = rand()%40+5, Amt_R = rand()%22+5, Amt_S = rand()%6+1, Amt_K = rand()%5;

	MAX_ANTS = rand()%60+30;
	ANTS_TO_SAVE = rand()%(MAX_ANTS-15)+15;

	DROP_RATE = rand()%100+50;

	int x1,y1,x2,y2;

	level = create_bitmap(320,205);
	pretty_level = create_bitmap(320,205);

	clear_to_color(level,0);
	clear_to_color(pretty_level,makecol16(0,0,128));

	int C_Ground = makecol16(100,160,20);
	int C_BBlue = makecol16(80,80,255);

	int exit_x=-1, exit_y=-1;

	for(z=0;z<Amt_K;z++)
	{
		x1 = rand()%320;
		y1 = rand()%180+20;
		x2 = rand()%30+10;
		rectfill(level,x1-(x2*.5),y1-(x2*.5),x1+(x2*.5),y1+(x2*.5),C_Red);
		rectfill(pretty_level,x1-(x2*.5),y1-(x2*.5),x1+(x2*.5),y1+(x2*.5),C_Red);
	}
	for(z=0;z<Amt_R;z++)
	{
		x1 = rand()%320;
		y1 = rand()%180+20;
		x2 = rand()%15+5;
		y2 = rand()%200+60;
		for(w=0;w<y2;w++)
		{
			if( w == 0 || rand()%20==0 )
			{
				if(rand()%2==0)
				{
					CX = ((rand()%2*2)-1);
					CY = 0;
				}
				else
				{
					CY = ((rand()%2*2)-1);
					CX = 0;
				}
			}
			rectfill(level,x1-(x2*.5),y1-(x2*.5),x1+(x2*.5),y1+(x2*.5),65535);
			rectfill(pretty_level,x1-(x2*.5),y1-(x2*.5),x1+(x2*.5),y1+(x2*.5),C_Ground);
			if(y1-(x2*.5)>10 && y1<(205-WaterLevel) && exit_x<0){exit_x=x1;exit_y=y1-(x2*.5);}
			x1+=CX;
			y1+=CY;
		}
	}
	for(z=0;z<Amt_S;z++)
	{
		x1 = rand()%320;
		y1 = rand()%180+20;
		x2 = rand()%7+2;
		y2 = rand()%100+25;
		for(w=0;w<y2;w++)
		{
			if( w == 0 || rand()%20==0 )
			{
				if(rand()%2==0)
				{
					CX = ((rand()%2*2)-1);
					CY = 0;
				}
				else
				{
					CY = ((rand()%2*2)-1);
					CX = 0;
				}
			}
			rectfill(level,x1-(x2*.5),y1-(x2*.5),x1+(x2*.5),y1+(x2*.5),C_Cyan);
			rectfill(pretty_level,x1-(x2*.5),y1-(x2*.5),x1+(x2*.5),y1+(x2*.5),C_Grey);
			x1+=CX;
			y1+=CY;
		}
	}

	rectfill(level,exit_x,exit_y,exit_x+10,exit_y-10,C_Green);
	rectfill(pretty_level,exit_x,exit_y,exit_x+10,exit_y-10,C_Green);
	//textprintf_centre(pretty_level,font,160,0,65535,"%i:%i",exit_x,exit_y);

	x1 = rand()%300+10;
	y1 = rand()%(180-WaterLevel)+10;

	bool GoAgain = true;
	
	while( GoAgain )
	{
		x1 = rand()%300+10;
		y1 = rand()%(180-WaterLevel)+10;

		if( getpixel(level,x1,y1) == 0 )
		{
			for(y2=0;y2<40;y2++)
			{
				if( getpixel(level,x1,y1+y2) == 65535 ) { GoAgain = false; }
			}
		}
	}

	GoAgain = true;

	rectfill(level,0,205-WaterLevel,320,205,C_Blue);
	rectfill(pretty_level,0,205-WaterLevel,320,205,C_BBlue);

	putpixel(level,x1,y1,C_Yellow);
	putpixel(pretty_level,x1,y1,0);

	for(x1=0;x1<10;x1++) { JobSlot[x1] = -1; }

	for(z=0;z<10;z++)
	{
		while( GoAgain )
		{

		switch( rand()%20 )
		{
		case 0:
			JobSlot[z]=0;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 1:
			JobSlot[z]=-3;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 2:
			JobSlot[z]=3;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 3:
			JobSlot[z]=4;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 4:
			JobSlot[z]=5;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 5:
			JobSlot[z]=6;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 6:
			JobSlot[z]=7;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 7:
			JobSlot[z]=8;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 8:
			JobSlot[z]=9;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 9:
			JobSlot[z]=10;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 10:
			JobSlot[z]=11;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 11:
			JobSlot[z]=12;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 12:
			JobSlot[z]=13;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 13:
			JobSlot[z]=14;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 14:
			JobSlot[z]=15;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 15:
			JobSlot[z]=16;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 16:
			JobSlot[z]=17;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 17:
			JobSlot[z]=18;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 18:
			JobSlot[z]=19;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		case 19:
			JobSlot[z]=21;
			JobSlot_Amt[z]=rand()%20+1;
			break;
		}

		GoAgain = false;

		for(x2=0;x2<10;x2++)
			if( JobSlot[z] == JobSlot[x2] && z != x2 ) GoAgain = true;

		}

		GoAgain = true;
	}

	putpixel(pretty_level,0,0,makecol(0,0,128));
}

int Start_Locations = 0, h=0;

int check_for_coins=0;

void Load_Level()
{
	Nukem = false;

	clear_bitmap(screen);
	textprintf_centre(screen,font,160,112,65535,"Loading. . .");

	F_Ant.N_Ant = &L_Ant;
	L_Ant.P_Ant = &F_Ant;

	F_Coin.N_Coin = &L_Coin;
	L_Coin.P_Coin = &F_Coin;

	ifstream inf;

	ANTS_DROPPED = 0;
	ANTS_OUT = 0;
	ANTS_SAVED = 0;

	check_for_coins = 0;

	Red_Slot = -1;
	Green_Slot = -1;
	Blue_Slot = -1;

	char ch_buf[20];
	string level_to_load, pretty_level_to_load, inf_to_load, TheNumber, check;
	string dir_to_load="levels";

	Start_Locations = 0;
	h=0;

	if( level_selected > 0 )
	{
	ANTS_TO_SAVE = 0;
	MAX_ANTS = 0;

	TheNumber = itoa(dir_selected,ch_buf,10);
	dir_to_load+=TheNumber;
	TheNumber = itoa(level_selected,ch_buf,10);
	level_to_load = dir_to_load + "/level" + TheNumber + ".pcx";
	inf_to_load = dir_to_load + "/level" + TheNumber + ".ini";
	pretty_level_to_load = dir_to_load + "/pretty" + TheNumber + ".pcx";

	for(int i=0;i<10;i++) { JobSlot[i] = -1; JobSlot_Amt[i] = 0; }

	inf.open(inf_to_load.c_str());

	inf >> level_name;
	int CurrentSlot=0;
	for(;!inf.eof();)
	{
		yield_timeslice();
		inf >> check;
		if( strstr(check.c_str(),"max_ants") ) { inf >> check; MAX_ANTS=atoi(check.c_str()); }
		else if( strstr(check.c_str(),"drop_rate") ) { inf >> check; DROP_RATE=atoi(check.c_str()); }
		else if( strstr(check.c_str(),"save_ants") ) { inf >> check; ANTS_TO_SAVE=atoi(check.c_str()); }
		else if( strstr(check.c_str(),"walker") )  // Add Job Point
		{
			inf >> check;
			JobSlot[CurrentSlot]=0;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"digger") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=3;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"builder") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=4;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"tunnler") || strstr(check.c_str(),"tunneler") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=5;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"blocker") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=6;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"turner") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=7;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"climber") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=8;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"swimmer") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=9;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"raid") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=-3;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"umbrella") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=10;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"platformer") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=11;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"bomber") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=12;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"miner") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=13;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"mine_high") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=14;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"bubbler") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=15;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"runner") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=16;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"exploder") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=17;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"stacker") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=18;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"radio") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=19;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}
		else if( strstr(check.c_str(),"sloth") )
		{
			inf >> check;
			JobSlot[CurrentSlot]=21;
			JobSlot_Amt[CurrentSlot++]=atoi(check.c_str());
		}

		if( CurrentSlot-1 > -1 )
		{
			if( JobSlot[CurrentSlot-1] != -1 )
			{
				if( strstr(check.c_str(),"red_coin")) { Red_Slot = CurrentSlot-1; }
				else if( strstr(check.c_str(),"green_coin")) { Green_Slot = CurrentSlot-1; }
				else if( strstr(check.c_str(),"blue_coin")) { Blue_Slot = CurrentSlot-1; }
			}
		}
	}

	inf.close();

	level = load_pcx(level_to_load.c_str(),pal);
	pretty_level = load_pcx(pretty_level_to_load.c_str(),pal);
	}

	Dropper = DROP_RATE-50;

	SelJob = -1;
	block_selected = -1;
	old_block = -1;

	level_repair = create_bitmap(level->w,level->h);
	pretty_repair = create_bitmap(pretty_level->w,pretty_level->h);
	clear_to_color(level_repair,C_Mask);
	clear_to_color(pretty_repair,C_Mask);

	int IX, IY, PC;

	for(IX=0;IX<level->w;IX++)
	{
		for(IY=0;IY<level->h;IY++)
		{
			yield_timeslice();

			PC = _getpixel16(level,IX,IY);
			if( PC == C_Yellow )
			{
				_putpixel16(level,IX,IY,0);

				SX[h] = IX;
				SY[h++] = IY;
				Start_Locations++;
				PC = _getpixel16(pretty_level,IX,IY);
				_putpixel16(pretty_repair,IX,IY,PC);
			}
			else if( PC == C_Cyan || PC == C_Blue || PC == C_Red || PC == C_Green )
			{
				_putpixel16(level_repair,IX,IY,PC);
				PC = _getpixel16(pretty_level,IX,IY);
				_putpixel16(pretty_repair,IX,IY,PC);
			}
			else if( PC == C_Red_Coin || PC == C_Blue_Coin || PC == C_Green_Coin )
			{
				_putpixel16(level,IX,IY,0);

				COIN *nc = new COIN();
				nc->x = IX;
				nc->y = IY;
				if( PC == C_Red_Coin ) { nc->Color = C_Red; }
				else if( PC == C_Blue_Coin ) { nc->Color = C_Blue; }
				else if( PC == C_Green_Coin ) { nc->Color = C_Green; }
			}
		}
	}

	h=0;

	for(int i=0;i<10;i++)
	{
		switch(JobSlot[i])  // Add Job Point
		{
		case -1:
			block[i] = (BITMAP *)data[ADF_null].dat;
			break;
		case 0:
			block[i] = (BITMAP *)data[ADF_walker].dat;
			break;
		case -3:
			block[i] = (BITMAP *)data[ADF_raid].dat;
			break;
		case 3:
			block[i] = (BITMAP *)data[ADF_digger].dat;
			break;
		case 4:
			block[i] = (BITMAP *)data[ADF_stair].dat;
			break;
		case 5:
			block[i] = (BITMAP *)data[ADF_tunnler].dat;
			break;
		case 6:
			block[i] = (BITMAP *)data[ADF_blocker].dat;
			break;
		case 7:
			block[i] = (BITMAP *)data[ADF_turn].dat;
			break;
		case 8:
			block[i] = (BITMAP *)data[ADF_climber].dat;
			break;
		case 9:
			block[i] = (BITMAP *)data[ADF_swimmer].dat;
			break;
		case 10:
			block[i] = (BITMAP *)data[ADF_umbrella].dat;
			break;
		case 11:
			block[i] = (BITMAP *)data[ADF_platformer].dat;
			break;
		case 12:
			block[i] = (BITMAP *)data[ADF_bomber].dat;
			break;
		case 13:
			block[i] = (BITMAP *)data[ADF_miner].dat;
			break;
		case 14:
			block[i] = (BITMAP *)data[ADF_high_miner].dat;
			break;
		case 15:
			block[i] = (BITMAP *)data[ADF_bubbler].dat;
			break;
		case 16:
			block[i] = (BITMAP *)data[ADF_runner].dat;
			break;
		case 17:
			block[i] = (BITMAP *)data[ADF_exploder].dat;
			break;
		case 18:
			block[i] = (BITMAP *)data[ADF_stacker].dat;
			break;
		case 19:
			block[i] = (BITMAP *)data[ADF_radio].dat;
			break;
		case 21:
			block[i] = (BITMAP *)data[ADF_sloth].dat;
			break;
		}
	}

	C_BG = _getpixel16(pretty_level,0,0);

	Screen_X = SX[0] - 160;
	Screen_Y = SY[0] - 120;
	if(Screen_X<0)Screen_X=0;
	if(Screen_Y<0)Screen_Y=0;
	if(Screen_X>level->w-320)Screen_X=level->w-320;
	if(Screen_Y>level->h-205)Screen_Y=level->h-205;
}

BITMAP *title;

void Main_Game_Loop();

void Main_Menu()
{
	bool InMenu = true, Started = true;

	show_mouse(NULL);

	char ch_buf[20];
	string inf_to_load, TheNumber, dir_to_load="levels";

	while( key[KEY_ENTER] || key[KEY_ESC] ) { yield_timeslice(); }

	df << "Game ready. Displaying the main menu!" << endl;

	df.close();

	while( InMenu )
	{
		if( key[KEY_UP] || key[KEY_DOWN] || key[KEY_RIGHT] || key[KEY_LEFT] || Started )
		{
			ifstream test;

			Started = false;

			if( key[KEY_UP] ) { level_selected++; }
			else if( key[KEY_DOWN] && level_selected > 0 ) { level_selected--; }

			if( level_selected > 0 )
			{
				if( key[KEY_RIGHT] ) { dir_selected++; }
				else if( key[KEY_LEFT] && dir_selected > 1 ) { dir_selected--; }

				TheNumber = itoa(dir_selected,ch_buf,10);
				dir_to_load="levels"+TheNumber;
				TheNumber = itoa(level_selected,ch_buf,10);
				inf_to_load = dir_to_load + "/level" + TheNumber + ".ini";

				test.open(inf_to_load.c_str());

				if( !exists(inf_to_load.c_str()) ) level_name = "----------";
				else
				{
					test >> level_name;
				}

				test.close();
			}
			else
			{
				level_name = "Random Level!";
				inf_to_load = "----------";
			}
		}

		blit(title,buffer,0,0,320,0,320,240);
		textprintf(buffer,font,146+320,162,65535,"%i",level_selected);
		textprintf(buffer,font,146+320,176,65535,"%s",level_name.c_str() );
		textprintf(buffer,font,146+320,190,65535,"%s",inf_to_load.c_str() );
		textprintf(buffer,font,275+320,27,C_LGrey,"v1.4");
		blit(buffer,screen,320,0,0,0,320,240);

		readkey();

		if( key[KEY_ENTER] )
		{
			if( level_name != "----------" ) { InMenu = false; }
			else { play_sample(S_error,175,128,1000,false); }
		}
		else if( key[KEY_ESC] ) { exit(1); }

		yield_timeslice();
	}

	GamePlaying = true;
	if( level_selected == 0 ) Random_Level();
	Load_Level();
	Main_Game_Loop();
}

void Init_Game()
{
	set_color_conversion(COLORCONV_REDUCE_TRUE_TO_HI);
	
	df << "Initializing Linked Lists..." << endl;
	F_Ant.N_Ant = &L_Ant;
	L_Ant.P_Ant = &F_Ant;

	F_Coin.N_Coin = &L_Coin;
	L_Coin.P_Coin = &F_Coin;

	df << "Creating video bitmap buffer..." << endl;
	buffer = create_video_bitmap(640,240);
	if( !buffer ) { buffer = create_bitmap(640,240); df << "Cannot support video bitmap, using normal bitmap." << endl; }
	clear_bitmap(buffer);

	df << "Loading images..." << endl;
	point = (BITMAP *)data[ADF_point].dat;
	title = (BITMAP *)data[ADF_title].dat;
	status = (BITMAP *)data[ADF_status].dat;

	df << "Creating color table..." << endl;
	C_Red = makecol16(255, 0, 0);
    C_Blue = makecol16(0, 0, 255);
	C_Green = makecol16(0, 255, 0);
	C_Yellow = makecol16(255, 255, 0);
	C_Grey = makecol16(128,128,128);
	C_LGrey = makecol16(180,180,180);
	C_Mask = makecol16(255, 0, 255);
	C_Cyan = makecol16(0,255,255);

	C_Blue_Coin = makecol16(0,0,128);
	C_Red_Coin = makecol16(128,0,0);
	C_Green_Coin = makecol16(0,128,0);

	C_Job_Ant = makecol16(255,128,0);
	C_Reg_Ant = makecol16(180,95,0);
	C_Ability_Ant = makecol16(200,160,128);
	C_Super_Ant = makecol16(225,200,180);

	block[10] = (BITMAP *)data[ADF_fast].dat;
	block[11] = (BITMAP *)data[ADF_pause].dat;

	df << "Loading sounds..." << endl;
	S_begin = (SAMPLE *)data[ADF_begin].dat;
	S_dink = (SAMPLE *)data[ADF_dink].dat;
	S_drown = (SAMPLE *)data[ADF_drown].dat;
	S_error = (SAMPLE *)data[ADF_error].dat;
	S_lost = (SAMPLE *)data[ADF_lost].dat;
	S_select = (SAMPLE *)data[ADF_select].dat;
	S_select2 = (SAMPLE *)data[ADF_select2].dat;
	S_squish = (SAMPLE *)data[ADF_squish].dat;
	S_fail = (SAMPLE *)data[ADF_fail].dat;
	S_finalpieces = (SAMPLE *)data[ADF_finalpieces].dat;
	S_boom = (SAMPLE *)data[ADF_boom].dat;
	S_coin = (SAMPLE *)data[ADF_coin].dat;

	number[4] = (BITMAP *)data[ADF_5].dat;
	number[3] = (BITMAP *)data[ADF_4].dat;
	number[2] = (BITMAP *)data[ADF_3].dat;
	number[1] = (BITMAP *)data[ADF_2].dat;
	number[0] = (BITMAP *)data[ADF_1].dat;

	S_safe[0] = (SAMPLE *)data[ADF_safe1].dat;
	S_safe[1] = (SAMPLE *)data[ADF_safe2].dat;
	S_safe[2] = (SAMPLE *)data[ADF_safe3].dat;
	S_safe[3] = (SAMPLE *)data[ADF_safe4].dat;

	df << "Setting mouse info..." << endl;
	set_mouse_sprite(point);
	set_mouse_sprite_focus(3, 3);
}

void Draw_GUI()
{
	for(int i=0;i<12;i++)
	{
		blit(block[i],buffer,0,0,((i*25))+320,205,25,35);
		if( JobSlot[i] != -1 && i < 10 ) { textprintf_centre(buffer,font,((i*25)+13)+320,228,65535,"%i",JobSlot_Amt[i]); }
		if( block_selected == i ) rect(buffer, ((i*25))+320, 205, ((i*25)+24)+320, 239, C_Yellow);
		if( i == Red_Slot ) { rect(buffer,((i*25))+322,208,((i*25)+21)+321,236,C_Red); }
		else if( i == Green_Slot ) { rect(buffer,((i*25))+322,208,((i*25)+21)+321,236,C_Green); }
		else if( i == Blue_Slot ) { rect(buffer,((i*25))+322,208,((i*25)+21)+321,236,C_Blue); }
	}
	blit(status,buffer,0,0,620,205,20,35);
	if( ANTS_SAVED < ANTS_TO_SAVE ) { textprintf_centre(buffer,font,630,212,C_Red,"%i",ANTS_SAVED); }
	else { textprintf_centre(buffer,font,630,212,C_Green,"%i",ANTS_SAVED); }
	textprintf_centre(buffer,font,630,230,65535,"%i",ANTS_OUT);

	if( Nukem ) { textprintf_centre(buffer,font,160+320,0,65535,"Nukage. Press [ESC] to exit."); }

	if( key[KEY_RIGHT] )
	{
		line(buffer,mouse_x-3+320,mouse_y+6,mouse_x+3+320,mouse_y+6,65535);
		line(buffer,mouse_x+3+320,mouse_y+6,mouse_x+1+320,mouse_y+4,65535);
		line(buffer,mouse_x+3+320,mouse_y+6,mouse_x+1+320,mouse_y+8,65535);
	}
	else if( key[KEY_LEFT] )
	{
		line(buffer,mouse_x-3+320,mouse_y+6,mouse_x+3+320,mouse_y+6,65535);
		line(buffer,mouse_x-3+320,mouse_y+6,mouse_x-1+320,mouse_y+4,65535);
		line(buffer,mouse_x-3+320,mouse_y+6,mouse_x-1+320,mouse_y+8,65535);
	}
}

ANT *Select_Ant()
{
	int DFC=6, c_DFC;
	ANT *selected = &F_Ant;
	for(ANT *a=F_Ant.N_Ant;a!=&L_Ant;a=a->N_Ant)
	{
		c_DFC = abs(a->X-(mouse_x+Screen_X)) + abs(a->Y-2-(mouse_y+Screen_Y));
		if( key[KEY_RIGHT] && a->Direction < 1 || key[KEY_LEFT] && a->Direction > -1 ) { c_DFC = 6; }
		if( c_DFC < DFC )
		{
			DFC = c_DFC;
			selected = a;
		}
	}

	return selected;
}

bool DownKey = false;

void Input_Control()
{
	if(key[KEY_ESC])
	{
		if( !DownKey )
		{
			if( Nukem ) { GamePlaying = false; }
			Nukem = true;
			DownKey = true;
		}
	}
	else { DownKey = false; }

	if( mouse_x > 317 && Screen_X < level->w-320 ) Screen_X++;
	if( mouse_x < 3 && Screen_X > 0 ) Screen_X--;
	if( mouse_y > 237 && Screen_Y < level->h-205 ) Screen_Y++;
	if( mouse_y < 3 && Screen_Y > 0 ) Screen_Y--;

	if( key[KEY_1] ) { if(block_selected!=0){block_selected=0; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,700,false);} }
	else if( key[KEY_2] ) { if(block_selected!=1){block_selected=1; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,750,false);} }
	else if( key[KEY_3] ) { if(block_selected!=2){block_selected=2; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,800,false);} }
	else if( key[KEY_4] ) { if(block_selected!=3){block_selected=3; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,850,false);} }
	else if( key[KEY_5] ) { if(block_selected!=4){block_selected=4; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,900,false);} }
	else if( key[KEY_6] ) { if(block_selected!=5){block_selected=5; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,950,false);} }
	else if( key[KEY_7] ) { if(block_selected!=6){block_selected=6; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,1000,false);} }
	else if( key[KEY_8] ) { if(block_selected!=7){block_selected=7; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,1050,false);} }
	else if( key[KEY_9] ) { if(block_selected!=8){block_selected=8; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,1100,false);} }
	else if( key[KEY_0] ) { if(block_selected!=9){block_selected=9; SelJob = JobSlot[block_selected]; play_sample(S_select,50,128,1150,false);} }

	if( mouse_b & 1 )
	{
		if( !mouse_down )
		{
			if( mouse_y > 205 && mouse_x < 300 )
			{
				mouse_down = true;
				TheJob = (mouse_x)/25;
				if( block_selected == TheJob )
				{
					TheJob = old_block;
					block_selected = TheJob;
					if( TheJob > -1 && TheJob < 11 ) { SelJob = JobSlot[TheJob]; }
				}
				else
				{
					old_block = block_selected;
					block_selected = TheJob;
					if( TheJob > -1 && TheJob < 11 ) { SelJob = JobSlot[TheJob]; }
				}
				if( TheJob > -1 ) { play_sample(S_select,50,128,700+(TheJob*50),false); }
			}
			else
			{
				ANT *sel_ant = Select_Ant();
				if( sel_ant != &F_Ant )
				{
					if( ((SelJob > -1)|(SelJob==-3)) && block_selected < 10 && JobSlot_Amt[block_selected] > 0 && sel_ant->CurrentJob > -1 ) 
					{
						if( sel_ant->CurrentJob != SelJob && sel_ant->i1 != -2 && sel_ant->i1 != -3 )
						{ // Add Job Point
							if( SelJob == 8 )
							{
								if( !sel_ant->Ability[0] ) { sel_ant->Ability[0] = true; JobSlot_Amt[block_selected]--; mouse_down=true; }
							}
							else if( SelJob == 9 )
							{
								if( !sel_ant->Ability[2] ) { sel_ant->Ability[2] = true; JobSlot_Amt[block_selected]--; mouse_down=true; }
							}
							else if( SelJob == 10 )
							{
								if( !sel_ant->Ability[1] ) { sel_ant->Ability[1] = true; JobSlot_Amt[block_selected]--; mouse_down=true; }
							}
							else if( SelJob == 16 )
							{
								if( !sel_ant->Ability[3] ) { sel_ant->Ability[3] = true; JobSlot_Amt[block_selected]--; mouse_down=true; }
							}
							else if( SelJob == 17 )
							{
								if( !sel_ant->Ability[4] ) { sel_ant->i5=0; sel_ant->Ability[4] = true; JobSlot_Amt[block_selected]--; mouse_down=true; }
							}
							else if( SelJob == 7 )
							{
								if( sel_ant->CurrentJob != 8 )
								{
									sel_ant->Direction*=-1;
									JobSlot_Amt[block_selected]--;
									mouse_down=true; 
								}
							}
							else if( ((sel_ant->CurrentJob!=1)|(SelJob==15 || SelJob==19)) && sel_ant->CurrentJob != 9 && sel_ant->CurrentJob != 15 && sel_ant->CurrentJob != 21 && sel_ant->CurrentJob != 22 && sel_ant->CurrentJob != 19 )
							{
								if( sel_ant->CurrentJob == 6 ) _putpixel16(level,sel_ant->X,sel_ant->Y+1,65535);
								sel_ant->CurrentJob = SelJob;
								JobSlot_Amt[block_selected]--;
								sel_ant->i2 = 0;
								sel_ant->i3 = 0;
								sel_ant->i4 = 0;
								sel_ant->i6 = 0;
								mouse_down=true;
							}
							if(mouse_down) { play_sample(S_select2,75,128,1000,false); }
						}
					}
				}
			}
		}
	}
	else { mouse_down = false; }
}

int math_x, math_y;

void Ants_Control()
{
	for(COIN *c=F_Coin.N_Coin;c!=&L_Coin;c=c->N_Coin)
	{
		math_x = c->x-Screen_X;
		math_y = c->y-Screen_Y;

		if( math_x > 0 && math_x < 320 && math_y > 0 && math_y < 205 )
		{
			circlefill(buffer,math_x+320,math_y,1,c->Color);
			if( c->ticker++ > 40 )
			{ 
				if( c->ticker > 80 ) c->ticker=0; 
				circle(buffer,math_x+320,math_y,2,C_Yellow);
			}
		}

	}

	check_for_coins++;

	for(ANT *a=F_Ant.N_Ant;a!=&L_Ant;a=a->N_Ant)
	{
		if( a->X+320-Screen_X >= 320 && a->X+320-Screen_X < 640
			&& a->Y-Screen_Y >= 0 && a->Y-Screen_Y < 240 )
				vline(buffer, a->X+320-Screen_X, a->Y-Screen_Y, a->Y-2-Screen_Y, a->Color);

		if( a->CurrentJob != -3 )
		{
			if( a->CurrentJob == 19 )
			{
				if( a->X > level->w-2 || a->X < 1 || a->Y > level->h-1 ) { a->CurrentJob = -3; play_sample(S_lost,35,128,1000,false); }
			}
			else if( a->CurrentJob == 1 || a->CurrentJob == 10 || a->CurrentJob == 12 )
			{
				if( a->Y > level->h-2 ) { a->CurrentJob = -3; play_sample(S_lost,35,128,1000,false); }
			}
			else
			{
				if( a->X > level->w-2 || a->X < 1 ) { a->CurrentJob = -3; play_sample(S_lost,35,128,1000,false); }
			}
		}

		if( a->Ability[4] )
		{
			if( block_selected != 11 ) a->i5++;

			if( a->i5 < 60 ) { masked_blit(number[4],buffer,0,0,a->X-2+320-Screen_X,a->Y-9-Screen_Y,4,5); }
			else if( a->i5 < 120 ) { masked_blit(number[3],buffer,0,0,a->X-2+320-Screen_X,a->Y-9-Screen_Y,4,5); }
			else if( a->i5 < 180 ) { masked_blit(number[2],buffer,0,0,a->X-2+320-Screen_X,a->Y-9-Screen_Y,4,5); }
			else if( a->i5 < 240 ) { masked_blit(number[1],buffer,0,0,a->X-2+320-Screen_X,a->Y-9-Screen_Y,4,5); }
			else if( a->i5 < 300 ) { masked_blit(number[0],buffer,0,0,a->X-2+320-Screen_X,a->Y-9-Screen_Y,4,5); }
			else
			{
				if( a->i5 > 308 ) { a->Remove(); }
				else { a->CurrentJob = 12; }
			}
		}

		if( block_selected != 11 )
		{
			if( Nukem && rand()%60==0 && !a->Ability[4] ) { a->Ability[4] = true; a->i5=0; }

			a->DoJob();
		}

		if( check_for_coins%2==0 )
		{
			for(COIN *c=F_Coin.N_Coin;c!=&L_Coin;c=c->N_Coin)
			{
				if( c->Color != 0 )
				{
					if( abs(a->X-c->x) + abs(a->Y-c->y) < 4 )
					{
						if(c->Color == C_Red) { JobSlot_Amt[Red_Slot]++; }
						else if(c->Color == C_Green) { JobSlot_Amt[Green_Slot]++; }
						else if(c->Color == C_Blue) { JobSlot_Amt[Blue_Slot]++; }
						play_sample(S_coin,35,128,1000,false);
						c->Color = 0;
						c->Remove();
					}
				}
			}
		}
	}

	if( ANTS_DROPPED < MAX_ANTS && !Nukem )
	{
		if( block_selected != 11 )
		{
			if( Dropper++ > DROP_RATE )
			{
				Dropper = 0;

				ANT *new_ant = new ANT(false);

				new_ant->X = SX[h];
				new_ant->Y = SY[h];
				new_ant->Direction = 1;
				new_ant->CurrentJob = 1;

				if( ++h > (Start_Locations-1) ) h = 0;

				ANTS_DROPPED++;
				ANTS_OUT++;
			}
		}
	}
	else if( ANTS_OUT == 0 ) { GamePlaying = false; }
}

double c_tick;

void Main_Game_Loop()
{
	int speedy = 0;

	clear_bitmap(screen);

	play_sample(S_begin,110,128,1000,false);

	rect(screen,10,80,310,160,65535);
	textprintf_centre(screen,font,160,100,65535,"Save %i out of %i ants!",ANTS_TO_SAVE,MAX_ANTS);
	textprintf_centre(screen,font,160,140,65535,"Press any key to continue.");

	while( key[KEY_ENTER] ) { yield_timeslice(); }

	clear_keybuf();

	readkey();

	clear_keybuf();

	show_mouse(screen);

	while( GamePlaying )
	{
		c_tick = retrace_count;

		acquire_bitmap(buffer);

		blit(pretty_level,buffer,Screen_X,Screen_Y,320,0,320,205);
		Ants_Control();
		Draw_GUI();
		Input_Control();

		show_mouse(NULL);
		blit(buffer,screen,320,0,0,0,320,240);
		show_mouse(screen);

		release_bitmap(buffer);

		if( block_selected == 10 )
		{
			speedy++;
			if(speedy>4)
			{
				speedy=0;
				while( !(retrace_count - c_tick) ) { yield_timeslice(); }
			}
		}
		else
		{
			while( !(retrace_count - c_tick) ) { yield_timeslice(); }
		}
	}

	show_mouse(NULL);

	clear_bitmap(screen);
	rect(screen,10,80,310,160,65535);
	
	if( ANTS_SAVED < ANTS_TO_SAVE )
	{
		textprintf_centre(screen,font,160,100,C_Red,"You needed to save %i more ants!",ANTS_TO_SAVE-ANTS_SAVED);
		textprintf_centre(screen,font,160,140,C_Red,"Press any key to continue.");

		play_sample(S_fail,110,128,650,false);
	}
	else
	{
		textprintf_centre(screen,font,160,100,C_Green,"Great job!");
		textprintf_centre(screen,font,160,140,C_Green,"Press any key to continue.");
		if( level_selected > 0 ) level_selected++;
	}

	while( key[KEY_ENTER] ) { yield_timeslice(); }

	clear_keybuf();

	readkey();

	clear_keybuf();

	Main_Menu();
}

void main()
{
	df.open("debug.log");

	df << "Init Allegro..." << endl;

	allegro_init();

	df << "Installing keyboard..." << endl;

	install_keyboard();
	df << "Installing timer..." << endl;
	install_timer();
	df << "Installing mouse..." << endl;
	install_mouse();

	df << "Setting color depth..." << endl;
	set_color_depth(16);
	df << "Changing graphics mode..." << endl;
	set_gfx_mode(GFX_AUTODETECT,320,240,0,0);
	df << "Setting text mode to -1..." << endl;
	text_mode(-1);

	df << "Installing sound driver..." << endl;
	install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL);

	df << "Loading packfile..." << endl;
	packfile_password("AntsData");
	data = load_datafile("ants.dat");
	packfile_password(NULL);

	df << "Starting the Init_Game() routine..." << endl;
	Init_Game();
	df << "Entering the Main_Menu()..." << endl;
	Main_Menu();
}

END_OF_MAIN();