#include <tanky.h>
//#include "alleg_graphics.h"
//#include <allegro.h>


static int gerror = grOk;
static int fg_color = 15;
static int fill_color = 15;
static int text_justify_h = 0;
static int text_justify_v = 0;
static int text_size = 1;
static FONT *actualfont;

void init_alleg_graphics ()
{
	actualfont = font;
}

void initgraph (int *gdriver, int *gmode, char *str)
{
	if (set_gfx_mode (GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0) {
		set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
		allegro_message ("Unable to set any graphic mode\n%s\n", allegro_error);
		exit (1);
	}
}

int graphresult ()
{
	return gerror;
}

void cleardevice ()
{
	clear_bitmap (screen);
}

void closegraph ()
{
	set_gfx_mode (GFX_TEXT, 80, 25, 0, 0);
}

void cputpixel (int x, int y, int color)
{
	putpixel (screen, x, y, color);
}

int cgetpixel (int x, int y)
{
	return getpixel (screen, x, y);
}

void cputimage (int x, int y, BITMAP * data, int mode)
{
	blit (data, screen, 0, 0, x, y, data->w, data->h);
}

void csetcolor (int color)
{
	fg_color = color;
}

void cline (int x1, int y1, int x2, int y2)
{
	line (screen, x1, y1, x2, y2, fg_color);
}

void csetfillstyle (int style, int color)
{
	fill_color = color;
}

void cbar (int x1, int y1, int x2, int y2)
{
	rectfill (screen, x1, y1, x2, y2, fill_color);
}

void crectangle (int x1, int y1, int x2, int y2)
{
	rect (screen, x1, y1, x2, y2, fg_color);
}

void csetwritemode (int mode)
{
	if (mode == 1)
		xor_mode (TRUE);
	else
		xor_mode (FALSE);
}

void csettextjustify (int horiz, int vert)
{
	text_justify_h = horiz;
	text_justify_v = vert;
}

void csettextstyle (int font_id, int direction, int charsize)
{
	if (font_id == 1)
		actualfont = fontik_system;
	else
		actualfont = font;

	if (charsize <= 1)
		text_size = 1;
	else
		text_size = 2;
}

void couttextxy (int x, int y, const char *text)
{
	BITMAP *aux;
	int h = text_height (actualfont);
	int w;
	int yy, xx;

	if (text_justify_v == TOP_TEXT)
		yy = y;
	else if (text_justify_v == BOTTOM_TEXT)
		yy = y - h * text_size;
	else
		yy = y - h * text_size /2;

	w = text_length (actualfont, text);
	aux = create_bitmap (w, h);
	clear_bitmap(aux);

	textout (aux, actualfont, text, 0, 0, fg_color);
	//rect(aux,0,0,w-1,h-1,14);

	if (text_justify_h == CENTER_TEXT)
		xx = x - w * text_size /2;
	else if (text_justify_h == RIGHT_TEXT)
		xx = x - w * text_size;
	else
		xx = x;
	
	//printf(" x=%d  y=%d\n xx=%d  yy=%d \n h=%d  w=%d  size=%d\n",x,y,xx,yy,h,w,text_size);
	stretch_sprite (screen, aux, xx, yy, w * text_size, h * text_size);

	destroy_bitmap (aux);
}
