#include "tanky.h"
#include <stdarg.h>

#define MAX_LINES 50
#define MAX_COLUMNS 80
#define MAX_CHARACTERS (MAX_COLUMNS * MAX_LINES)

int text_lines = 25;
int text_columns = MAX_COLUMNS;
int textx, texty;
int text_attr = 7;
unsigned char attr_table[MAX_CHARACTERS];
unsigned char char_table[MAX_CHARACTERS];
int blink_on = 1;
int blink_count = 0;




static void putch_helper (int x, int y, unsigned char c)
{
	int attr = attr_table[x + y * text_columns];
	int fg = attr & 0x0f;
	int bg = (attr & 0x70) >> 4;
	int px = (x - 1) << 3, py = (y - 1) << 4;

	unsigned char str[2] = " ";

	str[0] = c;
	if (c < 32)
		str[0] = 32;

	rectfill (screen, px, py, px + 8, py + 15, bg);
	if (attr < 128)
		textout (screen, fontik_system, str, px, py, fg);
	else if (blink_on)
		textout (screen, fontik_system, str, px, py, fg);

}


void do_blink ()
{
	int i;

	blink_count++;
	if (blink_count >= 5) {
		blink_count=0;
		blink_on = 1 - blink_on;
		for (i = 0; i < text_columns * text_lines; i++) {
			if (attr_table[i] >= 128) {
				putch_helper (i % text_columns, i / text_columns, char_table[i]);
			}
		}
	}
}

void gotoxy (int x, int y)
{
	textx = x;
	texty = y;

}

void cprintf (const char *template, ...)
{
	unsigned char str[1000];
	int i;
	va_list ap;

	va_start (ap, template);
	vsprintf (str, template, ap);
	va_end (ap);


	i = 0;
	while (str[i] != 0) {
		putch (str[i]);
		i++;
	}
	//rectfill (screen, x, y, x + strlen (str) * 9 - 1, y + 15, bg);
	//textout (screen, fontik_system, str, x, y, fg);

}

int kbhit ()
{
	return keypressed ();
}

int getch ()
{
	return (readkey () & 0xff);
}


int crandom (int maxint)
{
	return rand () % maxint;
}


void textattr (int attr)
{
	text_attr = attr;
}

void textcolor (int color)
{
	text_attr = color;
}

void clrscr ()
{
	int i;

	clear_bitmap (screen);
	for (i = 0; i < MAX_CHARACTERS; i++)
		attr_table[i] = 7;
		char_table[i] = ' ';
}


void putch (unsigned char c)
{

	if(c=='\n') {
		textx=1;
		texty++;
		if (texty > text_lines)
			texty = text_lines;
		return;
	}
	
	attr_table[textx + texty * text_columns] = text_attr;
	char_table[textx + texty * text_columns] = c;
	putch_helper (textx, texty, c);

	textx++;
	if (textx > MAX_COLUMNS) {
		textx = 1;
		texty++;
		if (texty > text_lines)
			texty = text_lines;
	}
}


void textmode (int lines)
{
	if (lines > 50)
		lines = 50;
	if (lines < 1)
		lines = 1;
	text_lines = lines;
	clrscr();
}


void csound (int freq)
{
	play_sample(sample1000Hz, 250, 128, freq, 1);
}

void cnosound ()
{
	stop_sample(sample1000Hz);
}

void cdelay (int milliseconds)
{
	rest(milliseconds);
}

void crandomize ()
{
	srand (time (0));
}
