//file: object.h//////////////////////////////////////////////////////////////

//Includes////////////////////////////////////////////////////////////////////
#ifndef PPCOL_H
  #include "ppcol.h"
#endif

//Defines/////////////////////////////////////////////////////////////////////
#ifndef OBJECT_H
  #define OBJECT_H
#endif

//Classes/////////////////////////////////////////////////////////////////////

//Base PROJECTILE class
class PROJECTILE
{
  friend class BOWL_GAME_LOOP;

  protected:
    float x, y, dx, dy, draw_ang;
    int sprite;
    bool enabled;

  public:
    //for pixel perfect collision
    BIT_MASK *mask;

    void draw(float mx, float my);
    bool is_enabled();
};

class BOWLING_BALL : public PROJECTILE
{
  private:
    static const float SPEED = 5.0;
    bool guttered;
    int pins_knocked;

  public:
    BOWLING_BALL();
    ~BOWLING_BALL();
    void release(float x, float y, float ang);
    void processing();
    void snap_my(float &my);
    void get_dynamics(float &x, float &y, float &dx, float &dz);
    void hit_pin();
    void reset_pins_knocked();
    int get_pins_knocked();
    bool down_lane();
};

class BOWLING_PIN : public PROJECTILE
{
  private:
    float d_rot;

  public:
    BOWLING_PIN();
    ~BOWLING_PIN();
    void place(float x, float y);
    void processing();
    void knock(BOWLING_BALL &hitter);
    void knock(BOWLING_PIN &hitter);
};
