//File: object.cpp///////////////////////////////////////////////////////////

//Includes///////////////////////////////////////////////////////////////////
#include <iostream.h>
#include <allegro.h>
#include <math.h>
#include <fblend.h>
#include "main.h"
#include "object.h"
#include "game.h"
#include "bowlingdat.h"

//Useful macro(s)/////////////////////////////////////////////////////////////
#define RAD(n)    (n*(M_PI/180.0))

//PROJECTILE class functions//////////////////////////////////////////////////
void PROJECTILE::draw(float mx, float my)
{
  if(draw_ang != 0)
    rotate_sprite(buffer, PIC(sprite), ROUND(mx+x), ROUND(my+y), ftofix(draw_ang));
  else
    draw_sprite(buffer, PIC(sprite), ROUND(mx+x), ROUND(my+y));
}

bool PROJECTILE::is_enabled()
{
  return enabled;
}

//BOWLING_BALL functions//////////////////////////////////////////////////////
BOWLING_BALL::BOWLING_BALL()
{
  sprite = blue_ball_a;
  enabled = FALSE;
  draw_ang = 0;
  
  mask = new BIT_MASK(PIC(blue_ball_a));
}

BOWLING_BALL::~BOWLING_BALL()
{
  delete mask;
}

void BOWLING_BALL::release(float x, float y, float ang)
{
  //angle coming in is a binary allegro angle, convert
  //to degrees then radians
  ang /= (256.0/360.0);
  ang = RAD(ang);

  //store X and Y components of incoming vector
  dx = sin(ang)*SPEED;
  dy = -cos(ang)*SPEED;
  
  //Position
  this->x = x-1;
  this->y = y-1;

  enabled = TRUE;
}

void BOWLING_BALL::processing()
{
  int interval = 5;

  x += dx;
  y += dy;

  //gutter balls
  if(x+PIC(sprite)->w-4 < BOWL_GAME_LOOP::lane_left ||
     x > BOWL_GAME_LOOP::lane_right)
  {
    dx = 0;
    guttered = TRUE;
  }
  
  if(sprite == blue_ball_d)
    interval = 15;

  //animation
  if(fpscounter % interval == 0)
  {
    sprite++;

    if(sprite > blue_ball_d)
      sprite = blue_ball_a;
  }
}

void BOWLING_BALL::snap_my(float &my)
{
  if(my+y < 120)
    my = -y+120;
    
  if(my > 0)
    my = 0;
}

void BOWLING_BALL::get_dynamics(float &x, float &y, float &dx, float &dz)
{
  x = this->x;
  y = this->y;
  dx = this->dx;
  dy = this->dy;
}

void BOWLING_BALL::hit_pin()
{
  pins_knocked++;
}

void BOWLING_BALL::reset_pins_knocked()
{
  pins_knocked = 0;
}

int BOWLING_BALL::get_pins_knocked()
{
  return pins_knocked;
}

bool BOWLING_BALL::down_lane()
{
  return (y < -500);
}

//BOWLING_PIN functions///////////////////////////////////////////////////////
BOWLING_PIN::BOWLING_PIN()
{
  sprite = pin_up;
  enabled = FALSE;
  draw_ang = 0;
  d_rot = -5+(random()%5)+1;
  if(d_rot < 0)
    d_rot -= 2;
  else
    d_rot += 2;

  mask = new BIT_MASK(PIC(pin_up));
}

BOWLING_PIN::~BOWLING_PIN()
{
  delete mask;
}

void BOWLING_PIN::place(float x, float y)
{
  this->x = x;
  this->y = y;
  enabled = TRUE;
  draw_ang = 0;
}

void BOWLING_PIN::processing()
{
  x += dx;
  y += dy;

  //rotate like crazy afer being hit
  draw_ang += d_rot;
}

void BOWLING_PIN::knock(BOWLING_BALL &hitter)
{
  float hit_x, hit_y, hit_dx, hit_dy, dx2, dy2, dummy_z = 0;

  enabled = FALSE;

  hitter.get_dynamics(hit_x, hit_y, hit_dx, hit_dy);

  //direction of pin
  dx = hit_dx/2;
  dy = hit_dy/2;

  //difference between two objects
  dx2 = x-hit_x;
  dy2 = y-hit_y;

  //One day I'll learn how to do this routine myself
  normalize_vector_f(&dx2, &dy2, &dummy_z);

  dx += dx2*2.5;
  dy += dy2*2.5;
}

//pin version of knock
void BOWLING_PIN::knock(BOWLING_PIN &hitter)
{
  float hit_dx = hitter.dx, hit_dy = hitter.dy;
//  float dx2, dy2, dummy_z = 0, hit_x = hitter.x, hit_y = hitter.y;

  //bad idea
  if(this == &hitter)
    return;

  enabled = FALSE;

  //direction of pin
  dx = hit_dx;
  dy = hit_dy;

  //Relative stuff below causes easy strikes...

  //difference between two objects
/*  dx2 = x-hit_x;
  dy2 = y-hit_y;

  //One day I'll learn how to do this routine myself
  normalize_vector_f(&dx2, &dy2, &dummy_z);

  dx += dx2*2.5;
  dy += dy2*2.5;*/
}
