//File: menu.cpp//////////////////////////////////////////////////////////////
//Menu and title stuff
//(Menu routines based on menu code from LightSword Wartimes)

//Includes///////////////////////////////////////////////////////////////////
#include <iostream.h>
#include <math.h>
#include <ctype.h>
#include <allegro.h>
#include <fblend.h>
#include "main.h"
#include "game.h"
#include "title.h"
#include "menu.h"
#include "bowlingdat.h"

//Globals////////////////////////////////////////////////////////////////////
char title_go = TRUE;
float menu_cosine;
int menu_a;

//BOWL_MENU functions//////////////////////////////////////////////////////////
BOWL_MENU::BOWL_MENU(BOWL_GAME_LOOP *game)
{
  this->game = game;
}

void BOWL_MENU::init()
{
  fps = fpscounter = 0;

  //main menu
  choices[0][MENU_START] = new MENU_CHOICE("Start Game", 160, 120, TRUE);
  choices[0][MENU_QUIT] = new MENU_CHOICE("Quit", 160, 140, TRUE);
  choices[0][2] = NULL;

  //new player menu
  choices[1][PLAYER_MENU_NAME] = new MENU_CHOICE_EDIT("Name: ", 80, 120);
  choices[1][PLAYER_MENU_CHAR] = new MENU_CHOICE("Character: ", 80, 140);
  choices[1][PLAYER_MENU_CHAR]->set_image_array(character_sprites, 0);
  choices[1][PLAYER_MENU_NEXT] = new MENU_CHOICE("Next player", 80, 160);
  choices[1][PLAYER_MENU_BACK] = new MENU_CHOICE("Back", 80, 180);
  choices[1][PLAYER_MENU_DONE] = new MENU_CHOICE("Done (Start)", 80, 200);
  choices[1][5] = NULL;


  //init the class by setting the main menu
  set_menu(0);
}

void BOWL_MENU::shutdown()
{
  int i, j;

  for(i = 0; i < 2; i++)
  {
    for(j = 0; choices[i][j]; j++)
    {
      delete choices[i][j];
    }
  }
}

void BOWL_MENU::set_menu(int pos)
{
  int i;

  menu_pos = pos;

  cursor_pos = counter = 0;
  cursor_max = -1;
  for(i = 0; choices[menu_pos][i]; i++)
  {
    cursor_max++;
    choices[menu_pos][i]->reset();
  }
  clear_keybuf();

  //initial dimensions
  x = 160;
  y = 160;
  w = h = 0;

  //initial cursor position
  cursor_y = choices[menu_pos][0]->get_y();

  //dynamic settings
  if(menu_pos == 1)
  {
    int id = -1, num_taken = 0, i;

    //Reset edit box for name
    ((MENU_CHOICE_EDIT *)choices[1][PLAYER_MENU_NAME])->set_text("Name: ");

    for(i = 0; i < MAX_CHARACTER_SPRITES; i++)
    {
      if(game->character_taken(character_sprites[i]))
        num_taken++;
      else if(id == -1)
        id = i;
    }

    //don't allow adding of any more characters past max
    if(num_taken == MAX_CHARACTER_SPRITES-1)
      choices[1][PLAYER_MENU_NEXT]->disable();
    else
      choices[1][PLAYER_MENU_NEXT]->enable();

    choices[1][PLAYER_MENU_CHAR]->set_image_array(character_sprites, id);
  }
}

int BOWL_MENU::run(TITLE_SCREEN &parent)
{
  init();

  go = TRUE;
  quit = FALSE;

  while(!quit)
  {
    input();
    processing();
    if(fpscounter >= fps)
    {
      acquire_bitmap(buffer);
      parent.draw_screen(TRUE);
      draw();
      release_bitmap(buffer);
      blit_buffer();
    }
    while(fpscounter > fps) ;
  }

  shutdown();
  return go;
}

void BOWL_MENU::input()
{
//  test_window_toggle();

  if(keypressed())
  {
    int k = readkey();

    switch(k >> 8)
    {
      case KEY_UP:
        cursor_pos--;
        if(cursor_pos < 0)
          cursor_pos = cursor_max;
      break;
      case KEY_DOWN:
        cursor_pos++;
        if(cursor_pos > cursor_max)
          cursor_pos = 0;
      break;
      case KEY_ESC:
        if(menu_pos == 0)
          cursor_pos = MENU_QUIT;
        else if(menu_pos == 1)
          cursor_pos = PLAYER_MENU_BACK;
      break;
      case KEY_LEFT:
        if(menu_pos == 1)
          toggle_option(cursor_pos, -1);
      break;
      case KEY_RIGHT:
        if(menu_pos == 1)
          toggle_option(cursor_pos, 1);
      break;
      case KEY_ENTER:
        if(choices[menu_pos][cursor_pos]->is_enabled())
        {
          switch(menu_pos)
          {
            case 0:
              if(cursor_pos == MENU_START)
                go = 1;
              else if(cursor_pos == MENU_QUIT)
                go = -2;
            break;
            case 1:
              if(cursor_pos == PLAYER_MENU_BACK)
              {
                //delete last character if necessary,
                //quit to main screen if none are left
                if(!game->delete_last_player())
                  go = 0;
                else
                  go = 1;
              }
              else if(cursor_pos == PLAYER_MENU_NEXT || cursor_pos == PLAYER_MENU_DONE)
              {
                int char_id = choices[1][PLAYER_MENU_CHAR]->get_image();

                if(cursor_pos == PLAYER_MENU_DONE && game->get_num_players() == 0)
                {
                  bowl_warning("Cannot start game with under 2 players!");
                  break;
                }

                //disallow re-use of characters
                if(game->character_taken(char_id))
                  bowl_warning("That character is already taken!!");
                //disallow empty names
                else if((((MENU_CHOICE_EDIT *)choices[1][PLAYER_MENU_NAME])->get_text())[0] == 0)
                  bowl_warning("Your name cannot be empty!!");
                //add a new character
                else
                {
                  USER_DATA settings(char_id, ((MENU_CHOICE_EDIT *)choices[1][PLAYER_MENU_NAME])->get_text());
                  
                  if(!game->add_player(settings))
                    bowl_warning("Maximum players reached!!");
                  else
                    go = (cursor_pos == PLAYER_MENU_NEXT) ? 1 : -3;
                }
              }
            break;
          }
        }
      break;
      default:
        //handle any known editable "choices"
        if(menu_pos == 1 && cursor_pos == PLAYER_MENU_NAME)
          ((MENU_CHOICE_EDIT *)choices[1][PLAYER_MENU_NAME])->type(k);

      break;
    }
    clear_keybuf();
  }
}

void BOWL_MENU::processing()
{
  int i, dest_cursor_y = choices[menu_pos][cursor_pos]->get_y();

  //timers
  fpscounter++;
  counter++;

  //dimension changing
  if(counter < 60)
  {
    x -= 2.0;
    w += 4.0;
    y -= 1.0;
    h += 2.0;
  }

  if(go != TRUE)
  {
    x += 4.0;
    y += 2.0;
    w -= 8.0;
    h -= 4.0;

    if((int)(w) <= 0 || (int)(h) <= 0)
    {
      if(go != -2 && go != -3)
      {
        set_menu(go);
        go = TRUE;
      }
      else
        quit = TRUE;
    }
  }

  //choices
  if(counter > 10)
  {
    for(i = 0; choices[menu_pos][i]; i++)
    {
      if(choices[menu_pos][i]->finished())
        continue;

      choices[menu_pos][i]->processing();

      break;
    }
  }

  //cursor movement
  if(ABS(cursor_y-dest_cursor_y) <= 8)
    cursor_y = dest_cursor_y;
  else if(cursor_y < dest_cursor_y)
    cursor_y += 4;
  else if(cursor_y > dest_cursor_y)
    cursor_y -= 4;

  //music
  //forget music for now..
//  if(music && dumb_player)
//    al_poll_duh(dumb_player);
}

void BOWL_MENU::draw()
{
  int i;
  const int cursor_w = MAX(choices[menu_pos][cursor_pos]->x-80, 45);

  rect(buffer, ROUND(x), ROUND(y), ROUND(x+w), ROUND(y+h), makecol(100, 0, 0));
  fblend_rect_trans(buffer, ROUND(x)+1, ROUND(y)+1, ROUND(w)-1, ROUND(h)-1, makecol(0, 0, 255), 128);

  set_clip(buffer, ROUND(x)+1, ROUND(y)+1, ROUND(x+w)-1, ROUND(y+h)-1);
  for(i = 0; choices[menu_pos][i]; i++)
    choices[menu_pos][i]->draw((i == cursor_pos));

  rotate_sprite(buffer, PIC(menu_cursor), cursor_w, cursor_y-5, itofix(counter*4));
  set_clip(buffer, 0, 0, 320, 240);
}

void BOWL_MENU::toggle_option(int id, int direction)
{
  switch(id)
  {
    case PLAYER_MENU_CHAR:
      choices[1][PLAYER_MENU_CHAR]->toggle_image(direction, MAX_CHARACTER_SPRITES-1);
    break;
  }
}

//MENU_CHOICE functions///////////////////////////////////////////////////////
MENU_CHOICE::MENU_CHOICE(char *label, int x, int y, bool centered)
{
  this->label = label;
  this->x = x;
  this->y = y;
  this->centered = centered;
  label_length = strlen(label);
  image_id = -1;
  images = NULL;
  enabled = TRUE;

  reset();

  label_a = new int[label_length];
}

MENU_CHOICE::MENU_CHOICE()
{

}

MENU_CHOICE::~MENU_CHOICE()
{
  delete []label_a;
}

void MENU_CHOICE::processing()
{
  counter++;

  if(counter % 3 == 0 && label_pos < label_length)
  {
    label_buf[label_pos] = label[label_pos];
    label_pos++;
    label_buf[label_pos] = 0;
  }
}

void MENU_CHOICE::reset()
{
  label_pos = 0;
  label_buf[0] = 0;
  counter = 0;
}

void MENU_CHOICE::set_label(const char *label)
{
  this->label = (char *)label;
  label_length = strlen(label);

  delete []label_a;
  label_a = new int[label_length];
  reset();
}

void MENU_CHOICE::set_image_array(const int *images, int id)
{
  this->images = images;
  image_id = id;
}

void MENU_CHOICE::toggle_image(int direction, int max)
{
  image_id += direction;

  if(image_id > max)
    image_id = 0;
  if(image_id < 0)
    image_id = max;
}

int MENU_CHOICE::get_image()
{
  return (images) ? images[image_id] : image_id;
}

void MENU_CHOICE::draw(bool lighted, int force_color)
{
  int color = makecol(255, 255, 255);

  if(!enabled)
    force_color = makecol(120, 120, 120);

  if(lighted)
  {
    float r = 200+sin((float)fpscounter*6*(M_PI/180.0))*32;

    color = makecol(ROUND(r), 0, 0);
  }

  if(force_color != -1)
    color = force_color;

  if(centered)
  {
    textout_centre(buffer, font, label_buf, x+1, y+1, 0);
    textout_centre(buffer, font, label_buf, x, y, color);
  }
  else
  {
    textout(buffer, font, label_buf, x+1, y+1, 0);
    textout(buffer, font, label_buf, x, y, color);
  }

  //sprite image to draw on right of label
  if(image_id != -1)
  {
    const int spr_x = x+text_length(font, label)+10,
              spr_y = y+text_height(font)/2-PIC(images[image_id])->h/2;

    if(images)
      draw_sprite(buffer, PIC(images[image_id]), spr_x, spr_y);
    else
      draw_sprite(buffer, PIC(image_id), spr_x, spr_y);
  }
}

void MENU_CHOICE::enable()
{
  enabled = TRUE;
}

void MENU_CHOICE::disable()
{
  enabled = FALSE;
}

int MENU_CHOICE::get_y()
{
  return y;
}

bool MENU_CHOICE::finished()
{
  return (label_pos >= label_length);
}

bool MENU_CHOICE::is_enabled()
{
  return enabled;
}

//Derived MENU_CHOICE_EDIT functions//////////////////////////////////////////
MENU_CHOICE_EDIT::MENU_CHOICE_EDIT(char *label, int x, int y, bool centered)
{
  this->label = buf;
  this->x = x;
  this->y = y;
  this->centered = centered;
  image_id = -1;
  enabled = TRUE;
  set_text(label);

  reset();

  label_a = new int[label_length];
}


void MENU_CHOICE_EDIT::type(int k)
{
  if(k >> 8 == KEY_BACKSPACE && pos > min_pos)
  {
    pos--;
    buf[pos] = 0;
  }

  if(isprint(k & 0xFF) && pos-min_pos < bowling_game::BG_NAME_MAX-1)
  {
    buf[pos] = k & 0xFF;
    pos++;
    label_length++;
    buf[pos] = 0;
  }

  //Funny conversions
  if(strcasecmp(buf+min_pos, "Seamus") == 0)
    strcpy(buf, "Name: Shamus");

  strcpy(label_buf, buf);
}

void MENU_CHOICE_EDIT::set_text(char *text)
{
  strcpy(buf, text);
  label_length = min_pos = strlen(label);
  pos = min_pos;
}

const char *MENU_CHOICE_EDIT::get_text()
{
  return buf+min_pos;
}
