//File: title.cpp////////////////////////////////////////////////////////////

//Includes////////////////////////////////////////////////////////////////////
#include <allegro.h>
#include <fblend.h>
#include "main.h"
#include "game.h"
#include "title.h"
#include "bowlingdat.h"
#include "menu.h"

//Title functions/////////////////////////////////////////////////////////////
TITLE_SCREEN::TITLE_SCREEN(BOWL_GAME_LOOP *game)
{
  this->game = game;
}

void TITLE_SCREEN::processing()
{
  //timer stuff
  fpscounter++;

  //effects
  if(fpscounter >= 60)
  {
    if(split_distance > 0)
    {
      split_distance -= 5;

      if(split_distance < 0)
        split_distance = 0;
    }
  }

  if(split_distance == 0)
  {
    if(title_h < scratch->h)
    {
      title_h += d_title_h;
      d_title_h *= 1.1;

      if(title_h > scratch->h)
        title_h = scratch->h;
    }
    else
    {
      BOWL_MENU menu(game);
      int ret = menu.run(*this);

      if(ret == -2)
        status = QUIT;
      else if(ret == -3)
        status = START;
    }
  }
}

void TITLE_SCREEN::draw_screen(bool no_blit)
{
  //for DirectX port
  if(!no_blit)
    acquire_bitmap(buffer);

  //title screen background
  if(split_distance)
  {
    //backdrop
    clear(buffer);
    blit(PIC(ls_logo), buffer, 0, 0, 160-PIC(ls_logo)->w/2, 120-PIC(ls_logo)->h/2, PIC(ls_logo)->w, PIC(ls_logo)->h);

    //both halves of title background
    blit(PIC(title_background), buffer, 0, 0, -split_distance, 0, 160, 240);
    blit(PIC(title_background), buffer, 160, 0, 160+split_distance, 0, 160, 240);
  }
  else
    blit(PIC(title_background), buffer, 0, 0, 0, 0, 320, 240);

  if(title_h)
  {
    //draw stretched sprite onto scratchpad surface
    if(title_h < scratch->h)
    {
      clear_to_color(scratch, makecol(255, 0, 255));
      stretch_sprite(scratch, PIC(title_words), 0, scratch->h/2-ROUND(title_h)/2, scratch->w, ROUND(title_h));
    }
    else
      blit(PIC(title_words), scratch, 0, 0, 0, 0, scratch->w, scratch->h);

    //New title effect is better
    draw_sprite(buffer, scratch, 0, 0);

    //use adding effect on final rendering
    //fblend_trans(scratch, buffer, 160-scratch->w/2, 20, 192);
  }

  if(!no_blit)
  {
    //more DirectX stuff
    release_bitmap(buffer);

    //Update screen
    blit_buffer();
  }
}

int TITLE_SCREEN::run_loop()
{
  //allocation
  scratch = create_bitmap(PIC(title_words)->w, PIC(title_words)->h);
  if(!scratch)
    quit_error();

  //defaults
  status = RUN;
  fps = fpscounter = 0;
  split_distance = 160;
  title_h = 0.0;
  d_title_h = 0.1;

  //loop
  while(status == RUN)
  {
    processing();
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }

  //deallocation
  destroy_bitmap(scratch);

  return status;
}
