/////////////////////////////////////////////////////////////////////
//Setup.cpp - A simple little setup program for LightSword Bowling //
/////////////////////////////////////////////////////////////////////
//Really cheap program, planning to replace with gtk for linux     //
//and win32 for windows                                            //
/////////////////////////////////////////////////////////////////////

//Includes////////////////////////////////////////////////////////////////////
#include <allegro.h>
#include "options.h"

//Global consts///////////////////////////////////////////////////////////////
const int CANCEL = 2, OK = 1;

void setup_fail(char *err = "Out of memory!")
{
  allegro_message(err);
  allegro_exit();
  exit(1);
}

int main()
{
  int k;

  allegro_init();
  install_keyboard();
  set_color_depth(16);
  if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 320, 240, 0, 0) != 0)
  {
    if(set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0) != 0)
      setup_fail("Can't set video mode!\nYou can still change settings by manually editing lsbowl.cfg..\n\n");
  }

  set_window_title("LightSword Bowling Setup");
  text_mode(-1);

  clear_to_color(screen, makecol(212, 208, 200));
  textout(screen, font, "Using the keyboard....", 5, 5, 0);
  textout(screen, font, "Select a video type: ", 5, 110, 0);
  textout(screen, font, "[A]utodetect", 5, 140, 0);
  textout(screen, font, "[F]ullscreen", 5, 150, 0);
  textout(screen, font, "[W]indow", 5, 160, 0);
  textout(screen, font, "[D]ouble-sized window", 5, 170, 0);
  clear_keybuf();
  k = readkey() >> 8;
  if(k == KEY_F)
    options.video_type = BOWL_OPTIONS::FULLSCREEN;
  else if(k == KEY_W)
    options.video_type = BOWL_OPTIONS::NS_WINDOWED;
  else if(k == KEY_D)
    options.video_type = BOWL_OPTIONS::DS_WINDOWED;
  else
    options.video_type = BOWL_OPTIONS::DONTCARE;

  clear_to_color(screen, makecol(212, 208, 200));
  textout(screen, font, "Force double resolution?: ", 5, 110, 0);
  textout(screen, font, "(Say Y if you experience video problems)", 5, 120, 0);
  textout(screen, font, "[Y]es", 5, 140, 0);
  textout(screen, font, "[N]o", 5, 150, 0);
  clear_keybuf();
  k = readkey() >> 8;
  options.force_double_res = (k == KEY_Y);

  clear_to_color(screen, makecol(212, 208, 200));
  textout(screen, font, "Turn on harder aiming?", 5, 110, 0);
  textout(screen, font, "(good if game is too easy)", 5, 120, 0);
  textout(screen, font, "[Y]es", 5, 140, 0);
  textout(screen, font, "[N]o", 5, 150, 0);
  clear_keybuf();
  k = readkey() >> 8;
  options.hard_aiming = (k == KEY_Y);


  options.save_config();

  allegro_exit();
  return 0;
}
END_OF_MAIN();