//File: ppcol.h//////////////////////////////////////////////////////////////

//Defines////////////////////////////////////////////////////////////////////
#define T_PLANE_SIZE         512
#ifndef PPCOL_H
  #define PPCOL_H
#endif

//Classes////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//This is a bit mask class which stores if a pixel of a sprite is       //
//transparent or not, and can be used to determine collision between    //
//two masks                                                             //
//////////////////////////////////////////////////////////////////////////

class BIT_MASK
{
  private:
    unsigned char **data, //Mask data
                  test_plane[T_PLANE_SIZE][T_PLANE_SIZE];   //Collision testing plane
    short w, h;

  public:
    BIT_MASK(BITMAP *bmp);
    ~BIT_MASK();
    bool collide(int x1, int y1, BIT_MASK *mask, int x2, int y2, bool h_flip1=FALSE, bool hflip_2=FALSE);
    void draw(BITMAP *dest, int x, int y, int c);
};
