////////////////////////////////////////////////////
//Ppcol.cpp - Pixel perfect collision routines    //
////////////////////////////////////////////////////

//Includes///////////////////////////////////////////////////////////////////
#include <string.h>
#include <allegro.h>
#include "ppcol.h"

//BIT_MASK class functions///////////////////////////////////////////////////

BIT_MASK::BIT_MASK(BITMAP *bmp)
{
  int i, j;

  w = bmp->w;
  h = bmp->h;

  //Allocate enough memory for the mask
  data = new (unsigned char *)[w];

  for(i = 0; i < w; i++)
    data[i] = new (unsigned char)[h];

  //Create the mask from the bitmap
  for(j = 0; j < h; j++) for(i = 0; i < w; i++)
  {
    if((unsigned short)((((short *)bmp->line[j])[i])) ==
       (unsigned short)makecol16(255, 0, 255))
    {
      data[i][j] = 0;
    }
    else
      data[i][j] = 1;
  }
}

BIT_MASK::~BIT_MASK()
{
  int i;

  //Free up all the memory
  for(i = 0; i < w; i++)
    delete data[i];
  delete []data;
}

bool BIT_MASK::collide(int x1, int y1, BIT_MASK *mask, int x2, int y2, bool h_flip1,
                       bool h_flip2)
{
  int x, y;

  //Test for bounding box collision first, to see
  //if pixel-perfect is even necessary
  if(((x1 > (x2+mask->w)) || (x2 > (x1+w)) ||
      (y1 > (y2+mask->h)) || (y2 > (y1+h))))
    return FALSE;

  //Make sure testing plane is zerod out
  memset(test_plane, 0, T_PLANE_SIZE*T_PLANE_SIZE);

  //Make the coordinates relative to each other
  const int min_x = MIN(x1, x2),
            min_y = MIN(y1, y2);
  x1 -= min_x;
  y1 -= min_y;
  x2 -= min_x;
  y2 -= min_y;

  //Throw it all on the plane, and test for overlapping
  //in the second loop
  for(y = 0; y < h; y++) for(x = 0; x < w; x++)
  {
    if(h_flip1)
      test_plane[x+x1][y+y1] += data[(w-1)-x][y];
    else
      test_plane[x+x1][y+y1] += data[x][y];
  }
  for(y = 0; y < mask->h; y++) for(x = 0; x < mask->w; x++)
  {
    if(h_flip2)
      test_plane[x+x2][y+y2] += mask->data[(mask->w-1)-x][y];
    else
      test_plane[x+x2][y+y2] += mask->data[x][y];

    if(test_plane[x+x2][y+y2] == 2)
      return TRUE;
  }

  return FALSE;
}

void BIT_MASK::draw(BITMAP *dest, int x, int y, int c)
{
  int i, j;

  for(i = x; i < x+w; i++) for(j = y; j < y+h; j++) if(data[i-x][j-y])
    putpixel(dest, i, j, c);
}
