//Includes////////////////////////////////////////////////////////////////////
#include <allegro.h>
#include "options.h"

//Globals/////////////////////////////////////////////////////////////////////
BOWL_OPTIONS options;

//BOWL_OPTIONS class//////////////////////////////////////////////////////////
BOWL_OPTIONS::BOWL_OPTIONS()
{
  //defaults (aren't really used unless object declared and not read)
  video_type = DONTCARE;
  force_double_res = FALSE;
  hard_aiming = FALSE;
}

void BOWL_OPTIONS::read_config()
{
  set_config_file("lsbowl.cfg");

  video_type = get_config_int("options", "video_type", DONTCARE);
  force_double_res = (bool)get_config_int("options", "force_double_res", FALSE);
  hard_aiming = (bool)get_config_int("options", "hard_aiming", FALSE);
}

void BOWL_OPTIONS::save_config()
{
  set_config_file("lsbowl.cfg");

  set_config_int("options", "video_type", video_type);
  set_config_int("options", "force_double_res", (int)force_double_res);
  set_config_int("options", "hard_aiming", (int)hard_aiming);
}

void BOWL_OPTIONS::get_video_params(int &driver, int &w, int &h)
{
  if(force_double_res || video_type == DS_WINDOWED)
  {
    w = 640;
    h = 480;
  }
  else
  {
    w = 320;
    h = 240;
  }

  switch(video_type)
  {
    case NS_WINDOWED:
    case DS_WINDOWED:
      driver = GFX_AUTODETECT_WINDOWED;
    break;
    case FULLSCREEN:
      driver = GFX_AUTODETECT_FULLSCREEN;
    break;
    case DONTCARE:
      driver = GFX_AUTODETECT;
    break;
  }
}

