//File: menu.h////////////////////////////////////////////////////////////////

//Includes////////////////////////////////////////////////////////////////////
#ifndef BOWLING_GAME_H
  #include "bowlinggame.h"
#endif

//Defines////////////////////////////////////////////////////////////////////
#define MENU_START          0
#define MENU_QUIT           1

#define PLAYER_MENU_NAME    0
#define PLAYER_MENU_CHAR    1
#define PLAYER_MENU_NEXT    2
#define PLAYER_MENU_BACK    3
#define PLAYER_MENU_DONE    4

#define MAX_MENU_CHOICES    8

//Classes/////////////////////////////////////////////////////////////////////
class MENU_CHOICE
{
  friend class BOWL_MENU;

  protected:
    char *label, label_buf[128];
    int x, y, label_length, label_pos, *label_a, counter,
        image_id;
    const int *images;
    bool centered, enabled;

    MENU_CHOICE();

  public:
    MENU_CHOICE(char *label, int x, int y, bool centered=FALSE);
    ~MENU_CHOICE();
    void draw(bool lighted, int force_color=-1);
    void processing();
    void reset();
    void set_label(const char *label);
    void set_image_array(const int *images, int id);
    void toggle_image(int direction, int max);
    void disable();
    void enable();
    int get_image();
    int get_y();
    bool finished();
    bool is_enabled();
};

class MENU_CHOICE_EDIT : public MENU_CHOICE
{
  private:
    char buf[128];
    int pos, min_pos;

  public:
    MENU_CHOICE_EDIT(char *label, int x, int y, bool centered=FALSE);
    void type(int k);
    void set_text(char *text);
    const char *get_text();
};

class BOWL_MENU
{
  private:
    int cursor_pos, cursor_max, menu_pos, counter, cursor_y, run_count,
        go;
    float x, y, w, h;
    bool quit;
    MENU_CHOICE *choices[2][MAX_MENU_CHOICES];
    BOWL_GAME_LOOP *game;

    void init();
    void shutdown();
    void input();
    void processing();
    void draw();
    void set_menu(int pos);
    void toggle_option(int id, int direction);

  public:
    BOWL_MENU(BOWL_GAME_LOOP *game);
    int run(TITLE_SCREEN &parent);
};



