//File: main.h////////////////////////////////////////////////////////////////

//Consts//////////////////////////////////////////////////////////////////////
static const int FPS_MAX = 60;
static const int MAX_PLAYERS = 6;

//Macros//////////////////////////////////////////////////////////////////////
#define VERSION_STR   "0.9 Beta"

#define PIC(x)     ((BITMAP *)data[x].dat)
#define ROUND(x)   ((int)(x+0.5))

//mingw portability
#ifdef ALLEGRO_MINGW32
  #define srandom(x)    srand(x)
  #define random()      rand()
#endif

#ifndef M_PI
  #define M_PI    3.14159265358979323846
#endif

//Only used to determine whether to ask the user to print out a bowling.txt
//#define BOWLING_SCHOOL_BUILD

//Prototypes//////////////////////////////////////////////////////////////////
void new_failed();
void quit_error(const char *msg="Suprisingly enough, you do not have enough free memory to run this game!");
void bowl_init();
void bowl_shutdown();
void blit_buffer();
void bowl_warning(const char *msg);
bool bowl_question(const char *question);

//Externs/////////////////////////////////////////////////////////////////////
extern BITMAP *buffer;
extern DATAFILE *data;
extern volatile int fps;
extern int fpscounter;

