//////////////////////////////////////////////////////////////////////////////
//         L I G H T S W O R D                                              //
//                              Bowling                                     //
//--------------------------------------------------------------------------//
//                          (C) 2003 Mike Farrell                           //
//                                                                          //
//    "Byfar the most classes I've ever used to build a game in my life,    //
//     and on 11:17pm of 12/03/02, this project reaches beta 0.9"           //
//////////////////////////////////////////////////////////////////////////////


//Includes////////////////////////////////////////////////////////////////////
#include <iostream.h>
#include <new.h>
#include <math.h>
#include <stdio.h>
#include <allegro.h>
#include <fblend.h>
#include "main.h"
#include "game.h"
#include "title.h"
#include "options.h"

//Todo's////////
//*Sound effects
//*show "fanfare" for players when they get strikes or spares
//*calc relative distances from centers instead of corners

//Globals/////////////////////////////////////////////////////////////////////
BITMAP *buffer;
DATAFILE *data;
volatile int fps = 0;
int fpscounter = 0;

//Fps handing callback////////////////////////////////////////////////////////
void fps_proc()
{
  fps++;
}
END_OF_FUNCTION(fps_proc);

//New failed callback/////////////////////////////////////////////////////////
void new_failed()
{
  quit_error();
}

//Main////////////////////////////////////////////////////////////////////////
int main(int argc, char *argv[])
{
  int i, title_ret;
  bool debug = FALSE;

  //command line args
  for(i = 1; i < argc; i++)
  {
    if(strcasecmp(argv[i], "-debug") == 0)
      debug = TRUE;
  }

  //Startup game engine
  bowl_init();

  do
  {
    //the game_loop object must be constructed after initialization
    //and before shutdown
    BOWL_GAME_LOOP game_loop;
    TITLE_SCREEN title(&game_loop);

    //Set up a dummy game for debugging to skip the title screen
    if(debug)
    {
      USER_DATA settings1(character_sprites[0], "Mike1");
      USER_DATA settings2(character_sprites[1], "Mike2");
      //USER_DATA settings3(character_sprites[2], "Mike3");

      game_loop.add_player(settings1);
      game_loop.add_player(settings2);
      //game_loop.add_player(settings3);
    }

    //Run the title screen and maybe the game
    if(debug || (title_ret=title.run_loop()) == TITLE_SCREEN::START)
      game_loop.run();
  } while(title_ret != TITLE_SCREEN::QUIT && !debug);

  //Shutdown and quit to OS
  bowl_shutdown();

  return 0;
}
END_OF_MAIN();

//Misc global control and utility functions///////////////////////////////////
void quit_error(const char *msg)
{
  set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
  allegro_message("%s\n", msg);
  allegro_exit();
  exit(1);
}

void bowl_init()
{ 
  int driver, res_w, res_h;
  char buf[128];

  //Non-allegro OS Stuff
  set_new_handler(new_failed);

  //Allegro basic init (keyboard, and timer)
  allegro_init();
  install_keyboard();
  install_timer();
  
  //Read in options
  options.read_config();
  options.get_video_params(driver, res_w, res_h);

  //Video mode
  set_color_depth(16);
  if(set_gfx_mode(driver, res_w, res_h, 0, 0) != 0)
  {
    char buf[128];

    sprintf(buf, "Fatal error setting graphics mode:  %s\nConsider changing your settings.", allegro_error);
    quit_error(buf);
  }

  //Sound
  if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
    cerr << "Can't initialize sound!! (" << allegro_error << ")" << endl;

  //Window title (if windowed)
  sprintf(buf, "LightSword Bowling v%s", VERSION_STR);
  set_window_title(buf);

  //Allocate backbuffer
  buffer = create_bitmap(SCREEN_W, SCREEN_H);
  if(!buffer)
    quit_error();

  //Load datafile(s)
  data = load_datafile("bowling.dat");
  if(!data)
    quit_error("Unable to load bowling.dat!!!");

  //maintain DOS compatibility for timer routines for DOS port
  LOCK_FUNCTION(fps_proc);
  LOCK_VARIABLE(fps);

  //Setup game sync callback timer (removed by allegro_exit)
  install_int_ex(fps_proc, BPS_TO_TIMER(FPS_MAX));

  //Misc settings
  text_mode(-1);
  srandom(time(NULL));
}

void bowl_shutdown()
{
  //Free up and get out
  destroy_bitmap(buffer);
  unload_datafile(data);
  allegro_exit();
}

void blit_buffer()
{
  if(SCREEN_W == 320 && SCREEN_H == 240)
    blit(buffer, screen, 0, 0, 0, 0, 320, 240);
  else
    stretch_blit(buffer, screen, 0, 0, 320, 240, 0, 0, SCREEN_W, SCREEN_H);
}

void bowl_warning(const char *msg)
{
  //fblend too slow on vram, using allegro blending
  drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
  set_trans_blender(0, 0, 0, 164);
  rectfill(screen, 0, 0, SCREEN_W, SCREEN_H, 0);
  solid_mode();
  textout_centre(screen, font, msg, SCREEN_W/2+1, SCREEN_H/2-5+1, 0);
  textout_centre(screen, font, msg, SCREEN_W/2, SCREEN_H/2-5, makecol(255, 0, 0));

  clear_keybuf();
  readkey();
  fps = fpscounter = 0;
}

bool bowl_question(const char *question)
{
  //function will freeze if timer not initialized
  if(fps == 0 && fpscounter == 0)
    quit_error("Idiotic call to bowl_question...");

  bool go = TRUE, ret = FALSE;
  BITMAP *temp = create_bitmap(320, 240);
  int c_anim;

  if(!temp)
    quit_error();
  blit(buffer, temp, 0, 0, 0, 0, 320, 240);

  clear_keybuf();

  //drop into a mini loop for menu
  while(go)
  {
    //input
    if(keypressed())
    {
      int k = readkey() >> 8;

      if(k == KEY_ENTER)
        go = FALSE;
      else if(k == KEY_ESC)
      {
        go = ret = FALSE;
        clear_keybuf();
      }
      else if(k == KEY_LEFT || k == KEY_RIGHT)
      {
        ret = !ret;
        clear_keybuf();
      }
    }

    //processing
    fpscounter++;
    c_anim = makecol(ROUND(192+sin((float)fpscounter*0.1)*32), 0, 0);

    //draw
    if(fpscounter > fps)
    {
      int c1 = (ret) ? c_anim : makecol(0, 0, 255),
          c2 = (!ret) ? c_anim : makecol(0, 0, 255);
      acquire_bitmap(buffer);

      //bg and text
      blit(temp, buffer, 0, 0, 0, 0, 320, 240);
      fblend_rect_trans(buffer, 0, 0, 320, 240, 0, 64);
      textout_centre(buffer, font, question, 161, 101, 0);
      textout_centre(buffer, font, question, 160, 100, makecol(255, 0, 0));

      //option boxes
      rect(buffer, 110, 180, 155, 200, 0);
      fblend_rect_trans(buffer, 111, 181, 44, 19, c1, 128);
      textout_centre(buffer, font, "Yes", 135, 187, 0);
      textout_centre(buffer, font, "Yes", 134, 186, makecol(255, 0, 0));

      rect(buffer, 165, 180, 210, 200, 0);
      fblend_rect_trans(buffer, 166, 181, 44, 19, c2, 128);
      textout_centre(buffer, font, "No", 190, 187, 0);
      textout_centre(buffer, font, "No", 189, 186, makecol(255, 0, 0));

      //screen update
      release_bitmap(buffer);
      blit_buffer();
    }
    while(fpscounter > fps) ;
  }

  //wait for esc key to be unpressed
  while(key[KEY_ESC]) ;

  destroy_bitmap(temp);
  return ret;
}

