////////////////////////////////////////////////////////
// gfx_bgame.cpp - A graphical extension to proj4's   //
//                 bowling_game class                 //
////////////////////////////////////////////////////////

//Includes///////////////////////////////////////////////////////////////////
#include <iostream.h>
#include <allegro.h>
#include <fblend.h>
#include <math.h>
#include <fblend.h>
#include "main.h"
#include "game.h"

//GFX_BOWLING_GAME functions//////////////////////////////////////////////////
void GFX_BOWLING_GAME::draw_results(BITMAP *dest, int x, int y, int frame_w, int frame_h, int num_frames, int cur_ball, int color)
{
  int i, j, x_pos = x+3, y_pos = y+13, far_right = x+10*frame_w,
      stop_ball = 2;

  //Name
  textout(dest, font, name, x, y, color);
  
  //Need for a third row? (ball)
  if(num_frames == 10 && frames[9].has_mark())
    stop_ball = 3;

  //Fill
  fblend_rect_add(dest, x+1, y+11, frame_w*10-1, frame_h*stop_ball, makecol(0, 0, 255), 64);

  //Totals box
  rect(dest, far_right, y-3, far_right-frame_w*3, y+frame_h-2, color);
  fblend_rect_add(dest, far_right-frame_w*3+1, y-2, far_right-(far_right-frame_w*3)-1, frame_h, makecol(25, 150, 255), 64);
  textprintf_right(dest, font, far_right-2, y+1, color, "%d", get_final_score(num_frames));

  //Lines
  hline(dest, x, y+10, x+frame_w*10, color);
  hline(dest, x, y+10+frame_h, x+frame_w*10, color);
  hline(dest, x, y+10+frame_h*2, x+frame_w*10, color);
  if(stop_ball == 3)
    hline(dest, x, y+10+frame_h*3, x+frame_w*10, color);

  for(i = 0; i < 11; i++)
    vline(dest, x+i*frame_w, y+10, y+10+frame_h*stop_ball, color);

  for(j = 1; j <= stop_ball; j++)
  {
    //Fill in the numbers
    for(i = 0; i < num_frames; i++)
    {
      static const int WHITE = makecol16(255, 255, 255);
      const int knocked = frames[i].get_pins_knocked(j);

      //Fill current frame red
      if(i == num_frames-1 && j-1 == cur_ball && color != WHITE)
        fblend_rect_trans(dest, x_pos-2, y_pos-2, frame_w-1, frame_h-1, makecol(255, 0, 0), 128);

      //Don't draw un-rolled balls
      if(i == num_frames-1 && j-1 >= cur_ball)
        continue;

      //Treat third row differently
      if(j == 3)
      {
        //Blank
        if(i < 9)
          textout(dest, font, "-", x_pos, y_pos, color);
        //Strike
        else if(knocked == 10)
          textout(dest, font, "X", x_pos, y_pos, color);
        //other
        else
          textprintf(dest, font, x_pos, y_pos, color, "%d", knocked);
      }
      else
      {
        //strike
        if((j == 1 && knocked == 10) || (i == 9 && j == 2 && knocked == 10 && frames[i].get_pins_knocked(1) == 10))
          textout(dest, font, "X", x_pos, y_pos, color);
        //spare
        else if(j == 2 && frames[i].has_mark() && frames[i].get_pins_knocked(1) != 10)
          textout(dest, font, "/", x_pos, y_pos, color);
        //blank
        else if(i < 9 && frames[i].get_pins_knocked(1) == 10)
          textout(dest, font, "-", x_pos, y_pos, color);
        //other
        else
          textprintf(dest, font, x_pos, y_pos, color, "%d", knocked);
      }

      x_pos += frame_w;
    }
    x_pos = x+3;

    y_pos += frame_h;
  }
}

void GFX_BOWLING_GAME::draw_extended_results(BITMAP *dest, int x, int y, int frame_w, int frame_h, int num_frames, int cur_ball, int color)
{
  int num_strikes = 0, num_sec_strikes = 0, num_spares = 0, total_pins = 0,
      i, j, streak_temp = 0;

  draw_results(dest, x, y, frame_w, frame_h, num_frames, cur_ball, color);

  x += 140;
  y += 10;

  //Calculate some cool things (unfortunately on the fly)
  for(i = 0; i < num_frames; i++)
  {
    //frames and frame streaks
    if(frames[i].has_mark() == frame::STRIKE || i == 9)
    {
      if(i != 9 || frames[i].get_pins_knocked(1) == 10)
      {
        num_strikes++;
        streak_temp++;
      }

      //count last two possible strikes for last frame
      if(i == 9)
      {
        if(frames[i].get_pins_knocked(1) == 10 && frames[i].get_pins_knocked(2) == 10)
        {
          num_strikes++;
          streak_temp++;
        }
        if(frames[i].get_pins_knocked(3) == 10)
        {
          num_strikes++;
          streak_temp++;
        }
      }
    }
    else streak_temp = 0;

    if(streak_temp > num_sec_strikes)
      num_sec_strikes = streak_temp;

    //spares
    if(frames[i].has_mark() == frame::SPARE)
      num_spares++;

    //total pins
    for(j = 1; j <= frames[i].get_num_balls(); j++)
      total_pins += frames[i].get_pins_knocked(j);
  }

  y -= frame_h;

  //Extra stats box
  rect(dest, x, y, x+150, y+frame_h*4, color);
  fblend_rect_trans(dest, x+1, y+1, 149, frame_h*4-1, makecol(0, 0, 100), 64);

  textprintf(dest, font, x+5, y+5, color, "Strikes:  %d", num_strikes);
  textprintf(dest, font, x+5, y+15, color, "Strike Streak:  %d", num_sec_strikes);
  textprintf(dest, font, x+5, y+25, color, "Spares:  %d", num_spares);
  textprintf(dest, font, x+5, y+35, color, "Total Pins:  %d", total_pins);
}

GFX_BOWLING_GAME &GFX_BOWLING_GAME::operator =(GFX_BOWLING_GAME &rhs)
{
  int i;

  if(this == &rhs)
    return *this;

  for(i = 0; i < 10; i++)
    frames[i] = rhs.frames[i];
  strcpy(name, rhs.name);
  score = rhs.score;

  return *this;
}

