//File: game.h////////////////////////////////////////////////////////////////

//Includes////////////////////////////////////////////////////////////////////
#ifndef BOWLING_GAME_H
  #include "bowlinggame.h"
#endif

#ifndef OBJECT_H
  #include "object.h"
#endif

#ifndef GFX_BGAME_H
  #include "gfx_bgame.h"
#endif

//defined from bowlingdat.h
#ifndef ls_logo
  #include "bowlingdat.h"
#endif

//Constants for converting 0-6 to sprite indices
static const int MAX_CHARACTER_SPRITES = 6,
character_sprites[MAX_CHARACTER_SPRITES] =
{
  char1_dna, char2_dna, char3_dna, char4_dna, char5_dna, char6_dna
};


//Classes/////////////////////////////////////////////////////////////////////

//Get indicator to shut up about undeclared object
class BOWL_GAME_LOOP;

//indicator for position or angle of ball
class INDICATOR
{
  private:
    static const int DISABLED = 0, ANGLE = 1, SLIDER = 2;
    float value, angle, d_ang;
    int mode;

  public:
    INDICATOR();
    void set_value(float value);
    void set_angle(float angle);
    void input();
    void processing();
    void draw(BOWL_GAME_LOOP &parent);
    float finish();
    bool is_enabled();
};


//user scores and settings
class USER_DATA
{
  private:
    int character, current_ball;
    char name[bowling_game::BG_NAME_MAX];

  public:
    GFX_BOWLING_GAME bgame;

    USER_DATA(int character, const char *name);
    USER_DATA(USER_DATA &settings);
    const char *get_name();
    int get_character();
    void reset_ball();
    void next_ball();
    int get_ball();

    USER_DATA &operator =(USER_DATA &rhs);
};

//the men who beat you up when you are in last place..
class BAT_MAN
{
  private:
    float x, y;
    int sprite, counter;
    bool flipped, enabled;

  public:
    BAT_MAN();
    void enable(bool flipped);
    void processing(BOWL_GAME_LOOP &parent);
    void draw(int mx, int my);
    bool is_enabled();
};

//entire game loop class
class BOWL_GAME_LOOP
{
  friend class INDICATOR;
  friend class BOWLING_BALL;

  private:
    //status flags
    static const int RUN = 1, QUIT = 2, GAME_OVER = 3;
    int status;

    //Map offsets and guidelines
    static const int mx = 140, lane_left = 36, lane_right = 144,
                     lane_start = 541;
    float my;

    //Player and other game objects
    USER_DATA *user_data[MAX_PLAYERS];
    BOWLING_BALL player_ball;
    BOWLING_PIN pins[10];
    BAT_MAN bat_men[2];
    int num_players, current_player, turn_phase,
        current_frame;
    float player_x, player_y;
    bool player_step;

    //internal control
    void input();
    void processing(bool outside_loop=FALSE);
    void background_processing();
    void draw_screen();
    void summary();
    void do_bats();

    //internal utility
    void setup_pins();
    void reset_turn();

    //Dynamic objects
    static const int SLIDER = 0, ANGLE = 1;
    INDICATOR indicators[2];

    //Visual effects
    int screen_a, d_screen_a, a_fps, disp_fps;
    bool show_fps;

    //Surface for special effect in left background
    BITMAP *background;
    float back_ang, back_scale, d_back_ang, d_back_scale;

  public:
    BOWL_GAME_LOOP();
    ~BOWL_GAME_LOOP();

    //utility
    bool character_taken(int char_id);
    bool add_player(USER_DATA &settings);
    bool delete_last_player();
    void save_scores(const char *filename);
    int get_num_players() { return num_players; }

    //control
    void run();
};



