//File: game.cpp//////////////////////////////////////////////////////////////

//Includes///////////////////////////////////////////////////////////////////
#include <iostream.h>
#include <allegro.h>
#include <fstream.h>
#include <math.h>
#include <fblend.h>
#include "main.h"
#include "game.h"
#include "options.h"

//INDICATOR functions/////////////////////////////////////////////////////////
INDICATOR::INDICATOR()
{
  mode = DISABLED;
}

void INDICATOR::set_value(float value)
{
  mode = SLIDER;
  this->value = value;
}

void INDICATOR::set_angle(float angle)
{
  mode = ANGLE;
  this->angle = angle + -20+(random()%40);

  if(options.hard_aiming)
  {
    d_ang = 0.35;

    if(random()%2 == 0)
      d_ang *= -1;
  }
}

void INDICATOR::input()
{
  //Input for angle only
  if(mode == ANGLE)
  {
    if(key[KEY_LEFT])
    {
      if(!options.hard_aiming)
        angle--;
      else
      {
        d_ang -= 0.3;

        if(d_ang < -5)
          d_ang = -5;
      }
    }
    if(key[KEY_RIGHT])
    {
      if(!options.hard_aiming)
        angle++;
      else
      {
        d_ang += 0.3;

        if(d_ang > 5)
          d_ang = 5;
      }
    }
  }

  //S to roll a strike
  //uncomment below if you're a cheater
/*  if(key[KEY_S])
  {
    value = 0.4;
    angle = 0.0;
  }*/
}

void INDICATOR::processing()
{
  //Slider
  if(mode == SLIDER)
  {
    static float direction = 1;
    float dx = 1/((ABS(value-0.5)/0.5)+0.2)*0.03*direction;

    value += dx;

    if(value > 1.0)
    {
      value = 1.0;
      direction *= -1;
    }
    else if(value < 0.0)
    {
      value = 0.0;
      direction *= -1;
    }
  }
  //Angle
  else
  {
    if(options.hard_aiming)
      angle += d_ang;

    if(angle < 0)
      angle += 256;
    if(angle > 256)
      angle -= 256;

    if(angle > 128 && angle < 234)
      angle = 234;
    else if(angle < 128 && angle > 22)
      angle = 22;
  }
}

void INDICATOR::draw(BOWL_GAME_LOOP &parent)
{
  const float mx = parent.mx, my = parent.my;

  //Slider
  if(mode == SLIDER)
  {
    const int w = (BOWL_GAME_LOOP::lane_right-BOWL_GAME_LOOP::lane_left-PIC(blue_arrow)->w);

    draw_sprite(buffer, PIC(blue_arrow), ROUND(mx+BOWL_GAME_LOOP::lane_left+(value*w)), ROUND(my+BOWL_GAME_LOOP::lane_start));
  }
  //Angle
  else
  {
    pivot_sprite(buffer, PIC(red_arrow), ROUND(mx+parent.player_x)+8, ROUND(my+parent.player_y), 5, 22, ftofix(angle));
  }
}

float INDICATOR::finish()
{
  float ret = angle;

  if(mode == SLIDER)
  {
    const int w = (BOWL_GAME_LOOP::lane_right-BOWL_GAME_LOOP::lane_left-PIC(blue_arrow)->w);

    ret = BOWL_GAME_LOOP::lane_left+(value*w);
  }

  //Disable
  mode = DISABLED;

  //Return final setting
  return ret;
}

bool INDICATOR::is_enabled()
{
  return (mode != DISABLED);
}

//USER_DATA functions////////////////////////////////////////////////////////
USER_DATA::USER_DATA(int character, const char *name)
{
  this->character = character;
  strcpy(this->name, name);
  current_ball = 0;
  bgame.set_name((char *)name);
}

USER_DATA::USER_DATA(USER_DATA &settings)
{
  *this = settings;
}

const char *USER_DATA::get_name()
{
  return name;
}

USER_DATA &USER_DATA::operator =(USER_DATA &rhs)
{
  character = rhs.character;
  strcpy(name, rhs.name);
  bgame = rhs.bgame;
  current_ball = rhs.current_ball;

  return *this;
}

int USER_DATA::get_character()
{
  return character;
}

void USER_DATA::reset_ball()
{
  current_ball = 0;
}

void USER_DATA::next_ball()
{
  current_ball++;
}

int USER_DATA::get_ball()
{
  return current_ball;
}

//BAT_MAN functions///////////////////////////////////////////////////////////
BAT_MAN::BAT_MAN()
{
  sprite = badman_lta;
  flipped = enabled = FALSE;
}

void BAT_MAN::enable(bool flipped)
{
  enabled = TRUE;
  this->flipped = flipped;
  x = (flipped) ? 90-30-8 : 90+-16+30;
  y = PIC(alley_bg)->h+50;
  counter = (flipped) ? 30 : 60;
}

void BAT_MAN::processing(BOWL_GAME_LOOP &parent)
{
  if(y > PIC(alley_bg)->h-25)
  {
    y--;
    if(y < PIC(alley_bg)->h)
      x += (flipped) ? 0.5 : -0.5;

    if(fpscounter % 8 == 0)
    {
      if(sprite == badman_lta)
        sprite = badman_ltb;
      else
        sprite = badman_lta;
    }
  }
  else
  {
    if(sprite == badman_lta || sprite == badman_ltb)
      sprite = badman_ltc;

    if(counter % 30 == 0)
      sprite = badman_ltc;
    else if(counter % 40 == 0)
      sprite = badman_ltd;

    counter++;
  }
}

void BAT_MAN::draw(int mx, int my)
{
  if(!flipped)
    draw_sprite(buffer, PIC(sprite), ROUND(mx+x), ROUND(my+y));
  else
    draw_sprite_h_flip(buffer, PIC(sprite), ROUND(mx+x), ROUND(my+y));
}

bool BAT_MAN::is_enabled()
{
  return enabled;
}

//BOWL_GAME_LOOP functions////////////////////////////////////////////////////
BOWL_GAME_LOOP::BOWL_GAME_LOOP()
{
  int i, j;

  //init variables
  back_ang = d_back_scale = 0.0;
  back_scale = 1.0;
  d_back_ang = -0.25+((random()%20)/80.0);
  show_fps = FALSE;
  disp_fps = FPS_MAX;
  a_fps = 0;

  num_players = 0;
  for(i = 0; i < MAX_PLAYERS; i++)
    user_data[i] = NULL;

  //background image
  background = create_bitmap(512, 480);
  if(!background)
    quit_error();

  for(i = 0; i < 2; i++) for(j = 0; j < 2; j++)
    blit(PIC(game_bg), background, 0, 0, i*256, j*256, 256, 256);
}

BOWL_GAME_LOOP::~BOWL_GAME_LOOP()
{
  int i;

  destroy_bitmap(background);

  for(i = 0; i < num_players; i++)
    delete user_data[i];
}

bool BOWL_GAME_LOOP::character_taken(int char_id)
{
  int i;
  bool ret = FALSE;

  for(i = 0; i < num_players; i++)
  {
    if(user_data[i]->get_character() == char_id)
    {
      ret = TRUE;
      break;
    }
  }

  return ret;
}

bool BOWL_GAME_LOOP::add_player(USER_DATA &settings)
{
  bool ret = FALSE;

  if(num_players != MAX_PLAYERS)
  {
    user_data[num_players] = new USER_DATA(settings);
    num_players++;
    ret = TRUE;
  }

  return ret;
}

bool BOWL_GAME_LOOP::delete_last_player()
{
  bool ret = FALSE;

  if(num_players)
  {
    delete user_data[num_players];
    num_players--;

    ret = TRUE;
  }

  return ret;
}

void BOWL_GAME_LOOP::save_scores(const char *filename)
{
  ofstream outfile(filename);
  int i, frame, ball;

  if(!outfile)
  {
    bowl_warning("Unable to open file to save your scores!");
    return;
  }

  //names
  for(i = 0; i < num_players; i++)
    outfile << user_data[i]->bgame.get_name() << endl;

  //scoring frame by frame
  for(frame = 0; frame < 10; frame++)
  {
    for(i = 0; i < num_players; i++)
    {
      for(ball = 1; ball <= user_data[i]->bgame.get_frame(frame).get_num_balls(); ball++)
      {
        outfile << user_data[i]->bgame.get_frame(frame).get_pins_knocked(ball);
        outfile << ' ';
      }
    }
  }

  outfile.close();
}

void BOWL_GAME_LOOP::setup_pins()
{
  int i;
  float y = 4, indent = 24;

  for(i = 0; i < 10; i++)
  {
    int x_pos = i;

    //Starts of each row
    if(i > 8)
      x_pos -= 9;
    else if(i > 6)
      x_pos -= 7;
    else if(i > 3)
      x_pos -= 4;

    float x = (lane_left)+indent+(x_pos*17);

    //Place the pin
    pins[i].place(x, y);

    //indent for next row
    if(i == 3 || i == 6 || i == 8)
    {
      indent += 8;
      y += 13;

      if(i == 8)
        indent++;
    }
  }
}

void BOWL_GAME_LOOP::input()
{
  int i;
  static bool f_down = FALSE;

  if(key[KEY_ESC] && bowl_question("Really abort your game??"))
    status = QUIT;

  //Space bar to stop slider
  if(indicators[SLIDER].is_enabled() && key[KEY_SPACE])
  {
    player_x = indicators[SLIDER].finish();
    turn_phase++;
  }
  
  //Toggle fps
  if(key[KEY_F])
  {
    if(!f_down)
    {
      f_down = TRUE;
      show_fps = !show_fps;
    }
  }
  else f_down = FALSE;

  //Indicators
  for(i = 0; i < 2; i++) if(indicators[i].is_enabled())
    indicators[i].input();
}

void BOWL_GAME_LOOP::processing(bool outside_loop)
{
  bool player_moving = FALSE;
  int i;
  static float player_dy = 0.0;

  //Timing
  fpscounter++;
  if(fpscounter % FPS_MAX == 0)
  {
    disp_fps = a_fps;
    a_fps = 0;
  }

  //Player movement and aiming
  if(player_y > PIC(alley_bg)->h-20)
  {
    player_dy = -1.0;
    player_moving = TRUE;
  }

  //Horizontal slider aiming
  else if(turn_phase == 0)
  {
    if(!indicators[SLIDER].is_enabled())
      indicators[SLIDER].set_value(0);
  }

  //no phase-specific processing on outside loops
  if(!outside_loop)
  {
    //Aiming while approaching lane
    if(turn_phase == 1)
    {
      if(!indicators[ANGLE].is_enabled())
        indicators[ANGLE].set_angle(0);
    }
    //Ball released and in motion
    if(turn_phase == 2)
    {
      if(player_dy)
      {
        player_dy *= 0.86;
        player_moving = TRUE;

        if(player_dy > -0.01)
          player_dy = 0.0;
      }

      player_ball.snap_my(my);

      if(player_ball.down_lane())
      {
        //Start a fade out
        d_screen_a = -5;
      }
    }
  }

  if(indicators[ANGLE].is_enabled())
  {
    player_moving = TRUE;

    if(player_y > lane_start)
    {
      player_dy -= 0.03;
    }
    else
    {
      //ball release
      player_ball.release(player_x, player_y, indicators[ANGLE].finish());
      turn_phase++;
    }
  }

  if(player_moving)
  {
    player_y += player_dy;

    if(fpscounter % 6 == 0)
      player_step = !player_step;
  }
  else
    player_dy = 0.0;

  //Bat men
  for(i = 0; i < 2; i++) if(bat_men[i].is_enabled())
    bat_men[i].processing(*this);

  //Indicators
  for(i = 0; i < 2; i++) if(indicators[i].is_enabled())
    indicators[i].processing();

  //Bowling ball
  if(player_ball.is_enabled())
    player_ball.processing();

  //Pins
  for(i = 0; i < 10; i++)
  {
    //pins' processing function is for when they've been knocked down
    if(!pins[i].is_enabled())
    {
      int j;

      pins[i].processing();

      //Collision detection (other un-knocked pins)
      for(j = 0; j < 10; j++)
      {
        if(i != j && pins[j].is_enabled() &&
        pins[i].mask->collide(pins[i].x, pins[i].y, pins[j].mask, pins[j].x, pins[j].y))
        {
          player_ball.hit_pin();
          pins[j].knock(pins[i]);
        }
      }
    }
    else
    {
      //Collision detection (ball)
      if(player_ball.mask->collide(player_ball.x, player_ball.y, pins[i].mask, pins[i].x, pins[i].y))
      {
        player_ball.hit_pin();
        pins[i].knock(player_ball);
      }
    }
  }

  //Fading
  if(d_screen_a)
  {
    screen_a += d_screen_a;

    //Fading out to end roll
    if(screen_a <= 0 && !outside_loop)
    {
      const int score = player_ball.get_pins_knocked(),
                current_ball = user_data[current_player]->get_ball();
      int max_ball = 1;

      screen_a = 0;

      //Store the results
      user_data[current_player]->bgame.get_frame(current_frame).set_score(score);
      user_data[current_player]->bgame.get_final_score(current_frame+1, TRUE);

      //Allow player a third ball for mark on 10th
      if(current_frame == 9 && user_data[current_player]->bgame.get_frame(current_frame).has_mark())
        max_ball = 2;

      //Cycle ball, turn and frame if necessary
      user_data[current_player]->next_ball();
      if(current_ball == max_ball || (current_ball == 0 && (score == 10 && current_frame < 9)))
      {
        setup_pins();

        current_player++;
        if(current_player == num_players)
        {
          current_player = 0;

          //game end
          if(current_frame == 9)
          {
//            do_bats();
            status = GAME_OVER;
          }
          else
          {
            current_frame++;

            for(i = 0; i < num_players; i++)
              user_data[i]->reset_ball();
          }
        }
        else
          user_data[current_player]->reset_ball();
      }
      //still set up pins after a clean-out on last frame
      else if(user_data[current_player]->bgame.get_frame(current_frame).get_pins_left() == 0)
      {
        //if bowling isn't the most complex game with 100000000 clauses!!!
        //I mean, damn!
        if(!(user_data[current_player]->get_ball() == 2 && user_data[current_player]->bgame.get_frame(current_frame).get_pins_knocked(1) == 10 && user_data[current_player]->bgame.get_frame(current_frame).get_pins_knocked(2) < 10))
          setup_pins();
      }

      //Reset all variables for new roll
      reset_turn();
      d_screen_a = 4;
    }
    else if(screen_a >= 255)
    {
      screen_a = 255;
      d_screen_a = 0;
    }
  }

  //Background processing
  background_processing();
}

//external to processing because this
//function might be used by more than one loop
void BOWL_GAME_LOOP::background_processing()
{
  //Dynamic background
  back_ang += d_back_ang;
  back_scale += d_back_scale;

  //Switch patterns
  if(fpscounter % 20 == 0)
  {
    d_back_ang += -0.005+(random()%2000)/200000.0;
    d_back_scale += -0.0001+((random()%200)+1)/1000000.0;
  }

  if(d_back_ang < -0.05)
    d_back_ang = -0.05;
  else if(d_back_ang > 0.05)
    d_back_ang = 0.05;

  if(d_back_scale < -0.004)
    d_back_scale = -0.004;
  else if(d_back_scale > 0.004)
    d_back_ang = 0.004;

  if(back_scale <  0.8)
    back_scale = 0.8;
  else if(back_scale > 1.0)
    back_scale = 1.0;
}

void BOWL_GAME_LOOP::draw_screen()
{
  int char_sprite = user_data[current_player]->get_character()+1+(int)player_step,
      i;

  a_fps++;

  //For DirectX port
  acquire_bitmap(buffer);

  set_clip(buffer, 0, 0, 320-mx, 240);
  rotate_scaled_sprite(buffer, background, -background->w/4, -background->h/4, ftofix(back_ang), ftofix(back_scale));
  set_clip(buffer, 0, 0, 320, 240);

  //Alley background
  blit(PIC(alley_bg), buffer, 0, 0, mx, ROUND(my), PIC(alley_bg)->w, PIC(alley_bg)->h);

  //Sprites
  draw_sprite(buffer, PIC(char_sprite), mx+ROUND(player_x), ROUND(my+player_y));

  //Bat men
  for(i = 0; i < 2; i++) if(bat_men[i].is_enabled())
    bat_men[i].draw(mx, my);

  //Indicators
  for(i = 0; i < 2; i++) if(indicators[i].is_enabled())
    indicators[i].draw(*this);

  //Ball and pins
  for(i = 0; i < 10; i++)
    pins[i].draw(mx, my);
  if(player_ball.is_enabled())
    player_ball.draw(mx, my);

  //Debugging reference lines
//  vline(buffer, mx+lane_left+(lane_right-lane_left)/2, 0, 240, makecol(255, 0, 0));

  //Scores
  int score_pos = MAX(0, current_player-3), score_stop = MIN(score_pos+4, num_players);

  for(i = score_pos; i < score_stop; i++)
  {
    const int color = (i == current_player) ? makecol(255, 237, 153) : makecol(255, 255, 255);

    user_data[i]->bgame.draw_results(buffer, 3, 5+(i-score_pos)*60, 12, 12, current_frame+1, user_data[i]->get_ball(), color);
  }

  //Fps
  if(show_fps)
    textprintf_right(buffer, font, 320, 232, makecol(255, 255, 255), "FPS: %d", disp_fps);

  //Fading
  if(screen_a != 255)
    fblend_rect_trans(buffer, 0, 0, 320, 240, 0, 255-screen_a);

  //more DirectX stuff
  release_bitmap(buffer);

  //Update screen
  blit_buffer();
}

void BOWL_GAME_LOOP::reset_turn()
{
  my = -PIC(alley_bg)->h+240;
  player_x = PIC(alley_bg)->w/2-8;
  player_y = PIC(alley_bg)->h+100;
  player_step = FALSE;
  turn_phase = 0;

  player_ball.reset_pins_knocked();
}

void BOWL_GAME_LOOP::run()
{
  int i;

  //init misc variables
  status = RUN;
  current_player = current_frame = 0;
  screen_a = 255;
  d_screen_a = 0;
  for(i = 0; i < num_players; i++)
    user_data[i]->reset_ball();

  //init position stuff
  reset_turn();
  setup_pins();

////debug stuff
//  current_frame = 9;

  //loop
  while(status == RUN)
  {
    input();
    processing();
    if(fpscounter >= fps)
      draw_screen();
    while(fpscounter > fps) ;
  }

  //final scores screen
  if(status == GAME_OVER)
    summary();
}

void BOWL_GAME_LOOP::summary()
{
  bool go = TRUE, tie = FALSE;
  const char *title = (num_players < 4) ? "Game Summary" : "Game Summary (Top 4 players)";
  USER_DATA *games[MAX_PLAYERS];
  int score = 300, i, pos = 0;

  //setup array of games from 0 to 6, highest score to lowest
  while(score >= 0)
  {
    for(i = 0; i < num_players; i++)
    {
      if(score == user_data[i]->bgame.get_final_score())
      {
        games[pos] = user_data[i];
        pos++;
      }
    }

    score--;
  }

  //in the event of a tie
  if(games[0]->bgame.get_final_score() == games[1]->bgame.get_final_score())
    tie = TRUE;

  clear_keybuf();
  while(go || screen_a)
  {
    //Input
    if(keypressed())
      go = FALSE;

    //Processing
    fpscounter++;
    if(go && screen_a < 255)
    {
      screen_a += 5;
      if(screen_a > 255)
        screen_a = 255;
    }
    if(!go && screen_a > 0)
    {
      screen_a -= 5;
      if(screen_a < 0)
        screen_a = 0;
    }
    background_processing();
    //minor adjustment
    back_scale = 1.2;

    //Draw
    if(fpscounter >= fps)
    {
      acquire_bitmap(buffer);

      rotate_scaled_sprite(buffer, background, -100, -100, ftofix(back_ang), ftofix(back_scale));
      textout_centre(buffer, font, title, 161, 6, 0);
      textout_centre(buffer, font, title, 160, 5, makecol(255, 0, 0));
      if(tie)
      {
        textout_centre(buffer, font, "Game was a tie!", 161, 16, 0);
        textout_centre(buffer, font, "Game was a tie!", 160, 15, makecol(255, 0, 0));
      }

      //draw extended summary for each player
      for(i = 0; i < MIN(4, pos); i++)
      {
        int c = (i == 0 && !tie) ? makecol(200, 200, 255) : makecol(255, 255, 255);
        char char_sprite = games[i]->get_character();

        draw_sprite(buffer, PIC(char_sprite), 5, 45+i*60);
        games[i]->bgame.draw_extended_results(buffer, 25, 30+i*60, 12, 12, 10, 3, c);
      }

      if(screen_a != 255)
        fblend_rect_trans(buffer, 0, 0, 320, 240, 0, 255-screen_a);
      release_bitmap(buffer);
      blit_buffer();
    }
    while(fpscounter > fps) ;
  }

  #ifdef BOWLING_SCHOOL_BUILD
    if(bowl_question("Output bowling.txt file??"))
      save_scores("bowling.txt");
  #endif
}

void BOWL_GAME_LOOP::do_bats()
{
  bool go = TRUE;
  int i, loser = 0, min_score = 300, temp_score = 301;

  for(i = 0; i < num_players; i++)
  {
    int score = user_data[i]->bgame.get_final_score();

    if(score < min_score)
    {
      min_score = score;
      loser = i;
    }
    else if(score == min_score)
      temp_score = score;
  }

  //tie
  if(temp_score == min_score)
    return;

  d_screen_a = 4;
  current_player = loser;
  my = -PIC(alley_bg)->h+240;
  player_x = PIC(alley_bg)->w/2-8;
  player_y = PIC(alley_bg)->h+100;


  //drop into a smaller subloop
  while(go)
  {
    if(key[KEY_ESC])
      break;

    if(player_y <= PIC(alley_bg)->h-20 && !bat_men[0].is_enabled())
    {
      bat_men[0].enable(TRUE);
      bat_men[1].enable(FALSE);
    }

    processing(TRUE);
    draw_screen();
  }
}
