//Includes////////////////////////////////////////////////////////////////////
#include "frame.h"

//Frame functions/////////////////////////////////////////////////////////////
frame::frame()
{
  int i;

  for(i = 0; i < 3; i++)
    score[i] = 0;
  num_balls = 0;
}

int frame::get_pins_knocked(int ball)
{
  int ret = -1;

  if(ball > 0 && ball <= 3)
    ret = score[ball-1];

  return ret;
}

int frame::get_pins_left()
{
  int i, ret = 10;

  for(i = 0; i < num_balls; i++)
  {
    ret -= score[i];

    if(ret < 0)
      ret = 0;
  }

  return ret;
}

int frame::get_num_balls()
{
  return num_balls;
}

int frame::has_mark()
{
  int ret = 0;

  //Strike
  if(score[0] == 10)
    ret = STRIKE;
  //Spare
  else if(score[0]+score[1] == 10 && score[0] != 10)
    ret = SPARE;

  return ret;
}

void frame::set_score(int *score, int num_balls)
{
  int i;

  if(num_balls > 0 && num_balls <= 3)
  {
    for(i = 0; i < num_balls; i++)
      this->score[i] = score[i];
  }

  this->num_balls = num_balls;
}

void frame::set_score(int score)
{
  this->score[num_balls] = score;
  num_balls++;
}

frame &frame::operator =(frame &rhs)
{
  int i;
  
  for(i = 0; i < 3; i++)
    score[i] = rhs.score[i];
  num_balls = rhs.num_balls;
  
  return *this;
}
