//////////////////////////////////////////////////////////////////////////////
// File: bowlinggame.cpp
// bowling_game class functions
//////////////////////////////////////////////////////////////////////////////

//Includes////////////////////////////////////////////////////////////////////
#include <iostream.h>
#include <iomanip.h>
#include "bowlinggame.h"

bowling_game::bowling_game()
{
  name[0] = 0;
  score = -1;
}

void bowling_game::set_name(char *name)
{
  strncpy(this->name, name, BG_NAME_MAX-1);
}

const char *bowling_game::get_name()
{
  return name;
}

void bowling_game::display_results_header()
{
  long tmp_flags = cout.flags();
  int i;

  ascii_line('=');
  cout.setf(ios::left, ios::adjustfield);
  cout << setw(BG_NAME_MAX+8) << "| Frame";

  for(i = 1; i <= 10; i++)
    cout << "| *" << i << "* ";
  cout << '|' << endl;
  ascii_line('=');

  cout.flags(tmp_flags);
}

void bowling_game::display_score_header()
{
  long tmp_flags = cout.flags();

  ascii_line('=', 35);
  cout.setf(ios::left, ios::adjustfield);
  cout << setw(BG_NAME_MAX+8) << "| Final Score";

  cout.setf(ios::right, ios::adjustfield);
  cout << setw(19) << "|" << endl;
  ascii_line('=', 35);

  cout.flags(tmp_flags);
}

void bowling_game::display_results(bool star)
{
  long tmp_flags = cout.flags();
  int i, j;

  //loop through first two balls for each frame
  for(j = 1; j <= 2; j++)
  {
    cout.setf(ios::left, ios::adjustfield);
    if(j == 1)
    {
      char buf[BG_NAME_MAX+1] = "*";

      //put a star in front of name if requested
      if(star)
        strcat(buf, name);
      else
        strcpy(buf, name);

      cout << "| " << setw(BG_NAME_MAX+1) << buf << "B. " << j << ' ';
    }
    else
      cout << "| " << setw(BG_NAME_MAX+1) << "" << "B. " << j << ' ';

    cout.setf(ios::right, ios::adjustfield);
    cout << '|';
    for(i = 0; i < 10; i++)
    {
      const int knocked = frames[i].get_pins_knocked(j);

      //strike
      if((j == 1 && knocked == 10) || (i == 9 && j == 2 && knocked == 10 && frames[i].get_pins_knocked(1) == 10))
        cout << setw(BG_FRAME_W) << "X" << " |";
      //spare
      else if(j == 2 && frames[i].has_mark() && frames[i].get_pins_knocked(1) != 10)
        cout << setw(BG_FRAME_W) << "/" << " |";
      //blank
      else if(i < 9 && frames[i].get_pins_knocked(1) == 10)
        cout << setw(BG_FRAME_W) << "-" << " |";
      //other
      else
        cout << setw(BG_FRAME_W) << knocked << " |";
    }
    cout << endl;
  }

  //draw third ball row if necessary
  if(frames[9].has_mark())
  {
    const int knocked = frames[9].get_pins_knocked(3);

    cout << "| " << setw(BG_NAME_MAX+1) << "" << "B. " << j << ' ';
    cout << '|';
    for(i = 0; i < 9; i++)
      cout << setw(BG_FRAME_W) << "-" << " |";

    //strike
    if(knocked == 10)
      cout << setw(BG_FRAME_W) << "X" << " |";
    //other
    else
      cout << setw(BG_FRAME_W) << knocked << " |";

    cout << endl;
  }

  ascii_line('-');

  cout.flags(tmp_flags);
}

void bowling_game::display_final_score(bool star)
{
  long tmp_flags = cout.flags();
  char buf[BG_NAME_MAX+1] = "*";

  //put a star in front of name if requested
  if(star)
    strcat(buf, name);
  else
    strcpy(buf, name);

  cout.setf(ios::left, ios::adjustfield);
  cout << "| " << setw(BG_NAME_MAX+1) << buf << '|';
  cout.setf(ios::right, ios::adjustfield);
  cout << setw(21) << get_final_score() << " |" << endl;
  ascii_line('-', 35);

  cout.flags(tmp_flags);
}

int bowling_game::get_final_score(int num_frames, bool force)
{
  int i, j, ret = 0;

  //Don't bother calculating score if it's already done
  if(score == -1 || force)
  {
    //calculate the final score frame by frame
    for(i = 0; i < num_frames; i++)
    {
      int frame_score = 0;

      for(j = 1; j <= frames[i].get_num_balls(); j++)
        frame_score += frames[i].get_pins_knocked(j);

      //Calculate marks if not tenth frame
      if(i != 9)
      {
        int ret = frames[i].has_mark(), balls_ahead = 0, frames_ahead = 1,
            ball_pos = 1;

        switch(ret)
        {
          case frame::STRIKE:

            while(balls_ahead < 2 && i+frames_ahead < num_frames)
            {
              frame_score += frames[i+frames_ahead].get_pins_knocked(ball_pos);

              ball_pos++;
              if(ball_pos > frames[i+frames_ahead].get_num_balls())
              {
                ball_pos = 1;
                frames_ahead++;
              }

              balls_ahead++;
            }


          break;
          case frame::SPARE:
            frame_score += frames[i+1].get_pins_knocked(1);
          break;
        }
      }
      ret += frame_score;
    }

    score = ret;
  }
  else
    ret = score;

  return ret;
}

frame &bowling_game::get_frame(int id)
{
  if(id < 0 || id > 9)
    id = 0;

  return frames[id];
}

void bowling_game::ascii_line(char c, int num_chars)
{
  int i;

  for(i = 0; i < num_chars; i++)
    cout << c;
  cout << endl;
}
