/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : map.h
 *  Purpose: Map structs and stuff
 */

#ifndef __MAP_H__
#define __MAP_H__

#define M_PAPER		0	/* Paper stage */
#define M_DIRT		1	/* Dirt stage */
#define M_WASTE		2	/* Wasteland stage */

#define M_WIDTH		64
#define M_HEIGHT	48

#define DEC_ABOVE	0x0001
#define DEC_OBST	0x0002

#define GRT_MAGIC_NUMBER	0x44495247

/*
 * A wall segment, describing a line from x1,y1 to x2,y2
 */
typedef struct wall_seg
{
	int x1, y1;
	int x2, y2;
	struct wall_seg *next;
} WALL_SEG;
typedef struct deco
{
	int x, y;
	int flags;
	int gfx;	/* graphic offset counted from the first deco for this track type */
	struct deco *next;
} DECO;
/* The basic map structure */
typedef struct map
{
	char filename[80];
	char trackname[80];
	int type;			/* Track type */
	int start_x[4];		/* Start X */
	int start_y[4];		/* Start Y */
	int wall_color;		/* Wall colors */
	WALL_SEG *wall;		/* Wall segments */
	DECO *deco;			/* Decorations */
	WALL_SEG goal;

	struct map *next;	/* for build_track_list */
	struct map *prev;	/* for build_track_list */
} MAP;

extern MAP *c_stage;
extern int f_deco[];

MAP *create_map();
void free_map(MAP *map);
void wall_to_map(WALL_SEG *w, MAP *m);
void create_wall(MAP *m, int x1, int y1, int x2, int y2);
void remove_wall(MAP *m, WALL_SEG *w);
void draw_map(BITMAP *b, int xoffs, int yoffs, int show_hidden, int type);
MAP *open_map(char *fn);

#endif