/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : map.c
 *  Purpose: Map-handling routines
 */
#include <allegro.h>
#include <memory.h>
#include <string.h>
#include "player.h"
#include "misc.h"
#include "gamedata.h"
#include "map.h"
#include "settings.h"

/*
 * Creates a blank map
 */
MAP *create_map()
{
	MAP *map;

	map = malloc(sizeof(MAP));
	mzero(map, sizeof(MAP));

	return map;
}

/*
 * Free a map
 */
void free_map(MAP *map)
{
	WALL_SEG *w;

	if (!map)
		return;
	
	while (map->wall)
	{
		w = map->wall;
		map->wall = w->next;
		free(w);
	}
	free(map);
}

void wall_to_map(WALL_SEG *w, MAP *m)
{
	w->next = m->wall;
	m->wall = w;
}

void create_wall(MAP *m, int x1, int y1, int x2, int y2)
{
	WALL_SEG *w;
	
	w = malloc(sizeof(WALL_SEG));
	w->x1 = x1;
	w->y1 = y1;
	w->x2 = x2;
	w->y2 = y2;
	wall_to_map(w, m);
}

void set_goal(MAP *m, int x1, int y1, int x2, int y2)
{
	m->goal.x1 = x1;
	m->goal.y1 = y1;
	m->goal.x2 = x2;
	m->goal.y2 = y2;
}

void remove_wall(MAP *m, WALL_SEG *w)
{
	WALL_SEG *tmp;

	if (m->wall == w)
		m->wall = w->next;
	else
	{
		for (tmp = m->wall; (tmp) && (tmp->next != w); tmp = tmp->next);
		if (tmp)
			tmp->next = w->next;
	}
	free(w);
}

MAP *open_map(char *fn)
{
	PACKFILE *fp;
	int x1, y1, x2, y2;
	MAP *stg;

	fp = pack_fopen(fn, "r");
	if (!fp)
		return 0;

	stg = create_map();
	strcpy(stg->filename, fn);

	x1 = pack_igetl(fp);
	if (x1 != GRT_MAGIC_NUMBER)
	{
		pack_fclose(fp);
		return 0;
	}
	pack_fread(stg->trackname, 80, fp);
	stg->type = pack_igetl(fp);
	stg->wall_color = pack_igetl(fp);
	while (1)
	{
		x1 = pack_igetl(fp);
		if (x1 == -1)
			break;
		else
		{
			y1 = pack_igetl(fp);
			x2 = pack_igetl(fp);
			y2 = pack_igetl(fp);
			create_wall(stg, x1, y1, x2, y2);
		}
	}

	stg->start_x[0] = pack_igetl(fp);
	stg->start_y[0] = pack_igetl(fp);
	stg->start_x[1] = pack_igetl(fp);
	stg->start_y[1] = pack_igetl(fp);
	stg->start_x[2] = pack_igetl(fp);
	stg->start_y[2] = pack_igetl(fp);
	stg->start_x[3] = pack_igetl(fp);
	stg->start_y[3] = pack_igetl(fp);
	stg->goal.x1 = pack_igetl(fp);
	stg->goal.x2 = pack_igetl(fp);
	stg->goal.y1 = pack_igetl(fp);
	stg->goal.y2 = pack_igetl(fp);

	pack_fclose(fp);

	return stg;
}



/*
 * Draws the map onto b, starting at xoffs, yoffs
 * of the map. This is using flat coordinates, not orthographic.
 * Also, _pixel_ coordinates, not tile.
 * show_hidden controls whether hidden stuff should be displayed
 */
void draw_map(BITMAP *b, int xoffs, int yoffs, int show_hidden, int type)
{
	int x, y;
	int x2, y2;
	WALL_SEG *tmp;
	int i;
	BITMAP *tile;

	if (type ==M_DIRT)
		tile = game_data[TILE_DIRT].dat;
	else
		tile = game_data[TILE_PAPER].dat;

	for (x = -2; x < (b->w / 64) + 2; x++)
	{
		for (y = -2; y < (b->h / 64) + 2; y++)
		{
			blit(tile, d_buf, 0, 0, x*64-xoffs%64, y*64-yoffs%64+32, 32, 64);
			blit(tile, d_buf, 0, 0, x*64+32-xoffs%64, y*64-yoffs%64+64, 32, 64);
		}
	}
/*
	for (x = 0; x < M_WIDTH; x++)
	{
		for (y = 0; y < M_HEIGHT; y++)
		{
			x2 = (32 * M_HEIGHT) + (x * 32) - (y * 32);
			y2 = (y * 32) + (x * 32);
			if ((x2-xoffs >= 0) && (x2-xoffs <= SCREEN_W) && (y2-yoffs >= 0) && (y2-yoffs <= SCREEN_H))
			{
				aacircle(d_buf, x2 - xoffs, y2 - yoffs, 3, makecol(255,0,0));
				textprintf_centre(d_buf, font, x2-xoffs, y2+4-yoffs, makecol(255,0,0), "%d;%d", x, y);
			}
		}
	}
*/
	for (tmp = c_stage->wall; tmp; tmp = tmp->next)
	{
		draw_wall(d_buf, tmp, xoffs, yoffs, c_stage->wall_color);

		if (show_hidden)
		{
			aacircle(d_buf, x-xoffs, y-yoffs, 2, makecol(0,128,255));

			// ????
			//aacircle(d_buf, x2-xoffs, y2-yoffs, 2, c_stage->wall_color);
		}
	}
	draw_wall(d_buf, &c_stage->goal, xoffs, yoffs, makecol(255,0,255));

	if (show_hidden)
	{
		for (i = 0; i < 4; i++)
		{
			if (c_stage->start_x[i] > 0)
			{
				x = (32 * M_HEIGHT) + (c_stage->start_x[i] * 32) - (c_stage->start_y[i] * 32) - xoffs;
				y = (c_stage->start_y[i] * 32) + (c_stage->start_x[i] * 32) - yoffs;
				aacircle(d_buf, x, y, 16, player_color[i]);
				aaline(d_buf, x-24, y-24, x-4, y-4, player_color[i]);
				aaline(d_buf, x+24, y-24, x+4, y-4, player_color[i]);
				aaline(d_buf, x-24, y+24, x-4, y+4, player_color[i]);
				aaline(d_buf, x+24, y+24, x+4, y+4, player_color[i]);
			}
		}
	}
	aaline(d_buf, M_HEIGHT*32-xoffs, 64-yoffs, 64-xoffs, M_HEIGHT*32-yoffs, makecol(255,0,0));
	aaline(d_buf, 64-xoffs, M_HEIGHT*32-yoffs, (M_WIDTH-1)*32+32-xoffs, (M_HEIGHT-1)*32+(M_WIDTH-1)*32-yoffs, makecol(255,0,0));
	aaline(d_buf, M_HEIGHT*32-xoffs, 64-yoffs, M_HEIGHT*32+(M_WIDTH-1)*32-32-xoffs, (M_WIDTH-1)*32+32-yoffs, makecol(255,0,0));
	aaline(d_buf, M_HEIGHT*32+(M_WIDTH-1)*32-32-xoffs, (M_WIDTH-1)*32+32-yoffs, (M_WIDTH-1)*32+32-xoffs, (M_HEIGHT-1)*32+(M_WIDTH-1)*32-yoffs, makecol(255,0,0));
}
