/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : main.c
 *  Purpose: Initialization, entry point
 */
#include <allegro.h>
#include <time.h>
#include "misc.h"
#include "gamedata.h"
#include "settings.h"
#include "map.h"
#include "menu.h"
#include "player.h"

/* Timer stuff. */
volatile int g_time;
void g_time_func(void)
{
	g_time++;
}
END_OF_FUNCTION(g_time_func);
volatile int fps_time;
void fps_time_func(void)
{
	fps_time = 1;
}
END_OF_FUNCTION(fps_time_func);


/* Some prototyping.. */
void game();
void track_editor();
void generic_menu(GR_MENU *menu);

/* Set up Allegro */
void initialize_allegro()
{
	srand(time(0));

	if (allegro_init() != 0)
	{
		allegro_message("Failed to initialize Allegro");
		exit(-1);
	}
	if (install_keyboard() != 0)
	{
		allegro_message("Failed to set up keyboard");
		exit(-1);
	}
	if (!install_mouse())
	{
		allegro_message("Failed to set up mouse");
		exit(-1);
	}

	LOCK_VARIABLE(g_time);
	LOCK_FUNCTION(g_time_func);
	if (install_timer() != 0)
	{
		allegro_message("Failed to set up timer");
		exit(-1);
	}
	install_int_ex(g_time_func, BPS_TO_TIMER(60));
	install_int_ex(fps_time_func, MSEC_TO_TIMER(1000));
	
	/* Set up 640x480x16 */
	set_color_depth(16);
	if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0)
	{
		allegro_message("Failed to set graphics mode");
		exit(-1);
	}

	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, 0) < 0)
	{
		disable_sound = 1;
	}

	d_buf = create_bitmap(SCREEN_W, SCREEN_H);
	clear(d_buf);

	game_data = load_datafile("griddata.dat");
	set_palette(game_data[FONT_PALETTE].dat);

	set_config_file("gridrace.cfg");
	set_language(get_config_int("Language", "Selected", LANG_ENGLISH));

	text_mode(-1);

	player_color[0] = makecol(255,0,0);
	player_color[1] = makecol(0,255,0);
	player_color[2] = makecol(0,0,255);
	player_color[3] = makecol(255,0,255);
}


void fame()
{
	static GR_MENU mmen;
	static GR_MENU_ITEM mmen_items[] =
	{
		{ "J.R.R Tolkien",		0, 1 },
		{ "J.S. Bach",				0, 1 },
		{ "Walt Disney",			0, 1 },
		{ "Michael Jackson",	0, 1 },
		{ "You (some day)",	0, 1 }
	};

	mmen.width = 230;
	mmen.entries = 5;
	mmen.item = mmen_items;
	generic_menu(&mmen);
}


// Ugly hack...
void hot_seat2()
{
	players = 2;
	new_game(G_HOT_SEAT);
}
void hot_seat3()
{
	players = 3;
	new_game(G_HOT_SEAT);
}
void hot_seat4()
{
	players = 4;
	new_game(G_HOT_SEAT);
}

void num_players_menu()
{
	static GR_MENU mmenu;
	static GR_MENU_ITEM mmenu_items[] =
	{
		{ "Two Players",		hot_seat2, 0 },
		{ "Three Players",		hot_seat3, 0 },
		{ "Four Players",			hot_seat4, 0 },
		{ "Return",				0, 1 }
	};

	mmenu.width = 230;
	mmenu.entries = 4;
	mmenu.item = mmenu_items;
	generic_menu(&mmenu);
}

void time_attack()
{
	new_game(G_TIME_ATTACK);
}
void new_game_menu()
{
	static GR_MENU mmenu;
	static GR_MENU_ITEM mmenu_items[] =
	{
		{ "Practise",		time_attack, 0 },
		{ "Hot Seat",			num_players_menu, 0 },
		{ "Return",				0, 1 }
	};

	mmenu.width = 230;
	mmenu.entries = 3;
	mmenu.item = mmenu_items;
	generic_menu(&mmenu);
}


char leet_string[40];

void sound_onoff()
{
	if (disable_sound) {
		disable_sound = 0;
		play_bgm(MUSIC_THEME, 1);
	}else{
		disable_sound = 1;
		stop_midi();
	}
}
void sound_opt_menu()
{
	static GR_MENU mmenu;
	static GR_MENU_ITEM mmenu_items[] =
	{
		{ "Sound On/Off",		sound_onoff, 0 },
		{ "Return",				0, 1 }
	};

	mmenu.width = 270;
	mmenu.entries = 2;
	mmenu.item = mmenu_items;
	generic_menu(&mmenu);
}

void change_lang()
{
	if (options.language == LANG_ENGLISH)
		set_language(LANG_LEET);
	else if (options.language == LANG_LEET)
		set_language(LANG_JAPAN);
	else if (options.language == LANG_JAPAN)
		set_language(LANG_EGYPT);
	else
		set_language(LANG_ENGLISH);
}
void lang_opt_menu()
{
	static GR_MENU mmenu;
	static GR_MENU_ITEM mmenu_items[] =
	{
		{ "",					change_lang, 0 },
		{ "Return",				0, 1 }
	};

	mmenu.width = 290;
	mmenu.entries = 2;
	mmenu.item = mmenu_items;
	mmenu.item[0].text = leet_string;
	generic_menu(&mmenu);
}
void pref_menu()
{
	static GR_MENU mmenu;
	static GR_MENU_ITEM mmenu_items[] =
	{
		{ "Language Options",	lang_opt_menu, 0 },
		{ "Sound Options",		sound_opt_menu, 0 },
		{ "Return",				0, 1 }
	};

	mmenu.width = 270;
	mmenu.entries = 3;
	mmenu.item = mmenu_items;
	generic_menu(&mmenu);
}
void main_menu()
{
	static GR_MENU mmenu;
	static GR_MENU_ITEM mmenu_items[] =
	{
		{ "New Game",		new_game_menu, 0 },
		{ "Preferences",	pref_menu, 0 },
		{ "Hall of Fame",	fame, 0 },
		{ "Track Editor",	track_editor, 0 },
		{ "Quit",			0, 1 }
	};

	mmenu.width = 230;
	mmenu.entries = 5;
	mmenu.item = mmenu_items;
	generic_menu(&mmenu);
}

void save_config()
{
	set_config_int("Language", "Selected", options.language);
}

char *intro_text[] =
{
	"It is the year 21XX A.D.",
	"",
	"A nuclear war between evil monopolistic",
	"companies has raged across the surface of",
	"the planet, incinerating the soil and scorching",
	"the earth, leaving nearly nothing but barren",
	"wastelands.",
	"",
	"However...",
	"",
	"One island, hidden deep in the middle of the",
	"Pacific Ocean, survived the cataclysm.",
	"",
	"Now, in a harsh future, people battle for",
	"survival every day, eternally struggling.",
	"This war isn't fought with steel. This",
	"battlefield isn't a toxic radzone. No..",
	"",
	"This battle is fought on grid paper.",
	"",
	"Welcome to a grim future, where there is only",
	"GRID RACERS !",
	"",
	"",
	"... and a mysterious dog in a black hat",
	"  named Poop.",
	0
};

#define HAVE_A_WAIT(_d)	\
	t = _d;	\
	while (t > 0) { if (key[KEY_ESC]) return; while (g_time > 0) { g_time--; t--; } }

void intro()
{
	int t, q, i, r, e;

	clear(d_buf);
	copy_buf();

	HAVE_A_WAIT(100);
	play_bgm(MUSIC_DIRT, 1);

	clear(d_buf);
	blit(game_data[NECLOGO].dat, d_buf, 0, 0, 250, 50, 152, 61);
	copy_buf();
	HAVE_A_WAIT(90);
	textout_centre(d_buf, c_font, "and", 320, 210, -1);
	copy_buf();
	HAVE_A_WAIT(90);
	blit(game_data[TRUMLOGO].dat, d_buf, 0, 0, 250, 310, 152, 60);
	copy_buf();
	HAVE_A_WAIT(240);
	clear(d_buf);
	textout_centre(d_buf, c_font, "somewhat proudly", 320, 210, -1);
	textout_centre(d_buf, c_font, "present", 320, 240, -1);
	copy_buf();
	HAVE_A_WAIT(240);
	clear(d_buf);
	blit(game_data[IDEAHACK].dat, d_buf, 0, 0, 160, 110, 320, 197);
	textout_centre(d_buf, c_font, "Entry : Team 1337", 320, 340, -1);
	copy_buf();
	HAVE_A_WAIT(240);

	
	for (i = 0;intro_text[i] != 0;i++);
	e = i;
	q = 0;
	r = 1;
	while (1)
	{
		if (r)
		{
			r = 0;
			blit(game_data[INTRO].dat, d_buf, 0, 0, 0, 0, 640, 480);
			for (i = 0;intro_text[i] != 0;i++)
			{
				textout_centre(d_buf, c_font, intro_text[i], 320, 520-q/3+i*30, -1);
			}
			copy_buf();
		}
		while (g_time > 0)
		{
			g_time--;
			q++;
			r = 1;
		}
		if (key[KEY_ESC])
			return;
		if (q/3 >= e*30+540)
			break;
	}
	stop_midi();
	HAVE_A_WAIT(220);
	clear(d_buf);
	copy_buf();	
}

int main(int argc, char **argv)
{
	initialize_allegro();

	intro();

	play_bgm(MUSIC_THEME, 1);
	main_menu();

	save_config();

	return 1;
}
END_OF_MAIN();
