/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : gfx.c
 *  Purpose: Some graphics routines
 */
#include <allegro.h>
#include "gamedata.h"
#include "player.h"

extern VEHICLE vehicle[];

/* blatantly stolen from colblend.c */
int blend16(int x, int y)
{
   unsigned long result;

   x = ((x & 0xFFFF) | (x << 16)) & 0x7E0F81F;
   y = ((y & 0xFFFF) | (y << 16)) & 0x7E0F81F;

   result = ((x - y) * 12 / 32 + y) & 0x7E0F81F;

   return ((result & 0xFFFF) | (result >> 16));
}
void aaputpixel(BITMAP *b, int x, int y, int d)
{
	putpixel(b,x,y,d);
	putpixel(b,x+1,y,blend16(d, getpixel(b,x+1,y)));
	putpixel(b,x-1,y,blend16(d, getpixel(b,x-1,y)));
	putpixel(b,x,y+1,blend16(d, getpixel(b,x,y+1)));
	putpixel(b,x,y-1,blend16(d, getpixel(b,x,y-1)));
}

/* Fake anti-alias line */
void aaline(BITMAP *b, int x1, int y1, int x2, int y2, int d)
{
	acquire_bitmap(b);
	do_line(b, x1, y1, x2, y2, d, aaputpixel);
	release_bitmap(b);
}
/* Fake anti-alias circle */
void aacircle(BITMAP *b, int x1, int y1, int r, int d)
{
	acquire_bitmap(b);
	do_circle(b, x1, y1, r, d, aaputpixel);
	release_bitmap(b);
}

void draw_wall(BITMAP *b, WALL_SEG *tmp, int xoffs, int yoffs, int c)
{
	int x, y, x2, y2;

	/* Get flat coords from orthographic */
	x = (32 * M_HEIGHT) + (tmp->x1 * 32) - (tmp->y1 * 32);
	y = (tmp->y1 * 32) + (tmp->x1 * 32);
	x2 = (32 * M_HEIGHT) + (tmp->x2 * 32) - (tmp->y2 * 32);
	y2 = (tmp->y2 * 32) + (tmp->x2 * 32);

	aaline(b, x - xoffs, y - yoffs, x2 - xoffs, y2 - yoffs, c);
}

/* *
* FOOOOOOOBAR!
*/
void darken(BITMAP *b, int x1, int y1, int x2, int y2)
{
	int x, y, c, d;

	acquire_bitmap(b);
	for (x = x1; x <= x2; x++)
	{
		for (y = y1; y <= y2; y++)
		{
			c = _getpixel16(b, x, y);
			//d = (((c & 0x7E0F81F) >> 1) & 0x7E0F81F) | ((c &
			d = (c & 0x1F7BE) >> 1;
			_putpixel16(b,x,y,d);
		}
	}
	release_bitmap(b);
}

void draw_vehicle(BITMAP *b, int v, int frame, int x, int y)
{
	int sx, sy;
	BITMAP *s = game_data[vehicle[v].gfx].dat;

	sx = (frame * 64) % s->w;
	sy = ((frame * 64) / s->w) * 96;
	masked_blit(s, b, sx, sy, x, y, 64, 96);
}