/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : settings.c
 *  Purpose: Dealing with preferences
 */
#include <allegro.h>
#include <string.h>
#include "settings.h"
#include "gamedata.h"

SETTINGS options;	/* Store options. */
FONT *c_font;		/* quick pointer access for currently selected language */
BITMAP *title_text;	/* quick pointer access to title text for selected language */
BITMAP *title_bg;	/* you get the idea. */
int player_color[4];	/* Player colors */

extern char leet_string[40];

void set_language(int lang)
{
	if (lang == LANG_LEET)
	{
		c_font = D_FONT_LEET;
		title_text = game_data[TITLE_TEXT_LEET].dat;
		title_bg = game_data[TITLE_BG_LEET].dat;
		options.language = LANG_LEET;
		strcpy(leet_string, "Language: Leet");
	}
	else if (lang == LANG_ENGLISH)
	{
		c_font = D_FONT_ENGLISH;
		title_text = game_data[TITLE_TEXT].dat;
		title_bg = game_data[TITLE_BG].dat;
		options.language = LANG_ENGLISH;
		strcpy(leet_string, "Language: English");
	}
	else if (lang == LANG_JAPAN)
	{
		c_font = D_FONT_JAPAN;
		title_text = game_data[TITLE_TEXT_JAPAN].dat;
		title_bg = game_data[TITLE_BG_JAPAN].dat;
		options.language = LANG_JAPAN;
		strcpy(leet_string, "Language: Japanese");
	}
	else if (lang == LANG_EGYPT)
	{
		c_font = D_FONT_EGYPT;
		title_text = game_data[TITLE_TEXT_EGYPT].dat;
		title_bg = game_data[TITLE_BG_EGYPT].dat;
		options.language = LANG_EGYPT;
		strcpy(leet_string, "Language: Egyptian");
	}
}