/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : misc.h
 *  Purpose: Misc stuff that needed to go somewhere
 */

#ifndef __MISC_H__
#define __MISC_H__

#include <allegro.h>
#include "map.h"

#define G_TIME_ATTACK	0
#define G_HOT_SEAT		1

extern BITMAP *d_buf;
extern volatile int g_time;

void aaputpixel(BITMAP *b, int x, int y, int d);
void aaline(BITMAP *b, int x1, int y1, int x2, int y2, int d);
void aacircle(BITMAP *b, int x1, int y1, int r, int d);
void darken(BITMAP *b, int x1, int y1, int x2, int y2);
void draw_wall(BITMAP *b, WALL_SEG *tmp, int xoffs, int yoffs, int c);
void draw_vehicle(BITMAP *b, int v, int frame, int x, int y);

void center_on(int x, int y, int *vx, int *vy);
void new_game(int type);

void play_se(int se);
void play_bgm(int bgm, int loop);

/* Helpful little macros. */
#define copy_buf()	blit(d_buf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H)
#define mzero(a,b)	memset(a, 0, b)

#endif