/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : menu.c
 *  Purpose: Generic menu system
 */
#include <allegro.h>
#include "menu.h"
#include "misc.h"
#include "gamedata.h"
#include "settings.h"
#include "map.h"
#include "player.h"

extern PLAYER player[4];
extern DRIVER driver[];
extern VEHICLE vehicle[];
extern char *tt_name[];

MAP *track_list;

int scanch = 0;
int last_mouse_b = 0;

void generic_menu(GR_MENU *menu)
{
	int redraw = 1;
	int end_loop = 0;
	int i;

	last_mouse_b = mouse_b;
	while (!end_loop)
	{
		if (redraw)
		{
			drawing_mode(DRAW_MODE_COPY_PATTERN, title_bg, scanch, scanch);
			rectfill(d_buf, 0, 0, d_buf->w, d_buf->h, 0);
			solid_mode();
			masked_blit(game_data[TITLE_FLAG].dat, d_buf, 0, 0, 90, 10, 364, 459);
			masked_blit(title_text, d_buf, 0, 0, 205, 54, title_text->w, title_text->h);

			set_trans_blender(0,0,0,128);
			drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
			rectfill(d_buf, 260, 250, 260+menu->width, 250+menu->entries*25+20, 0);

			for (i = 0;i < menu->entries;i++)
			{
				if ((mouse_x >= 270) && (mouse_x <= 270+menu->width-20) && (mouse_y >= 260+i*25) && (mouse_y <= 279+i*25))
						rectfill(d_buf, 270, 260+i*25, 270+menu->width-20, 284+i*25, makecol(0,128,255));
			}

			solid_mode();

			rect(d_buf, 260, 250, 260+menu->width, 250+menu->entries*25+20, makecol(128,128,128));
			for (i = 0;i < menu->entries;i++)
			{
				textout(d_buf, c_font, menu->item[i].text, 280, 260+i*25, -1);
			}

			draw_rle_sprite(d_buf, game_data[MOUSE_POINT].dat, mouse_x, mouse_y);

			copy_buf();

			redraw = 0;
		}
		while (g_time > 0)
		{
			g_time--;
			redraw = 1;
			if ((mouse_b & 1) && !(last_mouse_b & 1))
			{
				for (i = 0;i < menu->entries;i++)
				{
					if ((mouse_x >= 270) && (mouse_x <= 270+menu->width-20) && (mouse_y >= 260+i*25) && (mouse_y <= 279+i*25))
					{
						play_se(SAMPLE_BZZT_2);
						if (menu->item[i].exit)
							end_loop = 1;
						if (menu->item[i].func) {
							menu->item[i].func();
							last_mouse_b = mouse_b;
							break;
						}
					}
				}
			}
			last_mouse_b = mouse_b;
			scanch++;
		}
		yield_timeslice();
	}
}


int choose_driver(int plr, int *used)
{
	int redraw = 1;
	int end_loop = 0;
	int i;

	last_mouse_b = mouse_b;
	player[plr].driver = 0;
	while (used[player[plr].driver]) player[plr].driver++;
	while (!end_loop)
	{
		if (redraw)
		{
			drawing_mode(DRAW_MODE_COPY_PATTERN, title_bg, scanch, scanch);
			rectfill(d_buf, 0, 0, d_buf->w, d_buf->h, 0);
			solid_mode();

			textprintf(d_buf, c_font, 10, 10, -1, "Player %d : Select driver", plr+1);

			drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
			set_trans_blender(0,0,0,128);
			for (i = 0; i < 5; i++)
			{
				if (!used[i])
					if ((mouse_x >= 60) && (mouse_x <= 124) && (mouse_y >= 60+i*80) && (mouse_y <= 124+i*80))
						rectfill(d_buf, 55, 55+i*80, 129, 129+i*80, makecol(0,128,255));
			}
			if ((mouse_x >= 160) && (mouse_x <= 280) && (mouse_y >= 420) && (mouse_y <= 445))
				rectfill(d_buf, 155, 415, 285, 450, makecol(0,128,255));
			if ((mouse_x >= 420) && (mouse_x <= 540) && (mouse_y >= 420) && (mouse_y <= 445))
				rectfill(d_buf, 415, 415, 545, 450, makecol(0,128,255));
			solid_mode();

			//darken(d_buf, 150, 60, 620, 410);
			rectfill(d_buf, 150, 60, 620, 410, makecol(32,32,32));
			rect(d_buf, 150, 60, 620, 410, makecol(128,128,128));
			rect(d_buf, 170, 290, 600, 390, makecol(128,128,128));
			
			draw_sprite(d_buf, game_data[driver[player[plr].driver].portrait].dat, 170, 80);
			rect(d_buf, 160, 70, 244, 154, makecol(128,128,128));
			textprintf(d_buf, c_font, 260, 80, -1, "Name : %s", driver[player[plr].driver].name);
			textout(d_buf, c_font, "Quote:", 160, 160, -1);
			textout(d_buf, c_font, driver[player[plr].driver].quote, 160, 190, -1 );
			textout(d_buf, c_font, driver[player[plr].driver].quote2, 160, 220, -1 );
			textout(d_buf, c_font, "Vehicle:", 160, 260, -1);
			textout(d_buf, c_font, vehicle[driver[player[plr].driver].vehicle].name, 360, 320, -1);

			textout(d_buf, c_font, "<< Cancel", 160, 420, -1);
			textout(d_buf, c_font, "Next >>", 420, 420, -1);

			draw_vehicle(d_buf, driver[player[plr].driver].vehicle, 6, 230, 280);

			set_trans_blender(0,0,0,0);
			for (i = 0; i < 5; i++)
			{
				if (player[plr].driver == i)
					draw_sprite(d_buf, game_data[driver[i].portrait].dat, 60, 60+i*80);
				else if (!used[i])
				//	draw_lit_sprite(d_buf, game_data[driver[i].portrait].dat, 60, 60+i*80, 64);
				// else
					draw_lit_sprite(d_buf, game_data[driver[i].portrait].dat, 60, 60+i*80, 128);
			}

			draw_rle_sprite(d_buf, game_data[MOUSE_POINT].dat, mouse_x, mouse_y);

			copy_buf();

			redraw = 0;
		}
		while (g_time > 0)
		{
			g_time--;
			redraw = 1;

			if ((mouse_b & 1) && !(last_mouse_b & 1))
			{
				for (i = 0; i < 5; i++)
				{
					if ((mouse_x >= 60) && (mouse_x <= 124) && (mouse_y >= 60+i*80) && (mouse_y <= 124+i*80))
					{
						if (!used[i]) {
							play_se(SAMPLE_BZZT_2);
							player[plr].driver = i;
							break;
						}
					}
				}
				if ((mouse_x >= 160) && (mouse_x <= 300) && (mouse_y >= 420) && (mouse_y <= 445))
				{
					play_se(SAMPLE_BZZT_2);
					return 0;
				}
				if ((mouse_x >= 420) && (mouse_x <= 540) && (mouse_y >= 420) && (mouse_y <= 445))
				{
					used[player[plr].driver]=1;
					play_se(SAMPLE_BZZT_2);
					return 1;
				}
			}

			last_mouse_b = mouse_b;
			scanch++;
		}
		yield_timeslice();
	}
	return 0;
}

void track_callback(const char *fn, int attr, int param)
{
	MAP *stg;

	stg = open_map((char*)fn);	/* const.. feh :P */
	if (stg)
	{
		stg->next = track_list;
		if (track_list)
			track_list->prev = stg;
		track_list = stg;
	}
}
void build_track_list()
{
	track_list = 0;
	for_each_file("*.grt", 0, track_callback, 0);
}
void discard_tracks()
{
	MAP *stg, *nxt;

	for (stg = track_list; stg; stg = nxt)
	{
		nxt = stg->next;
		if (stg != c_stage)
			free_map(stg);
	}
}

/*
 * Draw a preview of c_stage
 */
void draw_preview(BITMAP *b, int x, int y)
{
	WALL_SEG *w;
	int a, g;

	if (c_stage->type == M_PAPER)
	{
		rectfill(b, x, y, x+M_WIDTH*5, y+M_HEIGHT*5, makecol(255,255,255));
		g = makecol(128,128,128);
	}
	else if (c_stage->type == M_DIRT)
	{
		rectfill(b, x, y, x+M_WIDTH*5, y+M_HEIGHT*5, makecol(64,64,64));
		g = makecol(0,0,0);
	}

	for (a = 0; a <= M_WIDTH; a++)
		vline(b, x+a*5, y, y+M_HEIGHT*5, g);
	for (a = 0; a <= M_HEIGHT; a++)
		hline(b, x, y+a*5, x+M_WIDTH*5, g);
			

	for (w = c_stage->wall; w; w = w->next)
	{
		aaline(b, x+w->x1*5, y+w->y1*5, x+w->x2*5, y+w->y2*5, makecol(255,0,0));
	}
	for (a=0;a<4;a++)
		aacircle(b, x+c_stage->start_x[a]*5, y+c_stage->start_y[a]*5, 2, player_color[a]);

	rect(b, x-5, y-5, x+M_WIDTH*5+5, y+M_HEIGHT*5+5, makecol(255,255,255));
}

int choose_track()
{
	int redraw = 1;
	int end_loop = 0;

	/* Build a list of tracks */
	build_track_list();

	c_stage = track_list;

	last_mouse_b = mouse_b;
	while (!end_loop)
	{
		if (redraw)
		{
			drawing_mode(DRAW_MODE_COPY_PATTERN, title_bg, scanch, scanch);
			rectfill(d_buf, 0, 0, d_buf->w, d_buf->h, 0);
			solid_mode();

			textout(d_buf, c_font, "Select Track", 10, 10, -1);

			drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
			set_trans_blender(0,0,0,128);

			if ((mouse_x >= 160) && (mouse_x <= 280) && (mouse_y >= 420) && (mouse_y <= 445))
				rectfill(d_buf, 155, 415, 285, 450, makecol(0,128,255));
			if ((mouse_x >= 420) && (mouse_x <= 540) && (mouse_y >= 420) && (mouse_y <= 445))
				rectfill(d_buf, 415, 415, 545, 450, makecol(0,128,255));

			if ((mouse_x >= 60) && (mouse_x <= 92) && (mouse_y >= 60) && (mouse_y <= 92) && (c_stage->prev))
				rectfill(d_buf, 55, 55, 97, 97, makecol(0,128,255));
			if ((mouse_x >= 580) && (mouse_x <= 612) && (mouse_y >= 60) && (mouse_y <= 92) && (c_stage->next))
				rectfill(d_buf, 575, 55, 617, 97, makecol(0,128,255));
			solid_mode();

			if (!c_stage)
			{
				textout_centre(d_buf, c_font, "No tracks found!", 320, 160, -1);
			}
			else
			{
				if (*(c_stage->trackname) != '\0')
					textout_centre(d_buf, c_font, c_stage->trackname, 320, 60, -1);
				else
					textout_centre(d_buf, c_font, c_stage->filename, 320, 60, -1);

				textout(d_buf, c_font, "Type:", 400, 120, -1);
				textout(d_buf, c_font, tt_name[c_stage->type], 430, 150, -1);
				draw_preview(d_buf, 60, 120);
			}

			masked_blit(game_data[ARROWS].dat, d_buf, 0, 0, 60, 60, 32, 32);
			masked_blit(game_data[ARROWS].dat, d_buf, 32, 0, 580, 60, 32, 32);

			textout(d_buf, c_font, "<< Cancel", 160, 420, -1);
			textout(d_buf, c_font, "Next >>", 420, 420, -1);

			draw_rle_sprite(d_buf, game_data[MOUSE_POINT].dat, mouse_x, mouse_y);

			copy_buf();

			redraw = 0;
		}
		while (g_time > 0)
		{
			g_time--;
			redraw = 1;

			if ((mouse_b & 1) && !(last_mouse_b & 1))
			{
				if ((mouse_x >= 160) && (mouse_x <= 300) && (mouse_y >= 420) && (mouse_y <= 445))
				{
					play_se(SAMPLE_BZZT_2);
					c_stage = 0;
					discard_tracks();
					return 0;
				}
				if ((mouse_x >= 420) && (mouse_x <= 540) && (mouse_y >= 420) && (mouse_y <= 445))
				{
					play_se(SAMPLE_BZZT_2);
					discard_tracks();
					return 1;
				}
				if ((mouse_x >= 60) && (mouse_x <= 92) && (mouse_y >= 60) && (mouse_y <= 92) && (c_stage->prev))
				{
					play_se(SAMPLE_BZZT_2);
					c_stage = c_stage->prev;
				}
				if ((mouse_x >= 580) && (mouse_x <= 612) && (mouse_y >= 60) && (mouse_y <= 92) && (c_stage->next))
				{
					play_se(SAMPLE_BZZT_2);
					c_stage = c_stage->next;
				}
			}

			last_mouse_b = mouse_b;
			scanch++;
		}
		yield_timeslice();
	}
	return 0;
}


