/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : game.c
 *  Purpose: All the excitement!
 */
#include <allegro.h>
#include <stdio.h>

#include "player.h"
#include "misc.h"
#include "gamedata.h"
#include "settings.h"
#include "map.h"
#include "menu.h"

/* Global double buffer */
BITMAP *d_buf;
/* Datafile */
DATAFILE *game_data;
/* The current map */
MAP *c_stage;

int game_type;
// int players;
PLAYER player[4];

/* Default drivers to choose from */
DRIVER driver[] =
{
	{ "X-G",			"\"For great justice!\"", "",								3, PORTRAIT_3 },
	{ "Trumgottist",	"\"Keyboard not found.", "Press F1 to continue.\"",	4, PORTRAIT_5 },
	{ "Ook",			"\"Holy peice of carp on a stick!\"","",					2, PORTRAIT_2 },
	{ "X-Viila",		"\"Ave atque vale!\"","",									1, PORTRAIT_4 },
	{ "Bdavis",			"\"Now my balls are bouncing all", "over the room!\"",		0, PORTRAIT_6 }
};

VEHICLE vehicle[] =
{
	{ "Tractor",		VEHICLE_1 },
	{ "Race Car",		VEHICLE_2 },
	{ "Pacmobile",		VEHICLE_3 },
	{ "'ZIG' Fighter",	VEHICLE_4 },
	{ "Bluesmobile",	VEHICLE_5 }
};


void game();



/* This game brought to you in SquirrelVision */
void squirrel_vision(BITMAP *b)
{
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,  0,  0, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,  0,130, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,  0,260, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,  0,400, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,590,  0, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,590,130, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,590,260, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,590,400, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,200,400, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,400,400, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,200,  0, 50, 72);
	masked_blit(game_data[SQUIRREL].dat, b, 0, 0,400,  0, 50, 72);
}


void center_on(int x, int y, int *vx, int *vy)
{
	*vx = (M_HEIGHT * 32) + (x * 32) - (y * 32) - SCREEN_W/2;
	*vy = (y * 32) + (x * 32) - SCREEN_H/2;
}

void start_game()
{
	int i;

	for (i = 0; i < players; i++)
	{
		player[i].car_x = c_stage->start_x[i];
		player[i].car_y = c_stage->start_y[i];
		player[i].vel_x = 0;
		player[i].vel_y = 0;
		player[i].dir = 2;
	}
	game();
}

void new_game(int type)
{
	int step = 0;
	int p = 0;
	int used[5],i;

	for (i = 0; i < 5; i++) used[i]=0;
	while (step >= 0)
	{
		if (step == 0)
		{
			if (type == G_HOT_SEAT)
			{
				while ((p >= 0) && (p < players))
				{
					if (!choose_driver(p, used)) {
						p--;
						used[player[p].driver]=0;
					} else
						p++;
				}
				if (p < 0)
					step-=2;
			}
			else
			{
				players = 1;
				if (!choose_driver(0, used))
					step-=2;
			}
		}
		else if (step == 1)
		{
			if (!choose_track())
				step-=2;
		}
		else if (step == 2)
		{
			game_type = type;
			switch (c_stage->type) {
			case M_PAPER: play_bgm(MUSIC_PAPER, 1); break;
			case M_DIRT: play_bgm(MUSIC_DIRT, 1); break;
			}
			start_game();
			free_map(c_stage);
			play_bgm(MUSIC_THEME, 1);
			return;
		}
		step++;
	}
}

/* Dodgy Hacks 'R' Us :p */
#define PS 7
void player_summary(BITMAP *b, int x, int y, int pl, int current)
{
	rectfill(b, x, y, x+130, y+210, makecol(32,32,32));

	rect(b, x, y, x+130, y+210, makecol(128,128,128));
	if (current)
	{
		rect(b, x-1, y-1, x+131, y+211, player_color[pl]);
		rect(b, x+1, y+1, x+129, y+209, player_color[pl]);
	}
	textout(d_buf, c_font, driver[player[pl].driver].name, x+10, y+10, -1);
	rect(d_buf, x+5, y+35, x+128, y+130, makecol(128,128,128));
	rect(d_buf, x+7, y+63, x+42, y+98, makecol(128,128,128));
	stretch_blit(game_data[driver[player[pl].driver].portrait].dat, d_buf, 0, 0, 64, 64, x+9, y+65, 32, 32);
	draw_vehicle(d_buf, driver[player[pl].driver].vehicle, player[pl].dir, x+50, y+20);
	aacircle(b, x + 65, y + 160, 4, player_color[pl]);
	aaputpixel(b, x + 65, y + 160, player_color[pl]);
	if (player[pl].vel_x != 0)
	{
		aaline(b, x+65, y+160, x+65+player[pl].vel_x*PS, y+160+player[pl].vel_x*PS, player_color[pl]);
		aaline(b, x+65+player[pl].vel_x*PS, y+160+player[pl].vel_x*PS, 
			x+65+player[pl].vel_x*PS-(3*SGN(player[pl].vel_x)), y+160+player[pl].vel_x*PS, player_color[pl]);
		aaline(b, x+65+player[pl].vel_x*PS, y+160+player[pl].vel_x*PS, 
			x+65+player[pl].vel_x*PS, y+160+player[pl].vel_x*PS-(3*SGN(player[pl].vel_x)), player_color[pl]);
	}
	if (player[pl].vel_y != 0)
	{
		aaline(b, x+65, y+160, x+65-player[pl].vel_y*PS, y+160+player[pl].vel_y*PS, player_color[pl]);
		aaline(b, x+65-player[pl].vel_y*PS, y+160+player[pl].vel_y*PS, 
			x+65-player[pl].vel_y*PS+(3*SGN(player[pl].vel_y)), y+160+player[pl].vel_y*PS, player_color[pl]);
		aaline(b, x+65-player[pl].vel_y*PS, y+160+player[pl].vel_y*PS, 
			x+65-player[pl].vel_y*PS, y+160+player[pl].vel_y*PS-(3*SGN(player[pl].vel_y)), player_color[pl]);
	}
}
#undef PS

void hlite_t(BITMAP *b, int pl, int x, int y, int vx, int vy)
{
	int fx, fy;

	fx = (32 * M_HEIGHT) + ((player[pl].car_x+x) * 32) - ((player[pl].car_y+y) * 32) - vx;
	fy = ((player[pl].car_y+y) * 32) + ((player[pl].car_x+x) * 32) - vy;
	aacircle(b, fx, fy, 3, player_color[pl]);
}
void highlight_targets(int pl, int vx, int vy)
{
	int x, y;

	for (y=-1;y<2;y++)
		for (x=-1;x<2;x++)
		{
			hlite_t(d_buf, pl, player[pl].vel_x+x, player[pl].vel_y+y, vx, vy);
		}
}
int valid_target(int pl, int x, int y)
{
	int a, b, i;

	for (i = 0; i < players; i++)
		if ((pl != i) && (player[i].car_x == x) && (player[i].car_y == y))
			return 0;

	a = ABS(player[pl].car_x + player[pl].vel_x - x);
	b = ABS(player[pl].car_y + player[pl].vel_y - y);
	if ((a <= 1) && (b <= 1))
		return 1;
	else
		return 0;
}
void update_dir(int pl)
{
	PLAYER *p = &player[pl];	/* easy access :P */

	if ((p->vel_x < 0) && (ABS(p->vel_x) > ABS(p->vel_y))) p->dir = 2;
	else if ((p->vel_x > 0) && (ABS(p->vel_x) > ABS(p->vel_y))) p->dir = 6;
	else if ((p->vel_y < 0) && (ABS(p->vel_y) > ABS(p->vel_x))) p->dir = 4;
	else if ((p->vel_y > 0) && (ABS(p->vel_y) > ABS(p->vel_x))) p->dir = 0;
	else if ((ABS(p->vel_y) == ABS(p->vel_x)) && (p->vel_x < 0) && (p->vel_y < 0)) p->dir = 3;
	else if ((ABS(p->vel_y) == ABS(p->vel_x)) && (p->vel_x > 0) && (p->vel_y < 0)) p->dir = 5;
	else if ((ABS(p->vel_y) == ABS(p->vel_x)) && (p->vel_x < 0) && (p->vel_y > 0)) p->dir = 1;
	else if ((ABS(p->vel_y) == ABS(p->vel_x)) && (p->vel_x > 0) && (p->vel_y > 0)) p->dir = 7;
}

/*
 * Many thanks to entheh for this :)
 */
int half_intersect(WALL_SEG *a, WALL_SEG *b)
{
	int xd = a->x2 - a->x1;
	int yd = a->y2 - a->y1;
	int x1 = b->x1 - a->x1;
	int y1 = b->y1 - a->y1;
	int x2 = b->x2 - a->x1;
	int y2 = b->y2 - a->y1;

	int d1 = x1 * yd - y1 * xd;
	int d2 = x2 * yd - y2 * xd;

	if (d1 == 0 && d2 == 0) {
		int d = xd * xd + yd * yd;
		d1 = x1 * xd + y1 * yd;
		d2 = x2 * xd + y2 * yd;
		if (d1 > d && d2 > d) return 0;
		if (d1 < 0 && d2 < 0) return 0;
		return 1;
	}
	return (d1 <= 0 && d2 >= 0) || (d1 >= 0 && d2 <= 0);
}

int intersect(WALL_SEG *a, WALL_SEG *b)
{
	return half_intersect(a, b) && half_intersect(b, a);
}

int comment_timeout = 0;
int comment_face = 0;
char comment_1[40];
char comment_2[40];

void draw_comment()
{
	if (comment_timeout > 0)
	{
		rectfill(d_buf, 90, 10, 550, 100, makecol(0,64,0));
		rect(d_buf, 90, 10, 550, 100, makecol(0,192,0));
		masked_blit(game_data[HEAD].dat, d_buf, comment_face*80, 0, 440, 15, 80, 85);
		textout(d_buf, c_font, comment_1, 110, 20, -1);
		textout(d_buf, c_font, comment_2, 110, 50, -1);
	}
}


/*
 * Ahh.. the game loop.
 * fuxx0red as hell :P
 */
void game()
{
	WALL_SEG *w;
	int viewx = 0, viewy = 0;
	int redraw = 1;
	int last_mouse_b;
	int fx, fy;
	int i;
	int turn = 0;
	int cra = 0;
	float poopx=-1, poopy=-1, poopv=0;
	int foobar = 0;
	int game_state = 1;
	int squirrels =0;

	center_on(player[0].car_x, player[0].car_y, &viewx, &viewy);
	last_mouse_b = mouse_b;
	comment_timeout = 240;
	comment_face = 2;
	strcpy(comment_1, "Welcome to another exciting");
	strcpy(comment_2, "round of GRID RACERS!");

	while (game_state)
	{
		if (redraw)
		{
			redraw = 0;

			draw_map(d_buf, viewx, viewy, 0, c_stage->type);

			if (game_state == 1) {
				fx = ((((mouse_x+viewx) + (mouse_y+viewy) - 32 * M_HEIGHT) / 64.0f) + 0.5f);
				fy = ((((mouse_y+viewy) - (mouse_x+viewx) + 32 * M_HEIGHT) / 64.0f) + 0.5f);

				if ((fx > 0) && (fy > 0) && (fx < M_WIDTH) && (fy < M_HEIGHT) && (valid_target(turn, fx, fy)))
					aacircle(d_buf, 
						((32 * M_HEIGHT) + (fx * 32) - (fy * 32)) - viewx,
						((fy * 32) + (fx * 32)) - viewy, 8, player_color[turn]/* makecol(0,255,0)*/);
			}

			for (i = 0; i < players; i++)
			{
				for (w = player[i].trail; w; w = w->next)
					draw_wall(d_buf, w, viewx, viewy, player_color[i]);
				if (game_state == 1 && turn == i)
					highlight_targets(i, viewx, viewy);

				fx = (32 * M_HEIGHT) + (player[i].car_x * 32) - (player[i].car_y * 32);
				fy = (player[i].car_y * 32) + (player[i].car_x * 32);
				aacircle(d_buf, fx - viewx, fy - viewy, 26, player_color[i]);
				aacircle(d_buf, fx - viewx, fy - viewy, 29, player_color[i]);
				aacircle(d_buf, fx - viewx, fy - viewy, 32, player_color[i]);
			}
			for (i = 0; i < players; i++)
			{
				fx = (32 * M_HEIGHT) + (player[i].car_x * 32) - (player[i].car_y * 32);
				fy = (player[i].car_y * 32) + (player[i].car_x * 32);
				draw_vehicle(d_buf, driver[player[i].driver].vehicle, player[i].dir, fx - viewx - 32, fy - viewy - 64);
				if (turn == i)
					textout_centre(d_buf, c_font, driver[player[i].driver].name, fx - viewx, fy - viewy - 96, -1);
			}

/*			player_summary(d_buf, 10, 10, 0, (turn == 0));
			if (players > 1) player_summary(d_buf, 10,240, 1, (turn == 1));
			if (players > 2) player_summary(d_buf,500, 10, 2, (turn == 2));
			if (players > 3) player_summary(d_buf,500,240, 3, (turn == 3));*/

			if (poopx > -1)
			{
				masked_blit(game_data[POOP].dat, d_buf, 1, 1, poopx, poopy, 27, 32);
			}

			if (squirrels) squirrel_vision(d_buf);
			draw_comment();

			draw_rle_sprite(d_buf, game_data[MOUSE_POINT].dat, mouse_x, mouse_y);
			copy_buf();
		}

		while (g_time > 0)
		{
			g_time--;
			comment_timeout = MAX(comment_timeout - 1, 0);
			if ((comment_timeout == 0) && (foobar == 0))
			{
				comment_timeout = 240;
				comment_face = 0;
				strcpy(comment_1, "I am Disembodied Damien,");
				strcpy(comment_2, "and I'll be your host!");
				foobar = 1;
			}
			if ((comment_timeout == 0) && (foobar == 1))
			{
				comment_timeout = 240;
				comment_face = 2;
				strcpy(comment_1, "Let's get this show on");
				strcpy(comment_2, "the road!");
				foobar = -1;
			}
			if ((comment_timeout == 0) && (foobar == 3))
			{
				comment_timeout = 240;
				comment_face = 2;
				strcpy(comment_1, "But don't panic! He'll be");
				strcpy(comment_2, "up on his wheels again!");
				foobar = 2;
				squirrels = 0;
			}
			if ((comment_timeout == 0) && (foobar == 4))
			{
				comment_timeout = 240;
				comment_face = 2;
				if (players>2) {
					strcpy(comment_1, "Relatively Harmless Rubber Balls");
					strcpy(comment_2, "launched upon losers.");
				} else if (players>1) {
					strcpy(comment_1, "Relatively Harmless Rubber Ball");
					strcpy(comment_2, "launched upon loser.");
				} else {
					strcpy(comment_1, "Now you are ready to");
					strcpy(comment_2, "compete with real people.");
				}
				
				foobar = 5;
			}
			if ((comment_timeout == 0) && (foobar == 5))
			{
				comment_timeout = 2000;
				comment_face = 0;
				strcpy(comment_1, "Press Escape when you've");
				strcpy(comment_2, "finished celebrating.");
				foobar = -1;
			}
			redraw = 1;

			if (mouse_x > SCREEN_W-10)	viewx+=5;
			if (mouse_x <  10)		viewx-=5;
			if (mouse_y > SCREEN_H-10)	viewy+=5;
			if (mouse_y <  10)		viewy-=5;

			if ((mouse_b & 1) && !(last_mouse_b & 1))
			{
				if (game_state ==2 ) {
					//game_state = 0;
				} else {
					fx = ((((mouse_x+viewx) + (mouse_y+viewy) - 32 * M_HEIGHT) / 64.0f) + 0.5f);
					fy = ((((mouse_y+viewy) - (mouse_x+viewx) + 32 * M_HEIGHT) / 64.0f) + 0.5f);

					if (valid_target(turn, fx, fy))
					{
						player[turn].vel_x = fx - player[turn].car_x;
						player[turn].vel_y = fy - player[turn].car_y;

						if (!player[turn].vel_y && !player[turn].vel_x) {
							break;
						}

						/* create trail */
						w = malloc(sizeof(WALL_SEG));
						w->x1 = player[turn].car_x;
						w->y1 = player[turn].car_y;
						w->x2 = player[turn].car_x + player[turn].vel_x;
						w->y2 = player[turn].car_y + player[turn].vel_y;
						w->next = player[turn].trail;
						player[turn].trail = w;

						cra = 0;
						for (w = c_stage->wall; w; w = w->next)
						{
							if (intersect(w, player[turn].trail))
							{
								cra = 1;
								break;
							}
						}
						
						if (!cra)
						{
							player[turn].car_x = fx;
							player[turn].car_y = fy;
							if (intersect(&c_stage->goal, player[turn].trail))
							{
								/* We won! */
								game_state = 2;

								comment_timeout = 200;
								comment_face = 2;
								foobar = 4;
								sprintf(comment_1, "Congratulations, %s!", driver[player[turn].driver].name);
								strcpy(comment_2, "You've won the Cheeze!");

								for (i = 0; i < players; i++)
								{
									if (turn != i) player[i].dir = 8;
								}
							}
						}
						else
						{
							comment_timeout = 240;
							comment_face = 1;
							strcpy(comment_1, "Oooh, that's gotta hurt!");
							sprintf(comment_2, "%s has crashed!", driver[player[turn].driver].name);
							player[turn].vel_x = 0;
							player[turn].vel_y = 0;
							foobar = 3;
							squirrels = 1;
						}
						update_dir(turn);
						turn = (turn + 1) % players;
						center_on(player[turn].car_x, player[turn].car_y, &viewx, &viewy);
					}
				}
			}
			last_mouse_b = mouse_b;

			if (poopx > -1)
			{
				poopy += poopv;
				poopv += 0.03;
				if (poopy > SCREEN_H)
					poopx = -1;
			}
			if ((poopx == -1) && (((rand() >> 4) % 128) == 0))
			{
				/* Time for Poop to fall randomly from the sky! :)) */
				poopx = ((rand() >> 2) % (SCREEN_W-40));
				poopy = -40;
				poopv = 0;
			}
		}

		if (key[KEY_ESC]) game_state = 0;
	}

	/* discard trails */
	for (i = 0; i < players; i++)
	{
		while (player[i].trail)
		{
			w = player[i].trail;
			player[i].trail = w->next;
			free(w);
		}
	}
}