/*
 *  Grid Racers
 *   Allegro IdeaHack 2001 entry for Team 1337
 *
 *  File   : edtior.c
 *  Purpose: The track editor
 */
#include <allegro.h>
#include <string.h>
#include "player.h"
#include "misc.h"
#include "gamedata.h"
#include "settings.h"
#include "map.h"

int f_deco[] = { PAPER_DECO_1, DIRT_DECO_1 };
char *tt_name[] = { "Paper", "Dirt" };

char *read_filename(char *msg, char *deflt)
{
	static char f[80];
	int k;

	clear_keybuf();
	strcpy(f, deflt);
	while (1)
	{
		rectfill(d_buf, 60, 160, 580, 260, makecol(32,32,32));
		rect(d_buf, 60, 160, 580, 260, makecol(192,192,192));
		textout_centre(d_buf, c_font, msg, 320, 170, -1);
		textprintf_centre(d_buf, c_font, 320, 200, -1, "%s#", f);
		copy_buf();

		k = readkey();
		if ((k >> 8) == KEY_ESC)
		{
			f[0] = '\0';
			break;
		}
		if ((k >> 8) == KEY_ENTER)
			break;
		if ((k >> 8) == KEY_BACKSPACE)
		{
			if (strlen(f) > 0)
			{
				f[strlen(f)-1] = '\0';
			}
		}
		if (((k & 0xff) >= 32) && ((k & 0xff) <= 126))	/* <space> to ~ */
		{
			if (strlen(f) < 79)
			{
				f[strlen(f)+1] = '\0';
				f[strlen(f)] = (k & 0xff);
			}
		}
	}
	
	clear_keybuf();
	return f;
}

void edit_msg(char *msg, char *msg2)
{
		rectfill(d_buf, 60, 160, 580, 260, makecol(32,32,32));
		rect(d_buf, 60, 160, 580, 260, makecol(192,192,192));
		textout_centre(d_buf, c_font, msg, 320, 180, -1);
		textout_centre(d_buf, c_font, msg2, 320, 210, -1);
		copy_buf();
		readkey();
}
void save_map()
{
	char *file;
	PACKFILE *fp;
	WALL_SEG *w;

	file = read_filename("Enter name of file to SAVE:", c_stage->filename);
	if (*file == '\0')
		return;

	fp = pack_fopen(file, "w");
	if (!fp)
	{
		edit_msg("Error: Could not open file for writing!", "Please ensure that the file name is valid.");
		return;
	}

	pack_iputl(GRT_MAGIC_NUMBER, fp);
	strcpy(c_stage->filename, file);

	pack_fwrite(c_stage->trackname, 80, fp);
	pack_iputl(c_stage->type, fp);
	pack_iputl(c_stage->wall_color, fp);
	for (w = c_stage->wall; w; w = w->next)
	{
		pack_iputl(w->x1, fp);
		pack_iputl(w->y1, fp);
		pack_iputl(w->x2, fp);
		pack_iputl(w->y2, fp);
	}
	pack_iputl(-1, fp);

	pack_iputl(c_stage->start_x[0], fp);
	pack_iputl(c_stage->start_y[0], fp);
	pack_iputl(c_stage->start_x[1], fp);
	pack_iputl(c_stage->start_y[1], fp);
	pack_iputl(c_stage->start_x[2], fp);
	pack_iputl(c_stage->start_y[2], fp);
	pack_iputl(c_stage->start_x[3], fp);
	pack_iputl(c_stage->start_y[3], fp);
	pack_iputl(c_stage->goal.x1, fp);
	pack_iputl(c_stage->goal.x2, fp);
	pack_iputl(c_stage->goal.y1, fp);
	pack_iputl(c_stage->goal.y2, fp);

	pack_fclose(fp);

	edit_msg("Track saved properly.","");
}
void load_map()
{
	char *file;
	MAP *stg;

	file = read_filename("Enter name of file to LOAD:", c_stage->filename);
	if (*file == '\0')
		return;

	stg = open_map(file);
	if (!stg)
	{
		edit_msg("Error: Could not open file for reading!", "Please ensure that the file exists.");
		return;
	}

	free_map(c_stage);
	c_stage = stg;

	edit_msg("Track loaded properly.","");
}

void name_track()
{
	char *name;

	name = read_filename("Name this track.", c_stage->trackname);
	if (*name != '\0')
		strcpy(c_stage->trackname, name);
}

void set_goal(MAP *m, int x1, int y1, int x2, int y2);

void editor_help()
{
	rectfill(d_buf, 60, 100, 580, 320, makecol(32,32,32));
	rect(d_buf, 60, 100, 580, 320, makecol(192,192,192));
	textout_centre(d_buf, c_font, "EDITOR HOTKEYS:", 320, 110, -1);
	textout(d_buf, c_font, "F1: This screen", 70, 140, -1);
	textout(d_buf, c_font, "F2: Save track", 70, 160, -1);
	textout(d_buf, c_font, "F3: Load track", 70, 180, -1);
	textout(d_buf, c_font, "F5: Name track", 70, 200, -1);
	textout(d_buf, c_font, "F6: Wall mode", 70, 220, -1);
	textout(d_buf, c_font, "F8: Goal mode", 70, 240, -1);
	textout(d_buf, c_font, "Keys 1-4: Start positions.", 70, 260, -1);
	textout_centre(d_buf, c_font, "(Press Enter)", 320, 290, -1);
	copy_buf();

	while(key[KEY_SPACE] || key[KEY_ENTER]);
	while(!key[KEY_SPACE] && !key[KEY_ENTER]);
}


/* Main track editor function */
void track_editor()
{
	int redraw = 1;
	int viewx = 32 * M_HEIGHT - 120, viewy = -60;
	int orthox, orthoy;
	int segx, segy;
	int i, c;
	int mode = 0;	/* 0 = wall, 1 = deco */
	WALL_SEG *tmp, *nxt;

	c_stage = create_map();

	c_stage->type = M_DIRT;
	c_stage->wall_color = makecol(255,255,255);
	segx = -1; segy = -1;
	center_on(32, 24, &viewx, &viewy);
	stop_midi();
	while (1)
	{
		if (redraw)
		{
			redraw = 0;

			draw_map(d_buf, viewx, viewy, 1, c_stage->type);

			orthox = ((((mouse_x+viewx) + (mouse_y+viewy) - 32 * M_HEIGHT) / 64.0f) + 0.5f);
			orthoy = ((((mouse_y+viewy) - (mouse_x+viewx) + 32 * M_HEIGHT) / 64.0f) + 0.5f);

			if ((orthox > 0) && (orthoy > 0) && (orthox < M_WIDTH) && (orthoy < M_HEIGHT))
				aacircle(d_buf, 
					((32 * M_HEIGHT) + (orthox * 32) - (orthoy * 32)) - viewx,
					((orthoy * 32) + (orthox * 32)) - viewy, 5, makecol(0,255,0));

			if (segx > -1)
			{
				if (mode == 2)
					c = makecol(255,0,255);
				else
					c = makecol(0,255,0);
				aaline(d_buf, 
					((32 * M_HEIGHT) + (segx * 32) - (segy * 32)) - viewx,
					((segy * 32) + (segx * 32)) - viewy,
					((32 * M_HEIGHT) + (orthox * 32) - (orthoy * 32)) - viewx,
					((orthoy * 32) + (orthox * 32)) - viewy, c);
				aacircle(d_buf, 
					((32 * M_HEIGHT) + (segx * 32) - (segy * 32)) - viewx,
					((segy * 32) + (segx * 32)) - viewy, 3, c);
			}

			textprintf(d_buf, c_font, 0, 0, -1, "%d-%d", orthox, orthoy);
			textprintf(d_buf, c_font, 10, SCREEN_H-60, -1, "track:%s", c_stage->trackname);
			textprintf(d_buf, c_font, 10, SCREEN_H-30, -1, "file :%s", c_stage->filename);
			if (mode == 0)
				textout_right(d_buf, c_font, "Wall Mode", SCREEN_W-10, 10, -1);
			else if (mode == 1)
				textout_right(d_buf, c_font, "Deco Mode (N/A)", SCREEN_W-10, 10, -1);
			else if (mode == 2)
				textout_right(d_buf, c_font, "Goal Mode", SCREEN_W-10, 10, -1);

			draw_rle_sprite(d_buf, game_data[MOUSE_POINT].dat, mouse_x, mouse_y);
			copy_buf();
		}

		while (g_time > 0)
		{
			g_time--;
			redraw = 1;

			if (mouse_x > SCREEN_W-10)	viewx+=5;
			if (mouse_x <  10)		viewx-=5;
			if (mouse_y > SCREEN_H-10)	viewy+=5;
			if (mouse_y <  10)		viewy-=5;

			if (!(mouse_b & 1) && (segx > -1))
			{
				orthox = ((((mouse_x+viewx) + (mouse_y+viewy) - 32 * M_HEIGHT) / 64.0f) + 0.5f);
				orthoy = ((((mouse_y+viewy) - (mouse_x+viewx) + 32 * M_HEIGHT) / 64.0f) + 0.5f);

				if ((segx != orthox) || (segy != orthoy))
				{
					if (mode == 0)
						create_wall(c_stage, segx, segy, orthox, orthoy);
					else if (mode == 2)
					{
						set_goal(c_stage, segx, segy, orthox, orthoy);
					}
				}
				segx = -1;
			}
			if ((mouse_b & 1) && (segx == -1))
			{
				orthox = ((((mouse_x+viewx) + (mouse_y+viewy) - 32 * M_HEIGHT) / 64.0f) + 0.5f);
				orthoy = ((((mouse_y+viewy) - (mouse_x+viewx) + 32 * M_HEIGHT) / 64.0f) + 0.5f);
				if ((orthox > 0) && (orthoy > 0) && (orthox < M_WIDTH) && (orthoy < M_HEIGHT))
				{
					segx = orthox;
					segy = orthoy;
				}
			}
			/* Remove segment */
			if (mouse_b & 2)
			{
				orthox = ((((mouse_x+viewx) + (mouse_y+viewy) - 32 * M_HEIGHT) / 64.0f) + 0.5f);
				orthoy = ((((mouse_y+viewy) - (mouse_x+viewx) + 32 * M_HEIGHT) / 64.0f) + 0.5f);

				for (tmp = c_stage->wall; tmp; tmp = nxt)
				{
					nxt = tmp->next;
					if ( ((tmp->x1 == orthox) && (tmp->y1 == orthoy)) || ((tmp->x2 == orthox) && (tmp->y2 == orthoy)) )
						remove_wall(c_stage, tmp);
				}
			}
			for (i = KEY_1; i <= KEY_4; i++)
			{
				if (key[i])
				{
					orthox = ((((mouse_x+viewx) + (mouse_y+viewy) - 32 * M_HEIGHT) / 64.0f) + 0.5f);
					orthoy = ((((mouse_y+viewy) - (mouse_x+viewx) + 32 * M_HEIGHT) / 64.0f) + 0.5f);
					if ((orthox > 0) && (orthoy > 0) && (orthox < M_WIDTH) && (orthoy < M_HEIGHT))
					{
						c_stage->start_x[i-KEY_1] = orthox;
						c_stage->start_y[i-KEY_1] = orthoy;
					}
				}
			}
			if (key[KEY_F1])
				editor_help();
			if (key[KEY_F2])
				save_map();
			if (key[KEY_F3])
				load_map();
			if (key[KEY_F5])
				name_track();

			if (key[KEY_F6])
				mode = 0;
			if (key[KEY_F7])
				mode = 1;
			if (key[KEY_F8])
				mode = 2;
			if (key[KEY_F9]){
				c_stage->type = M_DIRT;
				c_stage->wall_color = makecol(255,255,255);
			}
			if (key[KEY_F10]){
				c_stage->type = M_PAPER;
				c_stage->wall_color = makecol(0,0,0);
			}


		}

		if (key[KEY_ESC])
			break;
	}
	play_bgm(MUSIC_THEME, 1);
	free_map(c_stage);
}