#include <allegro.h>
#include "headers.h"

int bl_played = 0;
int score = 0;
int lines = 0;
int difficult = 4;
SAMPLE *suono;
volatile int speed_counter = 0;

// FUNZIONE BUSY DEL TIMER...
void increment_speed_counter()
{
    speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

// INIZIALIZZA ALLEGRO E LE PERIFERICHE.
// TASTIERA, SCHEDA AUDIO, MODALITA' VIDEO...
DATAFILE *init_game(DATAFILE *dati)
{
    BITMAP *freccia;
    allegro_init();
    set_color_depth(15);
    set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,0,0);
    #ifdef ALLEGRO_WINDOWS
        set_window_title("Stellatris 1.0 dedicated to Stellupola");
    #endif
    install_keyboard();
    install_timer();
    install_mouse();
    install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL);
    dati = load_datafile("tetris.dat");
    set_palette(dati[palette].dat);
    freccia = dati[pointer].dat;
    set_mouse_sprite(freccia);
    suono = dati[campione].dat;
    return dati;
}

// DISEGNA A VIDEO LA MATRICE DI GIOCO.
void draw_matrix(int matrix[10][24], DATAFILE *dati)
{
    BITMAP *buffer;
    int x,y;
    buffer = create_bitmap(200,480);
    clear_to_color(buffer,0);
    for (x=0;x<10;x++)
        for (y=0;y<24;y++)
    {
        if (matrix[x][y] == green) draw_sprite(buffer,dati[green].dat,x*20,y*20);
        if (matrix[x][y] == red) draw_sprite(buffer,dati[red].dat,x*20,y*20);
        if (matrix[x][y] == lgreen) draw_sprite(buffer,dati[lgreen].dat,x*20,y*20);
        if (matrix[x][y] == yellow) draw_sprite(buffer,dati[yellow].dat,x*20,y*20);
        if (matrix[x][y] == purple) draw_sprite(buffer,dati[purple].dat,x*20,y*20);
        if (matrix[x][y] == blue) draw_sprite(buffer,dati[blue].dat,x*20,y*20);
        if (matrix[x][y] == lblue) draw_sprite(buffer,dati[lblue].dat,x*20,y*20);
    }
    vsync();
    blit(buffer,screen,0,0,0,0,200,480);
    destroy_bitmap(buffer);
}

// ESCE DA ALLEGRO...
void exit_game()
{
    allegro_exit();
}

// COPIA LA MATRICE DEL PEZZO DENTRO LA MATRICE DI GIOCO...
void copy_into(int matrix[10][24],int pezzo[4][4][4],int x,int y,int z)
{
    int i, j;
    for (i=0;i<4;i++)
        for (j=0;j<4;j++)
        if (pezzo[i][j][z] != EMPTY) matrix[x+i][y+j] = pezzo[i][j][z];
}

// DISEGNA IL BLOCCO BLU.
void draw_blue(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int y = 0;
    int z = 0;
    int end = 0;
    int mat_blue [4][4][4];
    int mat_vuoto [4][4][4];
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    for (x=0;x<4;x++)
        for (y=0;y<4;y++)
        for (z=0;z<4;z++)
    {
        mat_vuoto[x][y][z] = EMPTY;
        mat_blue[x][y][z] = EMPTY;
    }
    for (z=0;z<4;z++)
    {
        mat_blue[0][0][z] = blue;
        mat_blue[1][0][z] = blue;
        mat_blue[0][1][z] = blue;
        mat_blue[1][1][z] = blue;
        mat_vuoto[0][0][z] = VUOTO;
        mat_vuoto[1][0][z] = VUOTO;
        mat_vuoto[0][1][z] = VUOTO;
        mat_vuoto[1][1][z] = VUOTO;
    }
    x = 0;
    y = 0;
    z = 0;
    copy_into(matrix,mat_blue,x,y,z%4);
    draw_matrix(matrix,dati);
    while (!end)
    {
        copy_into(matrix,mat_vuoto,x,y,z%4);
        if (key[KEY_RIGHT] && (x < 8) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) x++;
        if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO)) x--;
        install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
        while (speed_counter > 0)
        {
            if ((y < 22) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO))
            {
                y++;
                speed_counter--;
            }
            else
            {
                play_sample(suono,255,128,1000,0);
                bl_played = bl_played + 4;
                textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                end = 1;
                speed_counter--;
            }
        }
        copy_into(matrix,mat_blue,x,y,z%4);
        draw_matrix(matrix,dati);
    }
}

// DISEGNA IL BLOCCO ROSSO...
void draw_red(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int y = 0;
    int z = 0;
    int end = 0;
    int mat_red [4][4][4];
    int mat_vuoto [4][4][4];
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    for (x=0;x<4;x++)
        for (y=0;y<4;y++)
        for (z=0;z<4;z++)
    {
        mat_vuoto[x][y][z] = EMPTY;
        mat_red[x][y][z] = EMPTY;
    }
    // VERTICALE
    mat_red[1][0][0] = red;
    mat_red[1][1][0] = red;
    mat_red[1][2][0] = red;
    mat_red[1][3][0] = red;
    mat_vuoto[1][0][0] = VUOTO;
    mat_vuoto[1][1][0] = VUOTO;
    mat_vuoto[1][2][0] = VUOTO;
    mat_vuoto[1][3][0] = VUOTO;
    mat_red[1][0][2] = red;
    mat_red[1][1][2] = red;
    mat_red[1][2][2] = red;
    mat_red[1][3][2] = red;
    mat_vuoto[1][0][2] = VUOTO;
    mat_vuoto[1][1][2] = VUOTO;
    mat_vuoto[1][2][2] = VUOTO;
    mat_vuoto[1][3][2] = VUOTO;
    // ORIZZONTALE
    mat_red[0][2][1] = red;
    mat_red[1][2][1] = red;
    mat_red[2][2][1] = red;
    mat_red[3][2][1] = red;
    mat_vuoto[0][2][1] = VUOTO;
    mat_vuoto[1][2][1] = VUOTO;
    mat_vuoto[2][2][1] = VUOTO;
    mat_vuoto[3][2][1] = VUOTO;
    mat_red[0][2][3] = red;
    mat_red[1][2][3] = red;
    mat_red[2][2][3] = red;
    mat_red[3][2][3] = red;
    mat_vuoto[0][2][3] = VUOTO;
    mat_vuoto[1][2][3] = VUOTO;
    mat_vuoto[2][2][3] = VUOTO;
    mat_vuoto[3][2][3] = VUOTO;
    x = 0;
    y = 0;
    z = rand();
    copy_into(matrix,mat_red,x,y,z%4);
    draw_matrix(matrix,dati);
    while (!end)
    {
        switch (z%4)
        {
            case 0:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 9) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO) && (matrix[x+2][y+3] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > -1) && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO) && (matrix[x][y+3] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 20) && (matrix[x+1][y+4] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 6) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+2] == VUOTO) && (matrix[x+3][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_red,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 1:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 6) && (matrix[x+4][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+3] == VUOTO) && (matrix[x+2][y+3] == VUOTO) && (matrix[x+3][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+1][y+3] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_red,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 2:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 9) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO) && (matrix[x+2][y+3] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > -1) && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO) && (matrix[x][y+3] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 20) && (matrix[x+1][y+4] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 6) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+2] == VUOTO) && (matrix[x+3][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_red,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 3:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 6) && (matrix[x+4][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+3] == VUOTO) && (matrix[x+2][y+3] == VUOTO) && (matrix[x+3][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+1][y+3] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_red,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
        }
    }
}

// DISEGNA IL BLOCCO VIOLA...
void draw_purple(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int y = 0;
    int z = 0;
    int end = 0;
    int mat_purple [4][4][4];
    int mat_vuoto [4][4][4];
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    for (x=0;x<4;x++)
        for (y=0;y<4;y++)
        for (z=0;z<4;z++)
    {
        mat_vuoto[x][y][z] = EMPTY;
        mat_purple[x][y][z] = EMPTY;
    }
    // VERTICALE
    mat_purple[0][0][0] = purple;
    mat_purple[0][1][0] = purple;
    mat_purple[1][1][0] = purple;
    mat_purple[1][2][0] = purple;
    mat_vuoto[0][0][0] = VUOTO;
    mat_vuoto[0][1][0] = VUOTO;
    mat_vuoto[1][1][0] = VUOTO;
    mat_vuoto[1][2][0] = VUOTO;
    mat_purple[0][0][2] = purple;
    mat_purple[0][1][2] = purple;
    mat_purple[1][1][2] = purple;
    mat_purple[1][2][2] = purple;
    mat_vuoto[0][0][2] = VUOTO;
    mat_vuoto[0][1][2] = VUOTO;
    mat_vuoto[1][1][2] = VUOTO;
    mat_vuoto[1][2][2] = VUOTO;
    // ORIZZONTALE
    mat_purple[1][0][1] = purple;
    mat_purple[2][0][1] = purple;
    mat_purple[0][1][1] = purple;
    mat_purple[1][1][1] = purple;
    mat_vuoto[1][0][1] = VUOTO;
    mat_vuoto[2][0][1] = VUOTO;
    mat_vuoto[0][1][1] = VUOTO;
    mat_vuoto[1][1][1] = VUOTO;
    mat_purple[1][0][3] = purple;
    mat_purple[2][0][3] = purple;
    mat_purple[0][1][3] = purple;
    mat_purple[1][1][3] = purple;
    mat_vuoto[1][0][3] = VUOTO;
    mat_vuoto[2][0][3] = VUOTO;
    mat_vuoto[0][1][3] = VUOTO;
    mat_vuoto[1][1][3] = VUOTO;
    x = 0;
    y = 0;
    z = rand();
    copy_into(matrix,mat_purple,x,y,z%4);
    draw_matrix(matrix,dati);
    while(!end)
    {
        switch (z%4)
        {
            case 0:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT]&& (x < 8) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_purple,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 1:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+3][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y+1] == VUOTO) && (matrix[x][y] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+1] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_purple,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 2:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT]&& (x < 8) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_purple,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 3:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+3][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y+1] == VUOTO) && (matrix[x][y] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+1] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_purple,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
        }
    }
}

// DISEGNA IL BLOCCO AZZURRO...
void draw_lblue(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int y = 0;
    int z = 0;
    int end = 0;
    int mat_lblue [4][4][4];
    int mat_vuoto [4][4][4];
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    for (x=0;x<4;x++)
        for (y=0;y<4;y++)
        for (z=0;z<4;z++)
    {
        mat_vuoto[x][y][z] = EMPTY;
        mat_lblue[x][y][z] = EMPTY;
    }
    // VERTICALE
    mat_lblue[1][0][0] = lblue;
    mat_lblue[0][1][0] = lblue;
    mat_lblue[1][1][0] = lblue;
    mat_lblue[0][2][0] = lblue;
    mat_vuoto[1][0][0] = VUOTO;
    mat_vuoto[0][1][0] = VUOTO;
    mat_vuoto[1][1][0] = VUOTO;
    mat_vuoto[0][2][0] = VUOTO;
    mat_lblue[1][0][2] = lblue;
    mat_lblue[0][1][2] = lblue;
    mat_lblue[1][1][2] = lblue;
    mat_lblue[0][2][2] = lblue;
    mat_vuoto[1][0][2] = VUOTO;
    mat_vuoto[0][1][2] = VUOTO;
    mat_vuoto[1][1][2] = VUOTO;
    mat_vuoto[0][2][2] = VUOTO;
    // ORIZZONTALE
    mat_lblue[0][0][1] = lblue;
    mat_lblue[1][0][1] = lblue;
    mat_lblue[1][1][1] = lblue;
    mat_lblue[2][1][1] = lblue;
    mat_vuoto[0][0][1] = VUOTO;
    mat_vuoto[1][0][1] = VUOTO;
    mat_vuoto[1][1][1] = VUOTO;
    mat_vuoto[2][1][1] = VUOTO;
    mat_lblue[0][0][3] = lblue;
    mat_lblue[1][0][3] = lblue;
    mat_lblue[1][1][3] = lblue;
    mat_lblue[2][1][3] = lblue;
    mat_vuoto[0][0][3] = VUOTO;
    mat_vuoto[1][0][3] = VUOTO;
    mat_vuoto[1][1][3] = VUOTO;
    mat_vuoto[2][1][3] = VUOTO;
    x = 0;
    y = 0;
    z = rand();
    copy_into(matrix,mat_lblue,x,y,z%4);
    draw_matrix(matrix,dati);
    while(!end)
    {
        switch (z%4)
        {
            case 0:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lblue,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 1:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+2][y] == VUOTO) && (matrix[x+3][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x][y+1] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lblue,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 2:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lblue,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 3:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+2][y] == VUOTO) && (matrix[x+3][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x][y+1] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lblue,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
        }
    }
}

// DISEGNA IL BLOCCO VERDE...
void draw_green(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int y = 0;
    int z = 0;
    int end = 0;
    int mat_green [4][4][4];
    int mat_vuoto [4][4][4];
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    for (x=0;x<4;x++)
        for (y=0;y<4;y++)
        for (z=0;z<4;z++)
    {
        mat_vuoto[x][y][z] = EMPTY;
        mat_green[x][y][z] = EMPTY;
    }
    // PRIMA POSIZIONE...
    mat_green[1][0][0] = green;
    mat_green[1][1][0] = green;
    mat_green[0][1][0] = green;
    mat_green[2][1][0] = green;
    mat_vuoto[1][0][0] = VUOTO;
    mat_vuoto[1][1][0] = VUOTO;
    mat_vuoto[0][1][0] = VUOTO;
    mat_vuoto[2][1][0] = VUOTO;
    // SECONDA POSIZIONE...
    mat_green[0][0][1] = green;
    mat_green[0][1][1] = green;
    mat_green[0][2][1] = green;
    mat_green[1][1][1] = green;
    mat_vuoto[0][0][1] = VUOTO;
    mat_vuoto[0][1][1] = VUOTO;
    mat_vuoto[0][2][1] = VUOTO;
    mat_vuoto[1][1][1] = VUOTO;
    // TERZA POSIZIONE...
    mat_green[0][0][2] = green;
    mat_green[1][0][2] = green;
    mat_green[2][0][2] = green;
    mat_green[1][1][2] = green;
    mat_vuoto[0][0][2] = VUOTO;
    mat_vuoto[1][0][2] = VUOTO;
    mat_vuoto[2][0][2] = VUOTO;
    mat_vuoto[1][1][2] = VUOTO;
    // QUARTA POSIZIONE...
    mat_green[1][0][3] = green;
    mat_green[0][1][3] = green;
    mat_green[1][1][3] = green;
    mat_green[1][2][3] = green;
    mat_vuoto[1][0][3] = VUOTO;
    mat_vuoto[0][1][3] = VUOTO;
    mat_vuoto[1][1][3] = VUOTO;
    mat_vuoto[1][2][3] = VUOTO;
    x = 0;
    y = 0;
    z = rand();
    copy_into(matrix,mat_green,x,y,z%4);
    draw_matrix(matrix,dati);
    while(!end)
    {
        switch (z%4)
        {
            case 0:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+2][y] == VUOTO) && (matrix[x+3][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+1] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_green,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 1:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_green,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 2:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+3][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x][y+1] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+1] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x][y+1] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_green,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 3:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO)) x--;
                install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+1][y] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_green,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
        }
    }
}

// DISEGNA IL BLOCCO GIALLO...
void draw_yellow(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int y = 0;
    int z = 0;
    int end = 0;
    int mat_yellow [4][4][4];
    int mat_vuoto [4][4][4];
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    for (x=0;x<4;x++)
        for (y=0;y<4;y++)
        for (z=0;z<4;z++)
    {
        mat_vuoto[x][y][z] = EMPTY;
        mat_yellow[x][y][z] = EMPTY;
    }
    // PRIMA POSIZIONE...
    mat_yellow[0][0][0] = yellow;
    mat_yellow[0][1][0] = yellow;
    mat_yellow[0][2][0] = yellow;
    mat_yellow[1][2][0] = yellow;
    mat_vuoto[0][0][0] = VUOTO;
    mat_vuoto[0][1][0] = VUOTO;
    mat_vuoto[0][2][0] = VUOTO;
    mat_vuoto[1][2][0] = VUOTO;
    // SECONDA POSIZIONE...
    mat_yellow[0][0][1] = yellow;
    mat_yellow[1][0][1] = yellow;
    mat_yellow[2][0][1] = yellow;
    mat_yellow[0][1][1] = yellow;
    mat_vuoto[0][0][1] = VUOTO;
    mat_vuoto[1][0][1] = VUOTO;
    mat_vuoto[2][0][1] = VUOTO;
    mat_vuoto[0][1][1] = VUOTO;
    // TERZA POSIZIONE...
    mat_yellow[0][0][2] = yellow;
    mat_yellow[1][0][2] = yellow;
    mat_yellow[1][1][2] = yellow;
    mat_yellow[1][2][2] = yellow;
    mat_vuoto[0][0][2] = VUOTO;
    mat_vuoto[1][0][2] = VUOTO;
    mat_vuoto[1][1][2] = VUOTO;
    mat_vuoto[1][2][2] = VUOTO;
    // QUARTA POSIZIONE...
    mat_yellow[2][0][3] = yellow;
    mat_yellow[0][1][3] = yellow;
    mat_yellow[1][1][3] = yellow;
    mat_yellow[2][1][3] = yellow;
    mat_vuoto[2][0][3] = VUOTO;
    mat_vuoto[0][1][3] = VUOTO;
    mat_vuoto[1][1][3] = VUOTO;
    mat_vuoto[2][1][3] = VUOTO;
    x = 0;
    y = 0;
    z = rand();
    copy_into(matrix,mat_yellow,x,y,z%4);
    draw_matrix(matrix,dati);
    while(!end)
    {
        switch (z%4)
        {
            case 0:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_yellow,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 1:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+3][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+1] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x][y] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_yellow,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 2:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_yellow,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 3:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+3][y] == VUOTO) && (matrix[x+3][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y+1] == VUOTO) && (matrix[x+1][y] == VUOTO)) x--;
                install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_yellow,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
        }
    }
}

// DISEGNA IL BLOCCO VERDE CHIARO...
void draw_lgreen(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int y = 0;
    int z = 0;
    int end = 0;
    int mat_lgreen [4][4][4];
    int mat_vuoto [4][4][4];
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);
    for (x=0;x<4;x++)
        for (y=0;y<4;y++)
        for (z=0;z<4;z++)
    {
        mat_vuoto[x][y][z] = EMPTY;
        mat_lgreen[x][y][z] = EMPTY;
    }
    // PRIMA POSIZIONE...
    mat_lgreen[0][2][0] = lgreen;
    mat_lgreen[1][0][0] = lgreen;
    mat_lgreen[1][1][0] = lgreen;
    mat_lgreen[1][2][0] = lgreen;
    mat_vuoto[0][2][0] = VUOTO;
    mat_vuoto[1][0][0] = VUOTO;
    mat_vuoto[1][1][0] = VUOTO;
    mat_vuoto[1][2][0] = VUOTO;
    // SECONDA POSIZIONE...
    mat_lgreen[0][0][1] = lgreen;
    mat_lgreen[0][1][1] = lgreen;
    mat_lgreen[1][1][1] = lgreen;
    mat_lgreen[2][1][1] = lgreen;
    mat_vuoto[0][0][1] = VUOTO;
    mat_vuoto[0][1][1] = VUOTO;
    mat_vuoto[1][1][1] = VUOTO;
    mat_vuoto[2][1][1] = VUOTO;
    // TERZA POSIZIONE...
    mat_lgreen[0][0][2] = lgreen;
    mat_lgreen[1][0][2] = lgreen;
    mat_lgreen[0][1][2] = lgreen;
    mat_lgreen[0][2][2] = lgreen;
    mat_vuoto[0][0][2] = VUOTO;
    mat_vuoto[1][0][2] = VUOTO;
    mat_vuoto[0][1][2] = VUOTO;
    mat_vuoto[0][2][2] = VUOTO;
    // QUARTA POSIZIONE...
    mat_lgreen[0][0][3] = lgreen;
    mat_lgreen[1][0][3] = lgreen;
    mat_lgreen[2][0][3] = lgreen;
    mat_lgreen[2][1][3] = lgreen;
    mat_vuoto[0][0][3] = VUOTO;
    mat_vuoto[1][0][3] = VUOTO;
    mat_vuoto[2][0][3] = VUOTO;
    mat_vuoto[2][1][3] = VUOTO;
    x = 0;
    y = 0;
    z = rand();
    copy_into(matrix,mat_lgreen,x,y,z%4);
    draw_matrix(matrix,dati);
    while(!end)
    {
        switch (z%4)
        {
            case 0:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+3] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lgreen,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 1:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 7) && (matrix[x+1][y] == VUOTO) && (matrix[x+3][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x+2][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x][y] == VUOTO) && (matrix[x][y+1] == VUOTO) && (matrix[x][y+2] == VUOTO) && (matrix[x+1][y] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lgreen,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 2:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+2][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x-1][y+1] == VUOTO) && (matrix[x-1][y+2] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 21) && (matrix[x][y+3] == VUOTO) && (matrix[x+1][y+1] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (x < 8) && (matrix[x][y] == VUOTO) && (matrix[x+1][y] == VUOTO) && (matrix[x+2][y] == VUOTO) && (matrix[x+2][y+1] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lgreen,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
            case 3:
            {
                copy_into(matrix,mat_vuoto,x,y,z%4);
                if (key[KEY_RIGHT] && (x < 8) && (matrix[x+3][y] == VUOTO) && (matrix[x+3][y+1] == VUOTO)) x++;
                if (key[KEY_LEFT] && (x > 0) && (matrix[x-1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO)) x--;
install_int_ex(increment_speed_counter, BPS_TO_TIMER(difficult));
                while (speed_counter > 0)
                {
                    if ((y < 22) && (matrix[x][y+1] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+2][y+2] == VUOTO))
                    {
                        if (key[KEY_SPACE] && (matrix[x+1][y] == VUOTO) && (matrix[x+1][y+1] == VUOTO) && (matrix[x+1][y+2] == VUOTO) && (matrix[x][y+2] == VUOTO)) { z++; y--; }
                            y++;
                        speed_counter--;
                    }
                    else
                    {
                        play_sample(suono,255,128,1000,0);
                        bl_played = bl_played + 4;
                        textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
                        end = 1;
                        speed_counter--;
                    }
                }
                copy_into(matrix,mat_lgreen,x,y,z%4);
                draw_matrix(matrix,dati);
                break;
            }
        }
    }
}

// CANCELLA LA RIGA COMPLETA...
void ctrl_matrix(int matrix[10][24],DATAFILE *dati)
{
    int x = 0;
    int j = 0;
    int z = 0;
    int i = 0;
    int k = 0;
    int flag = 0;
    int tmp[10][24];

    for (k=0;k<4;k++)
    {
        flag = 0;

        for (x=0;x<24;x++)
        {
            for (j=0;j<10;j++)
            {
                tmp[j][x] = matrix[j][x];
            }
        }
        for (x=0;x<24;x++)
        {
            z = 0;
            for (j=0;j<10;j++)
            {
                if (matrix[j][x] != VUOTO) z++;
            }
            if (z == 10)
            {
                score = score + 20;
                textprintf(screen,font,220,400,makecol(255,0,0),"Score: %d",score);
                if (!flag) { flag++; lines++; textprintf(screen,font,220,440,makecol(255,0,0),"Lines completed: %d",lines); }
                    for (j=0;j<10;j++) matrix[j][x] = VUOTO;
                for (z=1;z<x;z++)
                    for (i=0;i<10;i++)
                {
                    matrix[i][z+1] = tmp[i][z];
                }
                draw_matrix(matrix,dati);
            }
        }
    }
}

// LOOP DI GIOCO...
void loop(int matrix[10][24],DATAFILE *dati)
{
    int i,next, j, game_over;
    BITMAP *dog = dati[cane].dat;
    BITMAP *under = dati[sotto].dat;
    BITMAP *dx = dati[spalladx].dat;
    BITMAP *buffer;
    BITMAP *blnext;
    MIDI *noci;

    bl_played = lines = score = game_over = 0;
    difficult = 4;
    noci = dati[ingame].dat;
    play_midi(noci,1);
    buffer = create_bitmap(440,480);
    blit(dog,buffer,0,0,0,0,220,317);
    blit(dx,buffer,0,0,220,0,220,317);
    blit(under,buffer,0,0,0,317,440,163);
    blit(buffer,screen,0,0,200,0,440,480);
    destroy_bitmap(buffer);

    textprintf(screen,font,220,400,makecol(255,0,0),"Score: %d",score);
    textprintf(screen,font,380,400,makecol(255,0,0),"Level: 1");
    textprintf(screen,font,220,420,makecol(255,0,0),"Blocks played: %d",bl_played);
    textprintf(screen,font,220,440,makecol(255,0,0),"Lines completed: %d",lines);

    next = rand();

    while (!key[KEY_ESC])
    {
        if ((difficult == 4) && (lines > 10))
        {
            difficult++;
            textprintf(screen,font,380,400,makecol(255,0,0),"Level: 2");
        }
        if ((difficult == 5) && (lines > 50))
        {
            difficult++;
            textprintf(screen,font,380,400,makecol(255,0,0),"Level: 3");
        }
        if ((difficult == 6) && (lines > 110))
        {
            difficult++;
            textprintf(screen,font,380,400,makecol(255,0,0),"Level: 4");
        }
        if ((difficult == 7) && (lines > 190))
        {
            difficult++;
            textprintf(screen,font,380,400,makecol(255,0,0),"Level: 5");
        }

        i = next;
        next = rand();

        // CONTROLLO GAME OVER...
        for(j=0;j<10;j++)
        {
           if (matrix[j][0] != VUOTO) game_over++;
        }

        if (game_over) { end_game(dati); return; }

        switch(next%7)
        {
            case 0:
            {
                blnext = dati[lgreennext].dat;
                vsync();
                blit(blnext,screen,0,0,510,140,80,80);
                break;
            }
            case 1:
            {
                blnext = dati[greennext].dat;
                vsync();
                blit(blnext,screen,0,0,510,140,80,80);
                break;
            }
            case 2:
            {
                blnext = dati[lbluenext].dat;
                vsync();
                blit(blnext,screen,0,0,510,140,80,80);
                break;
            }
            case 3:
            {
                blnext = dati[rednext].dat;
                vsync();
                blit(blnext,screen,0,0,510,140,80,80);
                break;
            }
            case 4:
            {
                blnext = dati[bluenext].dat;
                vsync();
                blit(blnext,screen,0,0,510,140,80,80);
                break;
            }
            case 5:
            {
                blnext = dati[purplenext].dat;
                vsync();
                blit(blnext,screen,0,0,510,140,80,80);
                break;
            }
            case 6:
            {
                blnext = dati[yellownext].dat;
                vsync();
                blit(blnext,screen,0,0,510,140,80,80);
                break;
            }
        }
        
        switch(i%7)
        {
            case 0: draw_lgreen(matrix,dati); break;
            case 1: draw_green(matrix,dati); break;
            case 2: draw_lblue(matrix,dati); break;
            case 3: draw_red(matrix,dati); break;
            case 4: draw_blue(matrix,dati); break;
            case 5: draw_purple(matrix,dati); break;
            case 6: draw_yellow(matrix,dati); break;
        }
        ctrl_matrix(matrix,dati);
    }
}
// GESTIONE GAME OVER...
void end_game(DATAFILE *dati)
{
BITMAP *image_go;
MIDI *muzic;
int exit = 0;

muzic = dati[overmidi].dat;
image_go = dati[gameover].dat;
play_midi(muzic,1);
clear(screen);
blit(image_go,screen,0,0,0,0,640,480);
show_mouse(screen);
while (!exit) if ((mouse_b & 1) && ((mouse_x > 160) && (mouse_x < 460)) && ((mouse_y > 375) && (mouse_y < 412))) exit = 1;
}

// PRIMA VIDEATA...
void videata(int matrix[10][24], DATAFILE *dati)
{
    int i, j;
    int exit = 0;
    BITMAP *back;
    MIDI *start_game;

    for (i=0;i<10;i++)
        for (j=0;j<24;j++)
        matrix[i][j] = VUOTO;
    back = dati[sfondo].dat;
    start_game = dati[intro].dat;
    play_midi(start_game,1);
    blit(back,screen,0,0,0,0,640,480);
    position_mouse(SCREEN_W/2,SCREEN_H/2);
    show_mouse(screen);

    while (!exit)
    {
        if ((mouse_b & 1) && ((mouse_x > 40) && (mouse_x < 246)) && ((mouse_y > 192) && (mouse_y < 240)))
        {
            clear(screen);
            loop(matrix,dati);
            break;
        }
        if ((mouse_b & 1) && ((mouse_x > 40) && (mouse_x < 255)) && ((mouse_y > 255) && (mouse_y < 305))) exit = 1;
    }
}

// PROGRAMMA PRINCIPALE STELLATRIS 1.0...
// MADE BY NAPOLUX...
int main()
{
    int i,j;
    int matrix[10][24];
    DATAFILE *dati = NULL;
    srand(time(NULL));
    dati = init_game(dati);
    while (!((mouse_b & 1) && ((mouse_x > 40) && (mouse_x < 255)) && ((mouse_y > 255) && (mouse_y < 305)))) videata(matrix,dati);
    exit_game();
    return 0;
}
END_OF_MAIN();
