#define NO_AI
//#define DEBUG_MALLOCS

#include "allegro.h"
#include "datafile.h"

#define PRONG_UP         0
#define PRONG_UP_RIGHT   1
#define PRONG_RIGHT      2
#define PRONG_DOWN_RIGHT 3
#define PRONG_DOWN       4
#define PRONG_DOWN_LEFT  5
#define PRONG_LEFT       6
#define PRONG_UP_LEFT    7
#define N_PRONGS         8

typedef struct {
 int prongs;
 int pods;
 int captured;
} PLAYER;

typedef struct {
 int x,y;
} XY;

typedef struct XY_LINK {
 struct XY_LINK *prev;
 int x,y;
} XY_LINK;

typedef struct BOARD_POD {
 struct BOARD_POD *under;
 int state;
 XY_LINK *jumped;
 unsigned char prong[N_PRONGS];
} BOARD_POD;

//Pod state flags
#define ST_MARKED 1
#define ST_MOVED 2
#define ST_JUMPED 4

typedef struct {
 int player;
 BOARD_POD *pod;
} BOARD_CELL;

#define MAX_PLAYERS 2

#define BOARD_W 9
#define BOARD_H 9

typedef BOARD_CELL * BOARD;//Column of pointers to rows of cells.

typedef struct {
 BOARD *board;
 PLAYER player[MAX_PLAYERS];
 int go;
} GAME;

const XY prong_dir[N_PRONGS];

GAME *game;
//BOARD *board;
//int current_player;
//PLAYER player[MAX_PLAYERS];

#ifndef NO_AI
unsigned char do_computer_turn(void);
#endif

#ifndef MALLOC_MODULE
void *malloc_e(size_t size);
#define malloc malloc_e
#ifdef DEBUG_MALLOCS
void free_e(void *ptr);
#define free free_e
#endif
#endif
