/*
 *
 *  snake.h
 *
 *  general header file for the snake program
 *  allegro Speedhack competition november 1999
 *
 *  Hein Zelle
 *
 */

#ifndef _SNAKE_H_
#define _SNAKE_H_

#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>
#include <allegro.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "body.h"
#include "player.h"
#include "bonus.h"
#include "data.h"

// constant definitions
#define MAX_PLAYERS     4
#define MAP_SIZE_X      1200
#define MAP_SIZE_Y      1200
#define END_SCORE       500

// function declarations
extern void usage();
extern int  game_loop();
extern int  init_timers();
extern void init_colors(int color_depth);
extern void high_score();

// timer functions and data
extern void game_loop_timer();
extern int  game_loop_time;
extern void bonus_timer();
extern int  bonus_time;

// global variables
extern char const *progname;

extern BITMAP *scratch;

extern DATAFILE *data;

extern int black;
extern int blue;
extern int red;
extern int green;
extern int yellow;
extern int gray;
extern int tick;

extern int rgbpal[256];
extern PALETTE mypal;

extern player *players[MAX_PLAYERS];
extern body   *bodies[MAX_PLAYERS];
extern int     nr_players;

extern SAMPLE *sample_chainsaw;
extern SAMPLE *sample_burrow;
extern SAMPLE *sample_pling;
extern SAMPLE *sample_tick;

#endif
