#ifndef _PLAYER_H_
#define _PlAYER_H_

#include <allegro.h>
#include "dirty.h"

class player
{
public:
    player();

    char const *get_name() const;
    void set_name(char const *new_name);

    void clear_keys();         // clears the _pressed flags
    void read_keys();          // read this players keys

    void crash();              // crashed into something
    
    // add a dirty rectangle to the list.
    // coordinates of the rectangle are map coordinate, we convert them
    // to viewport coordinates.
    void add_dirty_clear(m_rect map_dirty);  
    void add_dirty_clear(dirty *to_add);
    void add_dirty_redraw(m_rect map_dirty);  
    void add_dirty_redraw(dirty *to_add);
    void dirty_bonusses_clear();
    void dirty_bonusses_redraw();
    void dirty_tickmarks_clear();
    void dirty_tickmarks_redraw();
    void dirty_border_clear();
    void dirty_border_redraw();
    void update_list(dirty **list);
    void move_viewport(body *b);

    void set_viewport(int top, int bot, int left, int right);
    void init_map(int x, int y);

    void play(SAMPLE *s);
    void loop(SAMPLE *s);
    void stop();

    void draw_score();    // print score and bonus into the score_bitmap
    
    int alive;
    int score;
    int chainsaw;
    int burrow;
    int chainsaw_on;
    int burrow_on;
    int key_left;
    int key_right;
    int key_action;
    int uses_mouse;
    int color_offset;
    
    int left_pressed;
    int right_pressed;
    int action_pressed;

    int map_x;                 // coordinates of the viewport relative to
    int map_y;                 // the map

    int scroll_margin;         // minimum distance of the snake to the edge
                               // of the viewport 
    m_rect view_port;          // viewport on the screen
    int view_port_height;      // height of the viewport
    int view_port_width;       // width of the viewport
    
    BITMAP *view_bitmap;
    BITMAP *score_bitmap;

    int print_score;           // what we printed last
    int print_bonus;
    int print_type;
    
    int voice;                 // voice that is currently playing
    
    // split the dirty lists in an 'old' and a 'new' list so
    // the old items are deleted first, then the new items are drawn
    // this gives a little flicker, but it should prevent double
    // border lines
    dirty *redraw;             // 'new position'
    dirty *clear;              // 'old position'
    
private:
    char const *name;
};


#endif
