#include "snake.h"

// draw a piece of snake to indicate which player it is:
void draw_snake_piece(int p, int x, int y)
{
    for (int i = 0; i < 20; i++)
    {
	circlefill(screen, x + DEFAULT_SPEED * i, y, radius,
		   rgbpal[players[p]->color_offset + i]);
    }
}

void high_score()
{
    rectfill(screen,
	     SCREEN_W / 2 - 40 * radius - 10, 40,
	     SCREEN_W / 2 + 40 * radius + 10, 100 + 16 * radius,
	     black);

    rect(screen,
	 SCREEN_W / 2 - 40 * radius - 10, 40,
	 SCREEN_W / 2 + 40 * radius + 10, 100 + 16 * radius,
	 tick);
    
    
    textout_centre(screen, font, "--=> SCORES <=--", SCREEN_W / 2, 50, yellow);

    // print the scores on the screen
    for (int i = 0; i < nr_players; i++)
    {
	char buf[10];
	sprintf(buf, "%d", players[i]->score);
	draw_snake_piece(i, SCREEN_W / 2 - 40 * radius, 100 + 4 * radius * i);
	textout_centre(screen, font, buf,
		       SCREEN_W / 2 + 40, 96 + 4 * radius * i, yellow);
    }

    // fade the screen

    while (!key[KEY_ESC])
    {
	rest(10);
    }
    
    fade_out(1);
}
