#ifndef _BONUS_H_
#define _BONUS_H_

#include "snake.h"

// bonus class is used for dead bodyparts and for actual bonusses.
// list functions are provided as well as a recycle list

class bonus
{
public:

    enum types
    {
	dead_part = 0,
	longer,
	chainsaw,
	burrow
    };

    bonus(int type = longer);
    bonus(int type, int x, int y, int score = 0);

    void clear();
    m_rect get_rect();
    void hit(player *p, body *b);
    void draw(BITMAP *b);

    int x;
    int y;
    int type;
    int score;
    bonus *next;
};

bonus *new_bonus(int type, int x, int y, int score);
bonus *bonus_pop(bonus **list);
bonus *bonus_pop_list(bonus **list);
bonus *bonus_remove(bonus **list, bonus *elem);
void bonus_push(bonus **list, bonus *elem);
void bonus_push_list(bonus **list, bonus *elem_list);
void init_bonus(int how_many);
void add_bonus(bodypart const &bp);
void add_bonus(int type, int x, int y, int score);
void generate_bonus();
void draw_bonusses(BITMAP *b);

extern bonus *bonus_recycled;
extern bonus *bonusses;
extern int nr_bonusses;

#endif
