#ifndef _BODY_H_
#define _BODY_H_

#include "bodypart.h"

#define MAX_LENGTH      5000
#define DEFAULT_SPEED   (2 * radius - 1)
#define DELTA_DIR       15              // turn in 5 degree steps

class body
{
public:
    body(int length = 1);

    void crash();
    int cut(int index);
    
    bodypart &operator[](int index);
    bodypart &get(int index);

    void set_dir(int dir);             // set absolute direction
    void turn(int angle);              // turn a relative angle

    bodypart calc_new_pos();           // compute the next position
    void move(bodypart const &, int burrow = 0);
                                       // move the head to this position

    void init_pos(int x, int y, int angle); // set initial position
    
    double cosinus(int deg);           // sine and cosine functions
    double sinus(int deg);             // that take degrees as argument
    
    int alive;
    int head;
    int tail;
    int length;
    int dir;                           // degrees : 0 - 359
    int speed;                         // pixels
    
    bodypart snake[MAX_LENGTH];
};

extern bodypart null_part;

#endif
