#include "snake.h"

void init_colors(int color_depth)
{
    // first fill up the palette, even if we are in true color mode

    if (color_depth == 8)
    {
	mypal[1].r = 0;   // black
	mypal[1].g = 0;   // black
	mypal[1].b = 0;   // black
	mypal[2].r = 0;   // blue
	mypal[2].g = 0;   // blue
	mypal[2].b = 63;  // blue
	mypal[3].r = 63;  // red
	mypal[3].g = 0;   // red
	mypal[3].b = 0;   // red
	mypal[4].r = 0;   // green
	mypal[4].g = 63;  // green
	mypal[4].b = 0;   // green
	mypal[5].r = 63;  // yellow   
	mypal[5].g = 63;  // yellow   
	mypal[5].b = 0;   // yellow   
	mypal[6].r = 20;  // gray
	mypal[6].g = 20;  // gray
	mypal[6].b = 20;  // gray
	mypal[7].r = 30;  // tick
	mypal[7].g = 30;  // tick
	mypal[7].b = 50;  // tick

	for (int i = 0; i < 10; i++)
	{
	    // slang 1: groen-blauw
	    int offset = 100;
	    mypal[offset + i].r = 0;
	    mypal[offset + i].g = 10 + 4 * i;
	    mypal[offset + i].b = 10 + 3 * i;

	    // slang 2: oranje
	    offset = 120;
	    mypal[offset + i].r = 10 + 4 * i;
	    mypal[offset + i].g = 60 - 4 * i;
	    mypal[offset + i].b = 0;

	    // slang 2: grijs-blauw
	    offset = 140;
	    mypal[offset + i].r = 10 + 2 * i;
	    mypal[offset + i].g = 10 + 2 * i;
	    mypal[offset + i].b = 10 + 4 * i;

	    // slang 1: paars-rood
	    offset = 160;
	    mypal[offset + i].r = 15 + 4 * i;
	    mypal[offset + i].g = 0;
	    mypal[offset + i].b = 30 - i;
	}

	for (int j = 19; j >= 10; j--)
	{
	    int i = 19 - j;
	    
	    // slang 1: groen-blauw
	    int offset = 100;
	    mypal[offset + j].r = 0;
	    mypal[offset + j].g = 10 + 4 * i;
	    mypal[offset + j].b = 10 + 3 * i;

	    // slang 2: oranje
	    offset = 120;
	    mypal[offset + j].r = 10 + 4 * i;
	    mypal[offset + j].g = 60 - 4 * i;
	    mypal[offset + j].b = 0;

	    // slang 2: grijs-blauw
	    offset = 140;
	    mypal[offset + j].r = 10 + 2 * i;
	    mypal[offset + j].g = 10 + 2 * i;
	    mypal[offset + j].b = 10 + 4 * i;

	    // slang 1: paars-rood
	    offset = 160;
	    mypal[offset + j].r = 15 + 4 * i;
	    mypal[offset + j].g = 0;
	    mypal[offset + j].b = 30 - i;
	}

	// map the numbers in the rgbpal
	for (int i = 0; i < 256; i++)
	{
	    rgbpal[i] = i;
	}

	set_palette(mypal);
    }
    else
    {
	black = makecol(0, 0, 0);
	blue = makecol(0, 0, 255);
	red = makecol(255, 0, 0);
	green = makecol(0, 255, 0);
	yellow = makecol(255, 255, 0);
	gray = makecol(100, 100, 100);
	tick = makecol(120, 120, 200);
	
	rgbpal[1] = black;
	rgbpal[2] = blue;
	rgbpal[3] = red;
	rgbpal[4] = green;
	rgbpal[5] = yellow;
	rgbpal[6] = gray;
	rgbpal[7] = tick;
	
	for (int i = 0; i < 10; i++)
	{
	    // slang 1: groen-blauw
	    int offset = 100;
	    rgbpal[offset + i] = makecol(0, 40 + 16 * i, 40 + 12 * i);

	    // slang 2: oranje
	    offset = 120;
	    rgbpal[offset + i] = makecol(40 + 16 * i, 240 - 16 * i, 0);

	    // slang 2: grijs-blauw
	    offset = 140;
	    rgbpal[offset + i] = makecol(40 + 8 * i, 40 + 8 * i, 40 + 18 * i);

	    // slang 1: paars-rood
	    offset = 160;
	    rgbpal[offset + i] = makecol(60 + 16 * i, 0, 120 - 4 * i);
	}

	for (int j = 19; j >= 10; j--)
	{
	    int i = 19 - j;

	    // slang 1: groen-blauw
	    int offset = 100;
	    rgbpal[offset + j] = makecol(0, 40 + 16 * i, 40 + 12 * i);

	    // slang 2: oranje
	    offset = 120;
	    rgbpal[offset + j] = makecol(40 + 16 * i, 240 - 16 * i, 0);

	    // slang 2: grijs-blauw
	    offset = 140;
	    rgbpal[offset + j] = makecol(40 + 8 * i, 40 + 8 * i, 40 + 18 * i);

	    // slang 1: paars-rood
	    offset = 160;
	    rgbpal[offset + j] = makecol(60 + 16 * i, 0, 120 - 4 * i);
	}
    }
}
