/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *
 *      Example program showing how to write a Windows screensaver. This
 *      uses a fullscreen DirectX mode when activated normally, or the
 *      GDI interface functions when it is running in preview mode from
 *      inside the Windows screensaver selection dialog.
 *
 *      Compile this like a normal executable, but rename the output
 *      program to have a .scr extension, and then copy it into your
 *      windows directory.
 *
 *      By Shawn Hargreaves.
 *
 *      Modified for Matrix Tracer Screensaver ,By Karthik Kumar V .
 *   
 *      See readme.txt for copyright information.
 */


#include <time.h>

#include "allegro.h"
#include "winalleg.h"
#include "extver.h"
#include "alfont.h"
#include "mdef.h"

#define XRES 640
#define YRES 480
#define BPP 16

#define WINDIR getenv("WINDIR")

char dtbuf[2]={"$"};

ALFONT_FONT *alfy;
BITMAP *buf;

int prtcolor;

/* for error on load */
int lerr,preview;

/* code changer / generator */
char retchar(char orig,int flag)
{
    if(flag||((rand()%8)>5)) //Conditions to Generate Code .
    return prtstr[(rand()%prtlen)];
    return orig;
}

/* initialises tracer */
void trainit(int i)
{
    int j;
    tracers[i].pclen=((rand()%MAXLDSP)+MINLEN);
    tracers[i].x=(i*(SYMS+1));
    tracers[i].y=((rand()%(YRES+(tracers[i].pclen*(SYMS+1))))-(tracers[i].pclen*(SYMS+1)));
    tracers[i].ysp=((rand()%MAXDSP)+MINSP);
    for(j=0;j<tracers[i].pclen-1;j++)
    {
        tracers[i].string[j]=retchar(' ',1);
    }
    tracers[i].string[tracers[i].pclen-1]=' ';
}

/* initialises our graphical effect */
void ss_init(void)
{
    int i;
    lerr=0;
    prtcolor=makecol(255,0,0); /* or whatever */
    text_mode(-1);
    if(preview){return;}
    if(alfont_init()!=ALFONT_OK){lerr=1;}
    if(!lerr)
    {   /* Hopeless Win32 Programmer ... me !!!!!! */
        chdir(WINDIR); 
        /* 'coz that's where teh font should be */
        alfy = alfont_load_font(FMRS);
    }
    if(!alfy){lerr=2;}
    else
    {
        alfont_text_mode(-1);
        alfont_set_font_size(alfy,SYMS);
    }
    if(!lerr)
    {  
        NUMTRACES=(SCREEN_W/(SYMS+1));
        for(;prtstr[prtlen];prtlen++);
        srand(time(NULL));
        for(i=0;i<NUMTRACES;i++){trainit(i);}
        for(i=0;i<=NUMGRAD;i++)
        {
                //Someone please give me the right palette settings ....
                greens[NUMGRAD-i]=
                makecol(
                (int)((i*i*0.38)/NUMGRAD),
                (int)(((i*i*0.99)/NUMGRAD)+(2*i))/3,
                (int)((i*i*0.69)/NUMGRAD)
                );
        }
    }
}

/* animates the graphical effect */
void ss_update(void)
{
    int di,dj;
    for(di=0;di<NUMTRACES;di++)
    {
        for(dj=(tracers[di].pclen-1);dj>=0;dj--)
        {
                tracers[di].string[dj]=retchar(tracers[di].string[dj],0);
        }
    tracers[di].y+=tracers[di].ysp;
    if(tracers[di].y>=YRES){trainit(di);tracers[di].y=-(tracers[di].pclen*(SYMS+1));}
    }
}

/* draws the graphical effect */
void ss_draw(void)
{
    int di,dj,dx,dy;
    clear_bitmap(buf);
    if(lerr==1)
    {
        textout_centre(buf, font, ERRALFSTR, (buf->w)/2, (buf->h)/2, prtcolor);
    }
    else if(lerr==2)
    {
        textout_centre(buf, font, ERRFONTSTR, (buf->w)/2, (buf->h)/2, prtcolor);
    }
    else if(preview==1)
    {
        textout_centre(buf, font, NOPRE, (buf->w)/2, (buf->h)/2, prtcolor);
    }
    else
    {
        for(di=0;di<NUMTRACES;di++)
            {
                dx=tracers[di].x;
                dy=tracers[di].y;
                for(dj=(tracers[di].pclen-1);dj>=0;dj--)
                {
                                dtbuf[0]=tracers[di].string[dj];
                                //Someone please give me the right symbols ....
                                alfont_textout_aa(buf,alfy,dtbuf,dx,dy,greens[((dj*NUMGRAD)/(tracers[di].pclen-1))]);
                                dy+=(SYMS+1);
                }    
            }
    }  
}



/* shuts down the graphical effect */
void ss_exit(void)
{
    if(!preview)
    {
        if(alfy) alfont_destroy_font(alfy);
        if(lerr!=1)alfont_exit();
    }    
    lerr=0;
}



/* dialog procedure for the settings dialog */
BOOL CALLBACK settings_dlg_proc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
   switch (uMsg) {

      case WM_COMMAND: 
	 switch (HIWORD(wParam)) { 

	    case BN_CLICKED:
	       EndDialog(hwndDlg, 0);
	       return 1;
	 }
	 break;
   }

   return 0;
}



/* the settings dialog function */
int do_settings(HANDLE hInstance, HANDLE hPrevInstance, HWND hParentWnd)
{
   DialogBox(hInstance, SETNAME, hParentWnd, settings_dlg_proc);

   return 0;
}



/* the password dialog function */
int do_password(HANDLE hInstance, HANDLE hPrevInstance, HWND hParentWnd)
{
   MessageBox(hParentWnd, NOPWDSTR, SCRTITLE, MB_OK);

   return 0;
}



/* window procedure for the screensaver preview */
LRESULT CALLBACK preview_wnd_proc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
   PAINTSTRUCT ps;
   HDC hdc;

   switch (message) {

      case WM_CREATE:
	 SetTimer(hwnd, 1, 15, NULL);
	 return 0;

      case WM_TIMER:
	 ss_update();
	 InvalidateRect(hwnd, NULL, FALSE);
	 return 0;

      case WM_PAINT:
	 hdc = BeginPaint(hwnd, &ps);
	 preview=1;
	 ss_draw();
 	 preview=0;
	 set_palette_to_hdc(hdc, _current_palette);
	 draw_to_hdc(hdc, buf, 0, 0);
	 EndPaint(hwnd, &ps);
	 return 0;

      case WM_DESTROY:
	 KillTimer(hwnd, 1);
	 PostQuitMessage(0);
	 return 0;
   }

   return DefWindowProc(hwnd, message, wParam, lParam);
}



/* the screensaver preview function */
int do_preview(HANDLE hInstance, HANDLE hPrevInstance, HWND hParentWnd)
{
   WNDCLASS wndclass;
   HWND hwnd;
   MSG msg;
   RECT rc;

   if (!hPrevInstance) {
      wndclass.style = CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc = preview_wnd_proc;
      wndclass.cbClsExtra = 0;
      wndclass.cbWndExtra = 0;
      wndclass.hInstance = hInstance;
      wndclass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
      wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
      wndclass.hbrBackground = NULL;
      wndclass.lpszMenuName = NULL;
      wndclass.lpszClassName = CLSNAME;

      RegisterClass(&wndclass);
   }

   if (hParentWnd)
      GetClientRect(hParentWnd, &rc);
   else
      rc.right = rc.bottom = 256;

   install_allegro(SYSTEM_NONE, &errno, atexit);
   set_window_title(SCRTITLE);
   set_palette(default_palette);
   set_gdi_color_format();

   buf = create_bitmap(rc.right, rc.bottom);

   preview=1;
   ss_init();
   preview=0;

   hwnd = CreateWindow(CLSNAME, NULL, WS_CHILD, 
		       0, 0, rc.right, rc.bottom, 
		       hParentWnd, NULL, hInstance, NULL);

   ShowWindow(hwnd, SW_SHOW);
   UpdateWindow(hwnd);

   while (GetMessage(&msg, NULL, 0, 0)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }

   preview=1;
   ss_exit();
   preview=0;

   destroy_bitmap(buf);

   return msg.wParam;
}



/* display switch callback */
static int foreground = TRUE;

static void dispsw_callback(void)
{
   foreground = FALSE;
}


/* run the saver normally, in fullscreen mode */
int do_saver(HANDLE hInstance, HANDLE hPrevInstance, HWND hParentWnd)
{
   HANDLE scrsaver_mutex;
   int mx, my, t;

   /* prevent multiple instances from running */
   scrsaver_mutex = CreateMutex(NULL, TRUE, SCRTITLE);

   if (!scrsaver_mutex || (GetLastError() == ERROR_ALREADY_EXISTS))
   {
      MessageBox(hParentWnd, NOCRT, SCRTITLE, MB_OK);
      return -1;
   }

   allegro_init();
   set_window_title(SCRTITLE);
   install_keyboard();
   install_mouse();
   install_timer();
   
   /* set BPP */
   set_color_depth(BPP);
   
   /* try to set a fullscreen mode */
   if (set_gfx_mode(GFX_DIRECTX_ACCEL, XRES, YRES, 0, 0) != 0)
      if (set_gfx_mode(GFX_DIRECTX_SOFT, XRES, YRES, 0, 0) != 0)
         if (set_gfx_mode(GFX_DIRECTX_SAFE, XRES, YRES, 0, 0) != 0) {
            ReleaseMutex(scrsaver_mutex);
            MessageBox(hParentWnd, NORES, SCRTITLE, MB_OK);
            return -1;
         }

   set_display_switch_mode(SWITCH_BACKAMNESIA);  /* not SWITCH_AMNESIA */
   set_display_switch_callback(SWITCH_OUT, dispsw_callback);

   buf = create_bitmap(SCREEN_W, SCREEN_H);

   ss_init();

   mx = mouse_x;
   my = mouse_y;

   t = retrace_count;

   while (foreground && (!keypressed()) && (!mouse_b) && (mouse_x == mx) && (mouse_y == my)) {
      while (t < retrace_count) {
	  t++;
      }
      
      ss_draw();
      ss_update(); /* should suffice */
      blit(buf, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
       
      poll_mouse();
   }

   ss_exit();
   destroy_bitmap(buf);

   ReleaseMutex(scrsaver_mutex);
   return 0;
}



/* the main program body */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
   HWND hwnd;
   char *args;

   args = lpszCmdParam;
   
   if ((args[0] == '-') || (args[0] == '/'))
      args++;

   if ((args[0]) && ((args[1] == ' ') || (args[1] == ':')))
      hwnd = (HWND)atoi(args+2);
   else
      hwnd = GetActiveWindow();

   switch (utolower(args[0])) {

      case 'c':
	 return do_settings(hInstance, hPrevInstance, hwnd);

      case 'a':
	 return do_password(hInstance, hPrevInstance, hwnd);

      case 'p':
	 return do_preview(hInstance, hPrevInstance, hwnd);

      case 's':
	 return do_saver(hInstance, hPrevInstance, hwnd);
   }

   return 0;
}
