//A Demo .

#include "ver.h"
#include "stdio.h"
#include "allegro.h"
#include "alfont.h"
#include "mdef.h"

//Renderer .
#define render() blit(mbuffer,screen,0,0,0,0,XRES,YRES)
#define cls() clear_bitmap(mbuffer) 

//Error Stuff .
#define E_OK 0
#define E_ERR -1

//GFX
#define GM GFX_AUTODETECT //_FULLSCREEN
#define XRES 640
#define YRES 480
#define BPP 16

//Frames
#define FT 50

//BMP Props .
BITMAP *mbuffer;
ALFONT_FONT *alfy;

//Draw Loop .
int di,dj,dx,dy;
char dtbuf[2]={"$"};

int sysinit()
{
allegro_init();
set_window_title(TITLE);
if(alfont_init()!=ALFONT_OK){return -1;}
if(install_timer()){return -1;}
if(install_keyboard()){return -1;}
set_color_depth(BPP);
if(set_gfx_mode(GM,XRES,YRES,0,0)){return -1;}
return 0;
}

void sysexit()
{
alfont_exit();
allegro_exit();
}

void munload()
{
if(alfy) alfont_destroy_font(alfy);
if(mbuffer) destroy_bitmap(mbuffer);
}

int mload()
{
mbuffer=create_bitmap(XRES,YRES);
if(!mbuffer){munload();return -1;}
alfy = alfont_load_font(FMRS);
if(!alfy){munload();return -1;}
alfont_text_mode(-1);
return 0;
}

void setrand()
{
srand(time(NULL));
}

char retchar(char orig,int flag)
{
if(flag||((rand()%8)>5)) //Conditions to Generate Code .
return prtstr[(rand()%prtlen)];
return orig;
}

void trainit(int i)
{
int j;
tracers[i].pclen=((rand()%MAXLDSP)+MINLEN);
tracers[i].x=(i*(SYMS+1));
tracers[i].y=((rand()%(YRES+(tracers[i].pclen*(SYMS+1))))-(tracers[i].pclen*(SYMS+1)));
tracers[i].ysp=((rand()%MAXDSP)+MINSP);
for(j=0;j<tracers[i].pclen-1;j++)
{
tracers[i].string[j]=retchar(' ',1);
}
tracers[i].string[tracers[i].pclen-1]=' ';
}

void drawstuff()
{
cls();
for(di=0;di<NUMTRACES;di++)
{
dx=tracers[di].x;
dy=tracers[di].y;
for(dj=(tracers[di].pclen-1);dj>=0;dj--)
{
dtbuf[0]=tracers[di].string[dj];
tracers[di].string[dj]=retchar(tracers[di].string[dj],0);
//Someone please give me the right symbols ....
alfont_textout(mbuffer,alfy,dtbuf,dx,dy,greens[((dj*NUMGRAD)/(tracers[di].pclen-1))]);
dy+=(SYMS+1);
}
tracers[di].y+=tracers[di].ysp;
if(tracers[di].y>=YRES){trainit(di);tracers[di].y=-(tracers[di].pclen*(SYMS+1));}
}
render();
}

void loop()
{
int done=0,i;
if(MAXLDSP<=0){return;}
NUMTRACES=(XRES/(SYMS+1));if(NUMTRACES<=0){return;}
alfont_set_font_size(alfy,SYMS);
for(;prtstr[prtlen];prtlen++);if(prtlen<=0){return;}
for(i=0;i<=NUMGRAD;i++)
{
//Someone please give me the right palette settings ....
greens[NUMGRAD-i]=
makecol(
(int)((i*i*0.38)/NUMGRAD),
(int)(((i*i*0.99)/NUMGRAD)+(2*i))/3,
(int)((i*i*0.69)/NUMGRAD)
);
}
setrand();for(i=0;i<NUMTRACES;i++){trainit(i);}
clear_keybuf(); 
do
{
drawstuff();
if(keypressed())if(key[KEY_ESC])done=1;
rest(FT); //Frame Timer !
}
while(!done);
clear_keybuf(); 
}

int main(int argc,char *argv[STRB])
{
if(sysinit()<0)
{
return E_ERR;
}
if(mload()<0)
{
allegro_message("Error Loading Stuff !");
sysexit();
return E_ERR;
}
loop();
munload();
sysexit();
return E_OK;
}

//Required !
END_OF_MAIN();
