#include <allegro.h>
#include <time.h>
#include <math.h>

const double PI = 3.14159265;
                
void mem_putpixel_16(BITMAP *bmp, int x, int y, int color)
{
	if(x>=0 && x<SCREEN_W && y >= 0 && y< SCREEN_H) ((short *)bmp->line[y])[x] = color;
}

// modified line routine for calculating the exact line-size

int calc_line_size(int x1, int y1, int x2, int y2)
{
   int dx = x2-x1;
   int dy = y2-y1;
   int i1, i2;
   int x, y;
   int dd;
   int ret = 0;

   /* worker macro */
   #define LINESIZE_DO_LINE(pri_sign, pri_c, pri_cond, sec_sign, sec_c, sec_cond)	\
   {                                                                         			\
      if (d##pri_c == 0) {                                                   			\
	 ret++;                                														\
	 return ret;                                                             			\
      }                                                                      			\
									     																		\
      i1 = 2 * d##sec_c;                                                     			\
      dd = i1 - (sec_sign (pri_sign d##pri_c));                              \
      i2 = dd - (sec_sign (pri_sign d##pri_c));                              \
									     															  \
      x = x1;                                                                \
      y = y1;                                                                \
									     															  \
      while (pri_c pri_cond pri_c##2) {                                      \
	 ret++;                                                 					\
									     														\
	 if (dd sec_cond 0) {                                                \
	    sec_c sec_sign##= 1;                                             \
	    dd += i2;                                                        \
	 }                                                                   \
	 else                                                                \
	    dd += i1;                                                        \
									     														\
	 pri_c pri_sign##= 1;                                                \
      }                                                                 \
   }

   if (dx >= 0) {
      if (dy >= 0) {
	 if (dx >= dy) {
	    /* (x1 <= x2) && (y1 <= y2) && (dx >= dy) */
	    LINESIZE_DO_LINE(+, x, <=, +, y, >=);
	 }
	 else {
	    /* (x1 <= x2) && (y1 <= y2) && (dx < dy) */
	    LINESIZE_DO_LINE(+, y, <=, +, x, >=);
	 }
      }
      else {
	 if (dx >= -dy) {
	    /* (x1 <= x2) && (y1 > y2) && (dx >= dy) */
	    LINESIZE_DO_LINE(+, x, <=, -, y, <=);
	 }
	 else {
	    /* (x1 <= x2) && (y1 > y2) && (dx < dy) */
	    LINESIZE_DO_LINE(-, y, >=, +, x, >=);
	 }
      }
   }
   else {
      if (dy >= 0) {
	 if (-dx >= dy) {
	    /* (x1 > x2) && (y1 <= y2) && (dx >= dy) */
	    LINESIZE_DO_LINE(-, x, >=, +, y, >=);
	 }
	 else {
	    /* (x1 > x2) && (y1 <= y2) && (dx < dy) */
	    LINESIZE_DO_LINE(+, y, <=, -, x, <=);
	 }
      }
      else {
	 if (-dx >= -dy) {
	    /* (x1 > x2) && (y1 > y2) && (dx >= dy) */
	    LINESIZE_DO_LINE(-, x, >=, -, y, <=);
	 }
	 else {
	    /* (x1 > x2) && (y1 > y2) && (dx < dy) */
	    LINESIZE_DO_LINE(-, y, >=, -, x, <=);
	 }
      }
   }

   return(ret);
}

// modfied version of the allegro line routine, maybe not so effecient
// but it works. 
// dividing the R/G/B differences between color1 & color2 by the line size 
// will give the R/G/B increase per pixel.

void gradient_line(BITMAP* bmp, int x1, int y1, int x2, int y2, int col1, int col2)
{  
    int r1 = getr(col1);
    int g1 = getg(col1);
    int b1 = getb(col1);

    int r2 = getr(col2);
    int g2 = getg(col2);
    int b2 = getb(col2);
    
    float rinc;
    float ginc;
    float binc;
    
    int size = calc_line_size(x1, y1, x2, y2);;
    
    if(r2 >= r1) rinc = float((r2-r1)/float(size));
    else rinc = -float((r1-r2)/float(size));

    if(g2 >= g1) ginc = float((g2-g1)/float(size));
    else ginc = -float((g1-g2)/float(size));

    if(b2 >= b1) binc = float((b2-b1)/float(size));
    else binc = -float((b1-b2)/float(size));
    
    float r = r1;
    float g = g1;
    float b = b1;

    // draw line

   int dx = x2-x1;
   int dy = y2-y1;
   int i1, i2;
   int x, y;
   int dd;

   /* worker macro */
   #define GRAD_DO_LINE(pri_sign, pri_c, pri_cond, sec_sign, sec_c, sec_cond)     \
   {                                                                         \
      if (d##pri_c == 0) 									\
      {                                         	\
        mem_putpixel_16(bmp, x, y, makecol16(int(r), int(g), int(b))); \
        r += rinc;											\
        g += ginc;											\
        b += binc;											\
      }                                            \
									     							\
      i1 = 2 * d##sec_c;                           \
      dd = i1 - (sec_sign (pri_sign d##pri_c));    \
      i2 = dd - (sec_sign (pri_sign d##pri_c));    \
      					 								      \
      x = x1;                                      \
      y = y1;                                      \
									     							\
      while (pri_c pri_cond pri_c##2) 					\
      {            											\
        mem_putpixel_16(bmp, x, y, makecol16(int(r), int(g), int(b))); \
        r += rinc;											\
        g += ginc;											\
        b += binc;											\
									     							\
			if (dd sec_cond 0) {                      \
	    	sec_c sec_sign##= 1;                      \
	    	dd += i2;                                 \
	   }                                            \
	 else                                           \
	    dd += i1;                                   \
		 pri_c pri_sign##= 1;                        \
      }                                            \
   } 

   if (dx >= 0) {
      if (dy >= 0) {
	 if (dx >= dy) {
	    /* (x1 <= x2) && (y1 <= y2) && (dx >= dy) */
	    GRAD_DO_LINE(+, x, <=, +, y, >=);
	 }
	 else {
	    /* (x1 <= x2) && (y1 <= y2) && (dx < dy) */
	    GRAD_DO_LINE(+, y, <=, +, x, >=);
	 }
      }
      else {
	 if (dx >= -dy) {
	    /* (x1 <= x2) && (y1 > y2) && (dx >= dy) */
	    GRAD_DO_LINE(+, x, <=, -, y, <=);
	 }
	 else {
	    /* (x1 <= x2) && (y1 > y2) && (dx < dy) */
	    GRAD_DO_LINE(-, y, >=, +, x, >=);
	 }
      }
   }
   else {
      if (dy >= 0) {
	 if (-dx >= dy) {
	    /* (x1 > x2) && (y1 <= y2) && (dx >= dy) */
	    GRAD_DO_LINE(-, x, >=, +, y, >=);
	 }
	 else {
	    /* (x1 > x2) && (y1 <= y2) && (dx < dy) */
	    GRAD_DO_LINE(+, y, <=, -, x, <=);
	 }
      }
      else {
	 if (-dx >= -dy) {
	    /* (x1 > x2) && (y1 > y2) && (dx >= dy) */
	    GRAD_DO_LINE(-, x, >=, -, y, <=);
	 }
	 else {
	    /* (x1 > x2) && (y1 > y2) && (dx < dy) */
	    GRAD_DO_LINE(-, y, >=, -, x, <=);
	 }
      }
   }

}

const int TABLE_SIZE = 360;                 
                  
struct rotation_point
{
	rotation_point();
   int index, dir, speed, color;
   void update();
};

rotation_point::rotation_point()
{
	index = 0; dir = 1; speed = 0; color = makecol(255,255,255);
}

void rotation_point::update() 
{ 
   index += speed * dir; 
   if (index >= TABLE_SIZE) index = 1;
   if(index <= 0) index = TABLE_SIZE-1;
}

class mover
{
   public:
    mover(int xpos, int ypos, int _circle_radius, int _Npoints, int _color, int _color2);
    mover();
    ~mover();
    void init(int xpos, int ypos, int _circle_radius, int _Npoints, int _color, int _color2);
    void draw(BITMAP *bmp);
    void draw(int _x, int _y, BITMAP *bmp);
    void update();
    void move();
    void change_radius(int radius);

    int get_X() { return (circle_xpos); }
    int get_Y() { return (circle_ypos); }
    int get_radius() { return (circle_radius); }
        
   private: 
    int circle_radius, circle_xpos, circle_ypos;
    int Xtable[TABLE_SIZE], Ytable[TABLE_SIZE];   
    int Npoints;
    rotation_point* points;
    int color, color2;
    
    int dx, dy;
};

mover::mover()
{
}

mover::mover(int xpos, int ypos, int _circle_radius, int _Npoints, int _color, int _color2):
circle_xpos(xpos), circle_ypos(ypos), circle_radius(_circle_radius), color(_color), color2(_color2)
{
   dx = -5 + rand()%10; 
   dy = -5 + rand()%10;
   Npoints = _Npoints;
   points = new rotation_point[Npoints];
   
   for(int c=0; c<TABLE_SIZE; c++) 
   {
      Xtable[c] = int(cos(c*PI/180) * _circle_radius);
      Ytable[c] = int(sin(c*PI/180) * _circle_radius);
   }      

   int pcolor = color;
   int direction;
   if(rand()%10 >= 5) direction = 1;
      else direction = -1;

   for(int c=0; c<Npoints; c++) 
   {
      points[c].index = 3 + rand()%(TABLE_SIZE-6);
      points[c].dir = direction;
      points[c].speed = rand()%5 + 2;       
      points[c].color = pcolor;
      if(pcolor == color) pcolor = color2;
      else pcolor = color;
   }     
}

void mover::init(int xpos, int ypos, int _circle_radius, int _Npoints, int _color, int _color2)
{
    circle_xpos = xpos;
	circle_ypos = ypos;
	circle_radius = _circle_radius;
	color = _color;
	color2 = _color2;
	dx = -5 + rand()%10; 
	dy = -5 + rand()%10;
	Npoints = _Npoints;
	points = new rotation_point[Npoints];
	
	for(int c=0; c<TABLE_SIZE; c++) 
	{
	  Xtable[c] = int(cos(c) * circle_radius);
      Ytable[c] = int(sin(c) * circle_radius);      
    }      

   for(int c=0; c<Npoints; c++) 
   {
      points[c].index = rand()%TABLE_SIZE;
      points[c].dir = -1;
      points[c].speed = rand()%5 + 1;                          
      points[c].color = color;
   }     
}

mover::~mover()
{
   delete[] points; 
}

void mover::update()
{
   for(int c=0; c<Npoints; c++) points[c].update();
}

void mover::draw(int _x, int _y,  BITMAP *bmp)
{
   for(int c=0; c<Npoints; c++)
   gradient_line(bmp, (_x + circle_xpos) + Xtable[points[c].index], 
             (_y + circle_ypos) + Ytable[points[c].index],
             (_x + circle_xpos) + Xtable[points[c+1>=Npoints ? 0 : c+1].index],
             (_y + circle_ypos) + Ytable[points[c+1>=Npoints ? 0 : c+1].index], points[c].color, points[c+1>=Npoints ? 0 : c+1].color); 
}

void mover::draw(BITMAP *bmp)
{
	draw(0,0, bmp);                        
}

void mover::move()
{
   circle_xpos += dx;
   circle_ypos += dy;
   if(circle_xpos+circle_radius >= SCREEN_W) dx = -(dx);
   if(circle_xpos-circle_radius <= 0) dx = -(dx);
   if(circle_ypos+circle_radius >= SCREEN_H) dy = -(dy);
   if(circle_ypos-circle_radius <= 0) dy = -(dy);
}

volatile int logic_count = 0;

void logic_counter()
{
   logic_count++;
} END_OF_FUNCTION(logic_count)


bool show_fps = false;
volatile int fps = 0;
volatile int fpscount = 0;

void fps_counter()
{
	fps = fpscount;
   fpscount = 0;
} END_OF_FUNCTION(fps_counter)


int main()
{
   srand(time(NULL));
   allegro_init();
   install_timer();
   install_int_ex(logic_counter, BPS_TO_TIMER(50));
   install_int_ex(fps_counter, SECS_TO_TIMER(1));

   set_color_depth(16);
   if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 640, 480) < 0)
   {
      allegro_message("Error setting video mode %s", allegro_error);   
      exit(1);
   }

   install_keyboard();
   BITMAP *buf = create_bitmap(SCREEN_W, SCREEN_H);
     
   mover m(200,200,130,7, makecol(60, 110, 240), makecol(250, 10, 40));
   mover m1(300,300,100,6, makecol(220, 250, 30), makecol(220, 100, 40));
   mover m2(400,300,150,4, makecol(10, 80, 10), makecol(160, 250, 50));
   mover m3(140,140,120,5, makecol(250, 250, 10), makecol(0, 250, 250));
             
   while(!key[KEY_ESC])
   {

      while(logic_count > 0)
      {   
         m.update();
         m1.update();
         m2.update();
         m3.update();
         
         m.move();
         m1.move();
         m2.move();
         m3.move();            
         
         logic_count--;
      }

      const int mover_size = 10;
      const int mover_spacing = 4;

      for(int c=0; c<mover_size; c++)
      {
        m.draw(0,c*mover_spacing,buf);
        m1.draw(0,c*mover_spacing,buf);      	
        m2.draw(0,c*mover_spacing,buf);      	
        m3.draw(0,c*mover_spacing,buf);      	      	
      }          
           
      blit(buf, screen, 0, 0, 0, 0,SCREEN_W, SCREEN_H);
      
      if (show_fps) textprintf(screen, font, SCREEN_W-75, 2, makecol(255,255,255), "fps: %d", fps);
      
      if (key[KEY_F12]) { save_bmp("screenshot.bmp", buf, NULL); key[KEY_F12] = false; }
      if (key[KEY_F1]) { if(show_fps) show_fps=false; else show_fps = true; key[KEY_F1] = false; }
      
      clear_to_color(buf,makecol(0,0,0));  
      fpscount++;
   }   
   
   destroy_bitmap(buf);   

   return 0;

} END_OF_MAIN();
