#include <inc/engine.hpp>

Engine::Engine(void) {

  // Window dimensions.
  w_width = 0;
  w_height = 0;

  render = true;
  is_running = true;
  is_updating = false;

  timer = NULL;
  display = NULL;
  event_queue = NULL;
}

bool Engine::isKey(const int key_code) {

  if (event.keyboard.keycode == key_code) {

    return true;
  }

  return false;
}

bool Engine::isRunning(void) {

  return is_running;
}

bool Engine::isKeyPressed(void) {

  if (event.type == ALLEGRO_EVENT_KEY_DOWN) {

    return true;
  }

  return false;
}

bool Engine::isKeyReleased(void) {

  if (event.type == ALLEGRO_EVENT_KEY_UP) {

    return true;
  }

  return false;
}

bool Engine::isRenderPhase(void) {

  //return is_updating;

  if (render && al_event_queue_is_empty(event_queue)) {

    render = false;

    return true;
  }

  return false;
}

bool Engine::isUpdatePhase(void) {

  if (event.type == ALLEGRO_EVENT_TIMER) {

    render = true;

    return true;
  }

  return false;

  /*if (!is_updating && al_is_event_queue_empty(event_queue)) {

    return true;
  }

  return false;*/
}

void Engine::flipPhase(void) {

  if (is_updating) {

    is_updating = false;
  }
  else {

    is_updating = true;
  }
}

void Engine::stopTimer(void) {

  al_stop_timer(timer);
}

void Engine::initialize(const unsigned int w, const unsigned int h, const string t) {

  // Get the window's dimensions.
  w_width = w;
  w_height = h;

  // Initialize Allegro 5.
  checkReturn(al_init());

  // Initialize and install addons.
  checkReturn(al_install_audio());
  checkReturn(al_init_ttf_addon());
  checkReturn(al_init_font_addon());
  checkReturn(al_init_image_addon());
  checkReturn(al_install_keyboard());
  checkReturn(al_init_acodec_addon());
  checkReturn(al_init_primitives_addon());

  // Use vertical sync when possible.
  al_set_new_display_option(ALLEGRO_VSYNC, 1, ALLEGRO_SUGGEST);

  // Create events.
  timer = al_create_timer(1.0 / 60.0);
  display = al_create_display(w, h);
  event_queue = al_create_event_queue();

  // Check the events for initialization errors.
  checkReturn(timer);
  checkReturn(display);
  checkReturn(event_queue);

  // Give the window a display title.
  al_set_window_title(display, t.c_str());

  al_register_event_source(event_queue, al_get_keyboard_event_source());
  al_register_event_source(event_queue, al_get_timer_event_source(timer));
  al_register_event_source(event_queue, al_get_display_event_source(display));
}

void Engine::startTimer(void) {

  al_start_timer(timer);
}

void Engine::checkReturn(const bool condition) {

  if (!condition) {

    // A critical condition was not met. End the game.
    is_running = false;

    cout << "Error: a critical condition was not met (maybe missing data assets)!\n";
  }
}

void Engine::flipDisplay(void) {

  al_flip_display();

  al_clear_to_color(al_map_rgb(0, 0, 0));
}

void Engine::reserveSamples(const unsigned int number_of_samples) {

  al_reserve_samples(number_of_samples);
}

void Engine::checkEventQueue(void) {

  al_wait_for_event(event_queue, &event);
}

void Engine::setDisplayScale(const float scale) {

  ALLEGRO_TRANSFORM transform;

  al_identity_transform(&transform);

  al_scale_transform(&transform, scale, scale);

  al_use_transform(&transform);
}

void Engine::setResourcePath(const string resource_directory) {

  ALLEGRO_PATH *path = al_get_standard_path(ALLEGRO_RESOURCES_PATH);

  al_append_path_component(path, resource_directory.c_str());

  al_change_directory(al_path_cstr(path, '/'));

  al_destroy_path(path);
}

void Engine::destroyResources(void) {

  al_destroy_timer(timer);
  al_destroy_display(display);
  al_destroy_event_queue(event_queue);
}

void Engine::manageWindowEvents(void) {

  /*if (event.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {

    // The window was closed; end the game.
    is_running = false;
  }
  else if (event.type == ALLEGRO_EVENT_KEY_DOWN) {

    if (event.keyboard.keycode == ALLEGRO_KEY_ESCAPE) {

      // Close the window and end the game.
      is_running = false;
    }
  }*/
}

ALLEGRO_EVENT &Engine::getEvent(void) {

  return event;
}

void Engine::end(void) {

  is_running = false;
}
